/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.chrono;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.chrono.ChronoLocalDate;
import oz.threeten.bp.chrono.ChronoLocalDateTime;
import oz.threeten.bp.chrono.ChronoZonedDateTime;
import oz.threeten.bp.chrono.ChronoZonedDateTimeImpl;
import oz.threeten.bp.chrono.Ser;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAdjuster;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.ValueRange;

final class ChronoLocalDateTimeImpl
extends ChronoLocalDateTime
implements Serializable,
Temporal,
TemporalAdjuster {
    private static final long serialVersionUID = 4556003607393004514L;
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int MINUTES_PER_DAY = 1440;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;
    private static final long MILLIS_PER_DAY = 86400000L;
    private static final long MICROS_PER_DAY = 86400000000L;
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final long NANOS_PER_MINUTE = 60000000000L;
    private static final long NANOS_PER_HOUR = 3600000000000L;
    private static final long NANOS_PER_DAY = 86400000000000L;
    private final ChronoLocalDate date;
    private final LocalTime time;

    static ChronoLocalDateTimeImpl of(ChronoLocalDate chronoLocalDate, LocalTime localTime) {
        return new ChronoLocalDateTimeImpl(chronoLocalDate, localTime);
    }

    private ChronoLocalDateTimeImpl(ChronoLocalDate chronoLocalDate, LocalTime localTime) {
        Jdk8Methods.requireNonNull(chronoLocalDate, "date");
        Jdk8Methods.requireNonNull(localTime, "time");
        this.date = chronoLocalDate;
        this.time = localTime;
    }

    private ChronoLocalDateTimeImpl with(Temporal temporal, LocalTime localTime) {
        if (this.date == temporal && this.time == localTime) {
            return this;
        }
        ChronoLocalDate chronoLocalDate = this.date.getChronology().ensureChronoLocalDate(temporal);
        return new ChronoLocalDateTimeImpl(chronoLocalDate, localTime);
    }

    public ChronoLocalDate toLocalDate() {
        return this.date;
    }

    public LocalTime toLocalTime() {
        return this.time;
    }

    public boolean isSupported(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField.isDateBased() || temporalField.isTimeBased();
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    public boolean isSupported(TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit.isDateBased() || temporalUnit.isTimeBased();
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField.isTimeBased() ? this.time.range(temporalField) : this.date.range(temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    public int get(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField.isTimeBased() ? this.time.get(temporalField) : this.date.get(temporalField);
        }
        return this.range(temporalField).checkValidIntValue(this.getLong(temporalField), temporalField);
    }

    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField.isTimeBased() ? this.time.getLong(temporalField) : this.date.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    public ChronoLocalDateTimeImpl with(TemporalAdjuster temporalAdjuster) {
        if (temporalAdjuster instanceof ChronoLocalDate) {
            return this.with((ChronoLocalDate)temporalAdjuster, this.time);
        }
        if (temporalAdjuster instanceof LocalTime) {
            return this.with(this.date, (LocalTime)temporalAdjuster);
        }
        if (temporalAdjuster instanceof ChronoLocalDateTimeImpl) {
            return this.date.getChronology().ensureChronoLocalDateTime((ChronoLocalDateTimeImpl)temporalAdjuster);
        }
        return this.date.getChronology().ensureChronoLocalDateTime((ChronoLocalDateTimeImpl)temporalAdjuster.adjustInto(this));
    }

    public ChronoLocalDateTimeImpl with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            if (temporalField.isTimeBased()) {
                return this.with(this.date, this.time.with(temporalField, l));
            }
            return this.with(this.date.with(temporalField, l), this.time);
        }
        return this.date.getChronology().ensureChronoLocalDateTime(temporalField.adjustInto(this, l));
    }

    public ChronoLocalDateTimeImpl plus(long l, TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            switch (chronoUnit) {
                case NANOS: {
                    return this.plusNanos(l);
                }
                case MICROS: {
                    return this.plusDays(l / 86400000000L).plusNanos(l % 86400000000L * 1000L);
                }
                case MILLIS: {
                    return this.plusDays(l / 86400000L).plusNanos(l % 86400000L * 1000000L);
                }
                case SECONDS: {
                    return this.plusSeconds(l);
                }
                case MINUTES: {
                    return this.plusMinutes(l);
                }
                case HOURS: {
                    return this.plusHours(l);
                }
                case HALF_DAYS: {
                    return this.plusDays(l / 256L).plusHours(l % 256L * 12L);
                }
            }
            return this.with(this.date.plus(l, temporalUnit), this.time);
        }
        return this.date.getChronology().ensureChronoLocalDateTime(temporalUnit.addTo(this, l));
    }

    private ChronoLocalDateTimeImpl plusDays(long l) {
        return this.with(this.date.plus(l, ChronoUnit.DAYS), this.time);
    }

    private ChronoLocalDateTimeImpl plusHours(long l) {
        return this.plusWithOverflow(this.date, l, 0L, 0L, 0L);
    }

    private ChronoLocalDateTimeImpl plusMinutes(long l) {
        return this.plusWithOverflow(this.date, 0L, l, 0L, 0L);
    }

    ChronoLocalDateTimeImpl plusSeconds(long l) {
        return this.plusWithOverflow(this.date, 0L, 0L, l, 0L);
    }

    private ChronoLocalDateTimeImpl plusNanos(long l) {
        return this.plusWithOverflow(this.date, 0L, 0L, 0L, l);
    }

    private ChronoLocalDateTimeImpl plusWithOverflow(ChronoLocalDate chronoLocalDate, long l, long l2, long l3, long l4) {
        if ((l | l2 | l3 | l4) == 0L) {
            return this.with(chronoLocalDate, this.time);
        }
        long l5 = l4 / 86400000000000L + l3 / 86400L + l2 / 1440L + l / 24L;
        long l6 = l4 % 86400000000000L + l3 % 86400L * 1000000000L + l2 % 1440L * 60000000000L + l % 24L * 3600000000000L;
        long l7 = this.time.toNanoOfDay();
        long l8 = Jdk8Methods.floorMod(l6, 86400000000000L);
        LocalTime localTime = l8 == l7 ? this.time : LocalTime.ofNanoOfDay(l8);
        return this.with(chronoLocalDate.plus(l5 += Jdk8Methods.floorDiv(l6 += l7, 86400000000000L), ChronoUnit.DAYS), localTime);
    }

    public ChronoZonedDateTime atZone(ZoneId zoneId) {
        return ChronoZonedDateTimeImpl.ofBest(this, zoneId, null);
    }

    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        ChronoLocalDateTime chronoLocalDateTime = this.toLocalDate().getChronology().localDateTime(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            if (chronoUnit.isTimeBased()) {
                long l = chronoLocalDateTime.getLong(ChronoField.EPOCH_DAY) - this.date.getLong(ChronoField.EPOCH_DAY);
                switch (chronoUnit) {
                    case NANOS: {
                        l = Jdk8Methods.safeMultiply(l, 86400000000000L);
                        break;
                    }
                    case MICROS: {
                        l = Jdk8Methods.safeMultiply(l, 86400000000L);
                        break;
                    }
                    case MILLIS: {
                        l = Jdk8Methods.safeMultiply(l, 86400000L);
                        break;
                    }
                    case SECONDS: {
                        l = Jdk8Methods.safeMultiply(l, 86400);
                        break;
                    }
                    case MINUTES: {
                        l = Jdk8Methods.safeMultiply(l, 1440);
                        break;
                    }
                    case HOURS: {
                        l = Jdk8Methods.safeMultiply(l, 24);
                        break;
                    }
                    case HALF_DAYS: {
                        l = Jdk8Methods.safeMultiply(l, 2);
                    }
                }
                return Jdk8Methods.safeAdd(l, this.time.until(chronoLocalDateTime.toLocalTime(), temporalUnit));
            }
            ChronoLocalDate chronoLocalDate = chronoLocalDateTime.toLocalDate();
            if (chronoLocalDateTime.toLocalTime().isBefore(this.time)) {
                chronoLocalDate = chronoLocalDate.minus(1L, ChronoUnit.DAYS);
            }
            return this.date.until(chronoLocalDate, temporalUnit);
        }
        return temporalUnit.between(this, chronoLocalDateTime);
    }

    private Object writeReplace() {
        return new Ser(12, this);
    }

    void writeExternal(ObjectOutput objectOutput) {
        objectOutput.writeObject(this.date);
        objectOutput.writeObject(this.time);
    }

    static ChronoLocalDateTime readExternal(ObjectInput objectInput) {
        ChronoLocalDate chronoLocalDate = (ChronoLocalDate)objectInput.readObject();
        LocalTime localTime = (LocalTime)objectInput.readObject();
        return chronoLocalDate.atTime(localTime);
    }
}

