/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.chrono;

import java.util.Comparator;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.Instant;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.chrono.ChronoLocalDate;
import oz.threeten.bp.chrono.ChronoLocalDateTime;
import oz.threeten.bp.chrono.ChronoZonedDateTime$1;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.format.DateTimeFormatter;
import oz.threeten.bp.jdk8.DefaultInterfaceTemporal;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalAdjuster;
import oz.threeten.bp.temporal.TemporalAmount;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalQueries;
import oz.threeten.bp.temporal.TemporalQuery;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.UnsupportedTemporalTypeException;
import oz.threeten.bp.temporal.ValueRange;

public abstract class ChronoZonedDateTime
extends DefaultInterfaceTemporal
implements Comparable,
Temporal {
    private static Comparator INSTANT_COMPARATOR = new ChronoZonedDateTime$1();

    public static Comparator timeLineOrder() {
        return INSTANT_COMPARATOR;
    }

    public static ChronoZonedDateTime from(TemporalAccessor temporalAccessor) {
        Jdk8Methods.requireNonNull(temporalAccessor, "temporal");
        if (temporalAccessor instanceof ChronoZonedDateTime) {
            return (ChronoZonedDateTime)temporalAccessor;
        }
        Chronology chronology = (Chronology)temporalAccessor.query(TemporalQueries.chronology());
        if (chronology == null) {
            throw new DateTimeException("No Chronology found to create ChronoZonedDateTime: " + temporalAccessor.getClass());
        }
        return chronology.zonedDateTime(temporalAccessor);
    }

    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.INSTANT_SECONDS || temporalField == ChronoField.OFFSET_SECONDS) {
                return temporalField.range();
            }
            return this.toLocalDateTime().range(temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    public int get(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case INSTANT_SECONDS: {
                    throw new UnsupportedTemporalTypeException("Field too large for an int: " + temporalField);
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.toLocalDateTime().get(temporalField);
        }
        return super.get(temporalField);
    }

    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case INSTANT_SECONDS: {
                    return this.toEpochSecond();
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.toLocalDateTime().getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    public ChronoLocalDate toLocalDate() {
        return this.toLocalDateTime().toLocalDate();
    }

    public LocalTime toLocalTime() {
        return this.toLocalDateTime().toLocalTime();
    }

    public abstract ChronoLocalDateTime toLocalDateTime();

    public Chronology getChronology() {
        return this.toLocalDate().getChronology();
    }

    public abstract ZoneOffset getOffset();

    public abstract ZoneId getZone();

    public abstract ChronoZonedDateTime withEarlierOffsetAtOverlap();

    public abstract ChronoZonedDateTime withLaterOffsetAtOverlap();

    public abstract ChronoZonedDateTime withZoneSameLocal(ZoneId var1);

    public abstract ChronoZonedDateTime withZoneSameInstant(ZoneId var1);

    public ChronoZonedDateTime with(TemporalAdjuster temporalAdjuster) {
        return this.toLocalDate().getChronology().ensureChronoZonedDateTime(super.with(temporalAdjuster));
    }

    public abstract ChronoZonedDateTime with(TemporalField var1, long var2);

    public ChronoZonedDateTime plus(TemporalAmount temporalAmount) {
        return this.toLocalDate().getChronology().ensureChronoZonedDateTime(super.plus(temporalAmount));
    }

    public abstract ChronoZonedDateTime plus(long var1, TemporalUnit var3);

    public ChronoZonedDateTime minus(TemporalAmount temporalAmount) {
        return this.toLocalDate().getChronology().ensureChronoZonedDateTime(super.minus(temporalAmount));
    }

    public ChronoZonedDateTime minus(long l, TemporalUnit temporalUnit) {
        return this.toLocalDate().getChronology().ensureChronoZonedDateTime(super.minus(l, temporalUnit));
    }

    public Object query(TemporalQuery temporalQuery) {
        if (temporalQuery == TemporalQueries.zoneId() || temporalQuery == TemporalQueries.zone()) {
            return this.getZone();
        }
        if (temporalQuery == TemporalQueries.chronology()) {
            return this.toLocalDate().getChronology();
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return ChronoUnit.NANOS;
        }
        if (temporalQuery == TemporalQueries.offset()) {
            return this.getOffset();
        }
        if (temporalQuery == TemporalQueries.localDate()) {
            return LocalDate.ofEpochDay(this.toLocalDate().toEpochDay());
        }
        if (temporalQuery == TemporalQueries.localTime()) {
            return this.toLocalTime();
        }
        return super.query(temporalQuery);
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        Jdk8Methods.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    public Instant toInstant() {
        return Instant.ofEpochSecond(this.toEpochSecond(), this.toLocalTime().getNano());
    }

    public long toEpochSecond() {
        long l = this.toLocalDate().toEpochDay();
        long l2 = l * 86400L + (long)this.toLocalTime().toSecondOfDay();
        return l2 -= (long)this.getOffset().getTotalSeconds();
    }

    public int compareTo(ChronoZonedDateTime chronoZonedDateTime) {
        int n = Jdk8Methods.compareLongs(this.toEpochSecond(), chronoZonedDateTime.toEpochSecond());
        if (n == 0 && (n = this.toLocalTime().getNano() - chronoZonedDateTime.toLocalTime().getNano()) == 0 && (n = this.toLocalDateTime().compareTo(chronoZonedDateTime.toLocalDateTime())) == 0 && (n = this.getZone().getId().compareTo(chronoZonedDateTime.getZone().getId())) == 0) {
            n = this.toLocalDate().getChronology().compareTo(chronoZonedDateTime.toLocalDate().getChronology());
        }
        return n;
    }

    public boolean isAfter(ChronoZonedDateTime chronoZonedDateTime) {
        long l;
        long l2 = this.toEpochSecond();
        return l2 > (l = chronoZonedDateTime.toEpochSecond()) || l2 == l && this.toLocalTime().getNano() > chronoZonedDateTime.toLocalTime().getNano();
    }

    public boolean isBefore(ChronoZonedDateTime chronoZonedDateTime) {
        long l;
        long l2 = this.toEpochSecond();
        return l2 < (l = chronoZonedDateTime.toEpochSecond()) || l2 == l && this.toLocalTime().getNano() < chronoZonedDateTime.toLocalTime().getNano();
    }

    public boolean isEqual(ChronoZonedDateTime chronoZonedDateTime) {
        return this.toEpochSecond() == chronoZonedDateTime.toEpochSecond() && this.toLocalTime().getNano() == chronoZonedDateTime.toLocalTime().getNano();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChronoZonedDateTime) {
            return this.compareTo((ChronoZonedDateTime)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.toLocalDateTime().hashCode() ^ this.getOffset().hashCode() ^ Integer.rotateLeft(this.getZone().hashCode(), 3);
    }

    public String toString() {
        String string = this.toLocalDateTime().toString() + this.getOffset().toString();
        if (this.getOffset() != this.getZone()) {
            string = string + '[' + this.getZone().toString() + ']';
        }
        return string;
    }
}

