/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.chrono;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.InvalidObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oz.threeten.bp.Clock;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.Instant;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.chrono.ChronoLocalDate;
import oz.threeten.bp.chrono.ChronoLocalDateTime;
import oz.threeten.bp.chrono.ChronoLocalDateTimeImpl;
import oz.threeten.bp.chrono.ChronoPeriod;
import oz.threeten.bp.chrono.ChronoPeriodImpl;
import oz.threeten.bp.chrono.ChronoZonedDateTime;
import oz.threeten.bp.chrono.ChronoZonedDateTimeImpl;
import oz.threeten.bp.chrono.Chronology$1;
import oz.threeten.bp.chrono.Chronology$2;
import oz.threeten.bp.chrono.Era;
import oz.threeten.bp.chrono.HijrahChronology;
import oz.threeten.bp.chrono.IsoChronology;
import oz.threeten.bp.chrono.JapaneseChronology;
import oz.threeten.bp.chrono.MinguoChronology;
import oz.threeten.bp.chrono.Ser;
import oz.threeten.bp.chrono.ThaiBuddhistChronology;
import oz.threeten.bp.format.DateTimeFormatterBuilder;
import oz.threeten.bp.format.ResolverStyle;
import oz.threeten.bp.format.TextStyle;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalQueries;
import oz.threeten.bp.temporal.TemporalQuery;
import oz.threeten.bp.temporal.ValueRange;

public abstract class Chronology
implements Comparable {
    public static final TemporalQuery FROM = new Chronology$1();
    private static final ConcurrentHashMap CHRONOS_BY_ID = new ConcurrentHashMap();
    private static final ConcurrentHashMap CHRONOS_BY_TYPE = new ConcurrentHashMap();
    private static final Method LOCALE_METHOD;

    public static Chronology from(TemporalAccessor temporalAccessor) {
        Jdk8Methods.requireNonNull(temporalAccessor, "temporal");
        Chronology chronology = (Chronology)temporalAccessor.query(TemporalQueries.chronology());
        return chronology != null ? chronology : IsoChronology.INSTANCE;
    }

    public static Chronology ofLocale(Locale locale) {
        Chronology.init();
        Jdk8Methods.requireNonNull(locale, "locale");
        String string = "iso";
        if (LOCALE_METHOD != null) {
            try {
                string = (String)LOCALE_METHOD.invoke((Object)locale, "ca");
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else if (locale.equals(JapaneseChronology.LOCALE)) {
            string = "japanese";
        }
        if (string == null || "iso".equals(string) || "iso8601".equals(string)) {
            return IsoChronology.INSTANCE;
        }
        Chronology chronology = (Chronology)CHRONOS_BY_TYPE.get(string);
        if (chronology == null) {
            throw new DateTimeException("Unknown calendar system: " + string);
        }
        return chronology;
    }

    public static Chronology of(String string) {
        Chronology.init();
        Chronology chronology = (Chronology)CHRONOS_BY_ID.get(string);
        if (chronology != null) {
            return chronology;
        }
        chronology = (Chronology)CHRONOS_BY_TYPE.get(string);
        if (chronology != null) {
            return chronology;
        }
        throw new DateTimeException("Unknown chronology: " + string);
    }

    public static Set getAvailableChronologies() {
        Chronology.init();
        return new HashSet(CHRONOS_BY_ID.values());
    }

    private static void init() {
        if (CHRONOS_BY_ID.isEmpty()) {
            Chronology.register(IsoChronology.INSTANCE);
            Chronology.register(ThaiBuddhistChronology.INSTANCE);
            Chronology.register(MinguoChronology.INSTANCE);
            Chronology.register(JapaneseChronology.INSTANCE);
            Chronology.register(HijrahChronology.INSTANCE);
            CHRONOS_BY_ID.putIfAbsent("Hijrah", HijrahChronology.INSTANCE);
            CHRONOS_BY_TYPE.putIfAbsent("islamic", HijrahChronology.INSTANCE);
            ServiceLoader<Chronology> serviceLoader = ServiceLoader.load(Chronology.class, Chronology.class.getClassLoader());
            for (Chronology chronology : serviceLoader) {
                CHRONOS_BY_ID.putIfAbsent(chronology.getId(), chronology);
                String string = chronology.getCalendarType();
                if (string == null) continue;
                CHRONOS_BY_TYPE.putIfAbsent(string, chronology);
            }
        }
    }

    private static void register(Chronology chronology) {
        CHRONOS_BY_ID.putIfAbsent(chronology.getId(), chronology);
        String string = chronology.getCalendarType();
        if (string != null) {
            CHRONOS_BY_TYPE.putIfAbsent(string, chronology);
        }
    }

    protected Chronology() {
    }

    ChronoLocalDate ensureChronoLocalDate(Temporal temporal) {
        ChronoLocalDate chronoLocalDate = (ChronoLocalDate)temporal;
        if (!this.equals(chronoLocalDate.getChronology())) {
            throw new ClassCastException("Chrono mismatch, expected: " + this.getId() + ", actual: " + chronoLocalDate.getChronology().getId());
        }
        return chronoLocalDate;
    }

    ChronoLocalDateTimeImpl ensureChronoLocalDateTime(Temporal temporal) {
        ChronoLocalDateTimeImpl chronoLocalDateTimeImpl = (ChronoLocalDateTimeImpl)temporal;
        if (!this.equals(chronoLocalDateTimeImpl.toLocalDate().getChronology())) {
            throw new ClassCastException("Chrono mismatch, required: " + this.getId() + ", supplied: " + chronoLocalDateTimeImpl.toLocalDate().getChronology().getId());
        }
        return chronoLocalDateTimeImpl;
    }

    ChronoZonedDateTimeImpl ensureChronoZonedDateTime(Temporal temporal) {
        ChronoZonedDateTimeImpl chronoZonedDateTimeImpl = (ChronoZonedDateTimeImpl)temporal;
        if (!this.equals(chronoZonedDateTimeImpl.toLocalDate().getChronology())) {
            throw new ClassCastException("Chrono mismatch, required: " + this.getId() + ", supplied: " + chronoZonedDateTimeImpl.toLocalDate().getChronology().getId());
        }
        return chronoZonedDateTimeImpl;
    }

    public abstract String getId();

    public abstract String getCalendarType();

    public ChronoLocalDate date(Era era, int n, int n2, int n3) {
        return this.date(this.prolepticYear(era, n), n2, n3);
    }

    public abstract ChronoLocalDate date(int var1, int var2, int var3);

    public ChronoLocalDate dateYearDay(Era era, int n, int n2) {
        return this.dateYearDay(this.prolepticYear(era, n), n2);
    }

    public abstract ChronoLocalDate dateYearDay(int var1, int var2);

    public abstract ChronoLocalDate dateEpochDay(long var1);

    public abstract ChronoLocalDate date(TemporalAccessor var1);

    public ChronoLocalDate dateNow() {
        return this.dateNow(Clock.systemDefaultZone());
    }

    public ChronoLocalDate dateNow(ZoneId zoneId) {
        return this.dateNow(Clock.system(zoneId));
    }

    public ChronoLocalDate dateNow(Clock clock) {
        Jdk8Methods.requireNonNull(clock, "clock");
        return this.date(LocalDate.now(clock));
    }

    public ChronoLocalDateTime localDateTime(TemporalAccessor temporalAccessor) {
        try {
            ChronoLocalDate chronoLocalDate = this.date(temporalAccessor);
            return chronoLocalDate.atTime(LocalTime.from(temporalAccessor));
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain ChronoLocalDateTime from TemporalAccessor: " + temporalAccessor.getClass(), dateTimeException);
        }
    }

    public ChronoZonedDateTime zonedDateTime(TemporalAccessor temporalAccessor) {
        try {
            ZoneId zoneId = ZoneId.from(temporalAccessor);
            try {
                Instant instant = Instant.from(temporalAccessor);
                return this.zonedDateTime(instant, zoneId);
            }
            catch (DateTimeException dateTimeException) {
                ChronoLocalDateTime chronoLocalDateTime = this.localDateTime(temporalAccessor);
                ChronoLocalDateTimeImpl chronoLocalDateTimeImpl = this.ensureChronoLocalDateTime(chronoLocalDateTime);
                return ChronoZonedDateTimeImpl.ofBest(chronoLocalDateTimeImpl, zoneId, null);
            }
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain ChronoZonedDateTime from TemporalAccessor: " + temporalAccessor.getClass(), dateTimeException);
        }
    }

    public ChronoZonedDateTime zonedDateTime(Instant instant, ZoneId zoneId) {
        ChronoZonedDateTimeImpl chronoZonedDateTimeImpl = ChronoZonedDateTimeImpl.ofInstant(this, instant, zoneId);
        return chronoZonedDateTimeImpl;
    }

    public ChronoPeriod period(int n, int n2, int n3) {
        return new ChronoPeriodImpl(this, n, n2, n3);
    }

    public abstract boolean isLeapYear(long var1);

    public abstract int prolepticYear(Era var1, int var2);

    public abstract Era eraOf(int var1);

    public abstract List eras();

    public abstract ValueRange range(ChronoField var1);

    public String getDisplayName(TextStyle textStyle, Locale locale) {
        return new DateTimeFormatterBuilder().appendChronologyText(textStyle).toFormatter(locale).format(new Chronology$2(this));
    }

    public abstract ChronoLocalDate resolveDate(Map var1, ResolverStyle var2);

    void updateResolveMap(Map map, ChronoField chronoField, long l) {
        Long l2 = (Long)map.get(chronoField);
        if (l2 != null && l2 != l) {
            throw new DateTimeException("Invalid state, field: " + chronoField + " " + l2 + " conflicts with " + chronoField + " " + l);
        }
        map.put(chronoField, l);
    }

    public int compareTo(Chronology chronology) {
        return this.getId().compareTo(chronology.getId());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Chronology) {
            return this.compareTo((Chronology)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.getId().hashCode();
    }

    public String toString() {
        return this.getId();
    }

    private Object writeReplace() {
        return new Ser(11, this);
    }

    private Object readResolve() {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput dataOutput) {
        dataOutput.writeUTF(this.getId());
    }

    static Chronology readExternal(DataInput dataInput) {
        String string = dataInput.readUTF();
        return Chronology.of(string);
    }

    static {
        Method method = null;
        try {
            method = Locale.class.getMethod("getUnicodeLocaleType", String.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LOCALE_METHOD = method;
    }
}

