/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.chrono;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oz.threeten.bp.Clock;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.DayOfWeek;
import oz.threeten.bp.Instant;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.chrono.ChronoLocalDateTime;
import oz.threeten.bp.chrono.ChronoZonedDateTime;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.chrono.Era;
import oz.threeten.bp.chrono.IsoChronology;
import oz.threeten.bp.chrono.JapaneseDate;
import oz.threeten.bp.chrono.JapaneseEra;
import oz.threeten.bp.format.ResolverStyle;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalAdjusters;
import oz.threeten.bp.temporal.ValueRange;

public final class JapaneseChronology
extends Chronology
implements Serializable {
    static final Locale LOCALE = new Locale("ja", "JP", "JP");
    public static final JapaneseChronology INSTANCE = new JapaneseChronology();
    private static final long serialVersionUID = 459996390165777884L;
    private static final Map ERA_NARROW_NAMES = new HashMap();
    private static final Map ERA_SHORT_NAMES = new HashMap();
    private static final Map ERA_FULL_NAMES = new HashMap();
    private static final String FALLBACK_LANGUAGE = "en";
    private static final String TARGET_LANGUAGE = "ja";

    private JapaneseChronology() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public String getId() {
        return "Japanese";
    }

    public String getCalendarType() {
        return "japanese";
    }

    public JapaneseDate date(Era era, int n, int n2, int n3) {
        if (!(era instanceof JapaneseEra)) {
            throw new ClassCastException("Era must be JapaneseEra");
        }
        return JapaneseDate.of((JapaneseEra)era, n, n2, n3);
    }

    public JapaneseDate date(int n, int n2, int n3) {
        return new JapaneseDate(LocalDate.of(n, n2, n3));
    }

    public JapaneseDate dateYearDay(Era era, int n, int n2) {
        if (!(era instanceof JapaneseEra)) {
            throw new ClassCastException("Era must be JapaneseEra");
        }
        return JapaneseDate.ofYearDay((JapaneseEra)era, n, n2);
    }

    public JapaneseDate dateYearDay(int n, int n2) {
        LocalDate localDate = LocalDate.ofYearDay(n, n2);
        return this.date(n, localDate.getMonthValue(), localDate.getDayOfMonth());
    }

    public JapaneseDate dateEpochDay(long l) {
        return new JapaneseDate(LocalDate.ofEpochDay(l));
    }

    public JapaneseDate date(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof JapaneseDate) {
            return (JapaneseDate)temporalAccessor;
        }
        return new JapaneseDate(LocalDate.from(temporalAccessor));
    }

    public ChronoLocalDateTime localDateTime(TemporalAccessor temporalAccessor) {
        return super.localDateTime(temporalAccessor);
    }

    public ChronoZonedDateTime zonedDateTime(TemporalAccessor temporalAccessor) {
        return super.zonedDateTime(temporalAccessor);
    }

    public ChronoZonedDateTime zonedDateTime(Instant instant, ZoneId zoneId) {
        return super.zonedDateTime(instant, zoneId);
    }

    public JapaneseDate dateNow() {
        return (JapaneseDate)super.dateNow();
    }

    public JapaneseDate dateNow(ZoneId zoneId) {
        return (JapaneseDate)super.dateNow(zoneId);
    }

    public JapaneseDate dateNow(Clock clock) {
        Jdk8Methods.requireNonNull(clock, "clock");
        return (JapaneseDate)super.dateNow(clock);
    }

    public boolean isLeapYear(long l) {
        return IsoChronology.INSTANCE.isLeapYear(l);
    }

    public int prolepticYear(Era era, int n) {
        if (!(era instanceof JapaneseEra)) {
            throw new ClassCastException("Era must be JapaneseEra");
        }
        JapaneseEra japaneseEra = (JapaneseEra)era;
        int n2 = japaneseEra.startDate().getYear() + n - 1;
        ValueRange valueRange = ValueRange.of(1L, japaneseEra.endDate().getYear() - japaneseEra.startDate().getYear() + 1);
        valueRange.checkValidValue(n, ChronoField.YEAR_OF_ERA);
        return n2;
    }

    public JapaneseEra eraOf(int n) {
        return JapaneseEra.of(n);
    }

    public List eras() {
        return Arrays.asList(JapaneseEra.values());
    }

    public ValueRange range(ChronoField chronoField) {
        switch (chronoField) {
            case DAY_OF_MONTH: 
            case DAY_OF_WEEK: 
            case MICRO_OF_DAY: 
            case MICRO_OF_SECOND: 
            case HOUR_OF_DAY: 
            case HOUR_OF_AMPM: 
            case MINUTE_OF_DAY: 
            case MINUTE_OF_HOUR: 
            case SECOND_OF_DAY: 
            case SECOND_OF_MINUTE: 
            case MILLI_OF_DAY: 
            case MILLI_OF_SECOND: 
            case NANO_OF_DAY: 
            case NANO_OF_SECOND: 
            case CLOCK_HOUR_OF_DAY: 
            case CLOCK_HOUR_OF_AMPM: 
            case EPOCH_DAY: 
            case PROLEPTIC_MONTH: {
                return chronoField.range();
            }
        }
        Calendar calendar = Calendar.getInstance(LOCALE);
        switch (chronoField) {
            case ERA: {
                JapaneseEra[] japaneseEraArray = JapaneseEra.values();
                return ValueRange.of(japaneseEraArray[0].getValue(), japaneseEraArray[japaneseEraArray.length - 1].getValue());
            }
            case YEAR: {
                JapaneseEra[] japaneseEraArray = JapaneseEra.values();
                return ValueRange.of(JapaneseDate.MIN_DATE.getYear(), japaneseEraArray[japaneseEraArray.length - 1].endDate().getYear());
            }
            case YEAR_OF_ERA: {
                JapaneseEra[] japaneseEraArray = JapaneseEra.values();
                int n = japaneseEraArray[japaneseEraArray.length - 1].endDate().getYear();
                int n2 = n - japaneseEraArray[japaneseEraArray.length - 1].startDate().getYear() + 1;
                int n3 = Integer.MAX_VALUE;
                for (int j = 0; j < japaneseEraArray.length; ++j) {
                    n3 = Math.min(n3, japaneseEraArray[j].endDate().getYear() - japaneseEraArray[j].startDate().getYear() + 1);
                }
                return ValueRange.of(1L, 6L, n3, n2);
            }
            case MONTH_OF_YEAR: {
                return ValueRange.of(calendar.getMinimum(2) + 1, calendar.getGreatestMinimum(2) + 1, calendar.getLeastMaximum(2) + 1, calendar.getMaximum(2) + 1);
            }
            case DAY_OF_YEAR: {
                JapaneseEra[] japaneseEraArray = JapaneseEra.values();
                int n = 366;
                for (int j = 0; j < japaneseEraArray.length; ++j) {
                    n = Math.min(n, japaneseEraArray[j].startDate().lengthOfYear() - japaneseEraArray[j].startDate().getDayOfYear() + 1);
                }
                return ValueRange.of(1L, n, 366L);
            }
        }
        throw new UnsupportedOperationException("Unimplementable field: " + chronoField);
    }

    public JapaneseDate resolveDate(Map map, ResolverStyle resolverStyle) {
        int n;
        Long l;
        if (map.containsKey(ChronoField.EPOCH_DAY)) {
            return this.dateEpochDay((Long)map.remove(ChronoField.EPOCH_DAY));
        }
        Long l2 = (Long)map.remove(ChronoField.PROLEPTIC_MONTH);
        if (l2 != null) {
            if (resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.PROLEPTIC_MONTH.checkValidValue(l2);
            }
            this.updateResolveMap(map, ChronoField.MONTH_OF_YEAR, Jdk8Methods.floorMod((long)l2, 12) + 1);
            this.updateResolveMap(map, ChronoField.YEAR, Jdk8Methods.floorDiv(l2, 12L));
        }
        Long l3 = (Long)map.get(ChronoField.ERA);
        JapaneseEra japaneseEra = null;
        if (l3 != null) {
            japaneseEra = this.eraOf(this.range(ChronoField.ERA).checkValidIntValue(l3, ChronoField.ERA));
        }
        if ((l = (Long)map.get(ChronoField.YEAR_OF_ERA)) != null) {
            n = this.range(ChronoField.YEAR_OF_ERA).checkValidIntValue(l, ChronoField.YEAR_OF_ERA);
            if (japaneseEra == null && resolverStyle != ResolverStyle.STRICT && !map.containsKey(ChronoField.YEAR)) {
                List list = this.eras();
                japaneseEra = (JapaneseEra)list.get(list.size() - 1);
            }
            if (japaneseEra != null && map.containsKey(ChronoField.MONTH_OF_YEAR) && map.containsKey(ChronoField.DAY_OF_MONTH)) {
                map.remove(ChronoField.ERA);
                map.remove(ChronoField.YEAR_OF_ERA);
                return this.resolveEYMD(map, resolverStyle, japaneseEra, n);
            }
            if (japaneseEra != null && map.containsKey(ChronoField.DAY_OF_YEAR)) {
                map.remove(ChronoField.ERA);
                map.remove(ChronoField.YEAR_OF_ERA);
                return this.resolveEYD(map, resolverStyle, japaneseEra, n);
            }
        }
        if (map.containsKey(ChronoField.YEAR)) {
            if (map.containsKey(ChronoField.MONTH_OF_YEAR)) {
                if (map.containsKey(ChronoField.DAY_OF_MONTH)) {
                    n = ChronoField.YEAR.checkValidIntValue((Long)map.remove(ChronoField.YEAR));
                    if (resolverStyle == ResolverStyle.LENIENT) {
                        long l4 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.MONTH_OF_YEAR), 1L);
                        long l5 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.DAY_OF_MONTH), 1L);
                        return this.date(n, 1, 1).plusMonths(l4).plusDays(l5);
                    }
                    int n2 = this.range(ChronoField.MONTH_OF_YEAR).checkValidIntValue((Long)map.remove(ChronoField.MONTH_OF_YEAR), ChronoField.MONTH_OF_YEAR);
                    int n3 = this.range(ChronoField.DAY_OF_MONTH).checkValidIntValue((Long)map.remove(ChronoField.DAY_OF_MONTH), ChronoField.DAY_OF_MONTH);
                    if (resolverStyle == ResolverStyle.SMART && n3 > 28) {
                        n3 = Math.min(n3, this.date(n, n2, 1).lengthOfMonth());
                    }
                    return this.date(n, n2, n3);
                }
                if (map.containsKey(ChronoField.ALIGNED_WEEK_OF_MONTH)) {
                    if (map.containsKey(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH)) {
                        n = ChronoField.YEAR.checkValidIntValue((Long)map.remove(ChronoField.YEAR));
                        if (resolverStyle == ResolverStyle.LENIENT) {
                            long l6 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.MONTH_OF_YEAR), 1L);
                            long l7 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH), 1L);
                            long l8 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH), 1L);
                            return this.date(n, 1, 1).plus(l6, ChronoUnit.MONTHS).plus(l7, ChronoUnit.WEEKS).plus(l8, ChronoUnit.DAYS);
                        }
                        int n4 = ChronoField.MONTH_OF_YEAR.checkValidIntValue((Long)map.remove(ChronoField.MONTH_OF_YEAR));
                        int n5 = ChronoField.ALIGNED_WEEK_OF_MONTH.checkValidIntValue((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH));
                        int n6 = ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH.checkValidIntValue((Long)map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH));
                        JapaneseDate japaneseDate = this.date(n, n4, 1).plus((n5 - 1) * 7 + (n6 - 1), ChronoUnit.DAYS);
                        if (resolverStyle == ResolverStyle.STRICT && japaneseDate.get(ChronoField.MONTH_OF_YEAR) != n4) {
                            throw new DateTimeException("Strict mode rejected date parsed to a different month");
                        }
                        return japaneseDate;
                    }
                    if (map.containsKey(ChronoField.DAY_OF_WEEK)) {
                        n = ChronoField.YEAR.checkValidIntValue((Long)map.remove(ChronoField.YEAR));
                        if (resolverStyle == ResolverStyle.LENIENT) {
                            long l9 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.MONTH_OF_YEAR), 1L);
                            long l10 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH), 1L);
                            long l11 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.DAY_OF_WEEK), 1L);
                            return this.date(n, 1, 1).plus(l9, ChronoUnit.MONTHS).plus(l10, ChronoUnit.WEEKS).plus(l11, ChronoUnit.DAYS);
                        }
                        int n7 = ChronoField.MONTH_OF_YEAR.checkValidIntValue((Long)map.remove(ChronoField.MONTH_OF_YEAR));
                        int n8 = ChronoField.ALIGNED_WEEK_OF_MONTH.checkValidIntValue((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH));
                        int n9 = ChronoField.DAY_OF_WEEK.checkValidIntValue((Long)map.remove(ChronoField.DAY_OF_WEEK));
                        JapaneseDate japaneseDate = this.date(n, n7, 1).plus(n8 - 1, ChronoUnit.WEEKS).with(TemporalAdjusters.nextOrSame(DayOfWeek.of(n9)));
                        if (resolverStyle == ResolverStyle.STRICT && japaneseDate.get(ChronoField.MONTH_OF_YEAR) != n7) {
                            throw new DateTimeException("Strict mode rejected date parsed to a different month");
                        }
                        return japaneseDate;
                    }
                }
            }
            if (map.containsKey(ChronoField.DAY_OF_YEAR)) {
                n = ChronoField.YEAR.checkValidIntValue((Long)map.remove(ChronoField.YEAR));
                if (resolverStyle == ResolverStyle.LENIENT) {
                    long l12 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.DAY_OF_YEAR), 1L);
                    return this.dateYearDay(n, 1).plusDays(l12);
                }
                int n10 = ChronoField.DAY_OF_YEAR.checkValidIntValue((Long)map.remove(ChronoField.DAY_OF_YEAR));
                return this.dateYearDay(n, n10);
            }
            if (map.containsKey(ChronoField.ALIGNED_WEEK_OF_YEAR)) {
                if (map.containsKey(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR)) {
                    n = ChronoField.YEAR.checkValidIntValue((Long)map.remove(ChronoField.YEAR));
                    if (resolverStyle == ResolverStyle.LENIENT) {
                        long l13 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR), 1L);
                        long l14 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR), 1L);
                        return this.date(n, 1, 1).plus(l13, ChronoUnit.WEEKS).plus(l14, ChronoUnit.DAYS);
                    }
                    int n11 = ChronoField.ALIGNED_WEEK_OF_YEAR.checkValidIntValue((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR));
                    int n12 = ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR.checkValidIntValue((Long)map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR));
                    JapaneseDate japaneseDate = this.date(n, 1, 1).plusDays((n11 - 1) * 7 + (n12 - 1));
                    if (resolverStyle == ResolverStyle.STRICT && japaneseDate.get(ChronoField.YEAR) != n) {
                        throw new DateTimeException("Strict mode rejected date parsed to a different year");
                    }
                    return japaneseDate;
                }
                if (map.containsKey(ChronoField.DAY_OF_WEEK)) {
                    n = ChronoField.YEAR.checkValidIntValue((Long)map.remove(ChronoField.YEAR));
                    if (resolverStyle == ResolverStyle.LENIENT) {
                        long l15 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR), 1L);
                        long l16 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.DAY_OF_WEEK), 1L);
                        return this.date(n, 1, 1).plus(l15, ChronoUnit.WEEKS).plus(l16, ChronoUnit.DAYS);
                    }
                    int n13 = ChronoField.ALIGNED_WEEK_OF_YEAR.checkValidIntValue((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR));
                    int n14 = ChronoField.DAY_OF_WEEK.checkValidIntValue((Long)map.remove(ChronoField.DAY_OF_WEEK));
                    JapaneseDate japaneseDate = this.date(n, 1, 1).plus(n13 - 1, ChronoUnit.WEEKS).with(TemporalAdjusters.nextOrSame(DayOfWeek.of(n14)));
                    if (resolverStyle == ResolverStyle.STRICT && japaneseDate.get(ChronoField.YEAR) != n) {
                        throw new DateTimeException("Strict mode rejected date parsed to a different month");
                    }
                    return japaneseDate;
                }
            }
        }
        return null;
    }

    private JapaneseDate resolveEYMD(Map map, ResolverStyle resolverStyle, JapaneseEra japaneseEra, int n) {
        if (resolverStyle == ResolverStyle.LENIENT) {
            int n2 = japaneseEra.startDate().getYear() + n - 1;
            long l = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.MONTH_OF_YEAR), 1L);
            long l2 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.DAY_OF_MONTH), 1L);
            return this.date(n2, 1, 1).plus(l, ChronoUnit.MONTHS).plus(l2, ChronoUnit.DAYS);
        }
        int n3 = this.range(ChronoField.MONTH_OF_YEAR).checkValidIntValue((Long)map.remove(ChronoField.MONTH_OF_YEAR), ChronoField.MONTH_OF_YEAR);
        int n4 = this.range(ChronoField.DAY_OF_MONTH).checkValidIntValue((Long)map.remove(ChronoField.DAY_OF_MONTH), ChronoField.DAY_OF_MONTH);
        if (resolverStyle == ResolverStyle.SMART) {
            JapaneseDate japaneseDate;
            if (n < 1) {
                throw new DateTimeException("Invalid YearOfEra: " + n);
            }
            int n5 = japaneseEra.startDate().getYear() + n - 1;
            if (n4 > 28) {
                n4 = Math.min(n4, this.date(n5, n3, 1).lengthOfMonth());
            }
            if ((japaneseDate = this.date(n5, n3, n4)).getEra() != japaneseEra) {
                if (Math.abs(japaneseDate.getEra().getValue() - japaneseEra.getValue()) > 1) {
                    throw new DateTimeException("Invalid Era/YearOfEra: " + japaneseEra + " " + n);
                }
                if (japaneseDate.get(ChronoField.YEAR_OF_ERA) != 1 && n != 1) {
                    throw new DateTimeException("Invalid Era/YearOfEra: " + japaneseEra + " " + n);
                }
            }
            return japaneseDate;
        }
        return this.date(japaneseEra, n, n3, n4);
    }

    private JapaneseDate resolveEYD(Map map, ResolverStyle resolverStyle, JapaneseEra japaneseEra, int n) {
        if (resolverStyle == ResolverStyle.LENIENT) {
            int n2 = japaneseEra.startDate().getYear() + n - 1;
            long l = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.DAY_OF_YEAR), 1L);
            return this.dateYearDay(n2, 1).plus(l, ChronoUnit.DAYS);
        }
        int n3 = this.range(ChronoField.DAY_OF_YEAR).checkValidIntValue((Long)map.remove(ChronoField.DAY_OF_YEAR), ChronoField.DAY_OF_YEAR);
        return this.dateYearDay(japaneseEra, n, n3);
    }

    static {
        ERA_NARROW_NAMES.put(FALLBACK_LANGUAGE, new String[]{"Unknown", "K", "M", "T", "S", "H"});
        ERA_NARROW_NAMES.put(TARGET_LANGUAGE, new String[]{"Unknown", "K", "M", "T", "S", "H"});
        ERA_SHORT_NAMES.put(FALLBACK_LANGUAGE, new String[]{"Unknown", "K", "M", "T", "S", "H"});
        ERA_SHORT_NAMES.put(TARGET_LANGUAGE, new String[]{"Unknown", "\u6176", "\u660e", "\u5927", "\u662d", "\u5e73"});
        ERA_FULL_NAMES.put(FALLBACK_LANGUAGE, new String[]{"Unknown", "Keio", "Meiji", "Taisho", "Showa", "Heisei"});
        ERA_FULL_NAMES.put(TARGET_LANGUAGE, new String[]{"Unknown", "\u6176\u5fdc", "\u660e\u6cbb", "\u5927\u6b63", "\u662d\u548c", "\u5e73\u6210"});
    }
}

