/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.chrono;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.chrono.JapaneseChronology;
import oz.threeten.bp.chrono.Ser;
import oz.threeten.bp.jdk8.DefaultInterfaceEra;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.ValueRange;

public final class JapaneseEra
extends DefaultInterfaceEra
implements Serializable {
    static final int ERA_OFFSET = 2;
    public static final JapaneseEra MEIJI = new JapaneseEra(-1, LocalDate.of(1868, 9, 8), "Meiji");
    public static final JapaneseEra TAISHO = new JapaneseEra(0, LocalDate.of(1912, 7, 30), "Taisho");
    public static final JapaneseEra SHOWA = new JapaneseEra(1, LocalDate.of(1926, 12, 25), "Showa");
    public static final JapaneseEra HEISEI = new JapaneseEra(2, LocalDate.of(1989, 1, 8), "Heisei");
    public static final JapaneseEra REIWA = new JapaneseEra(3, LocalDate.of(2019, 5, 1), "Reiwa");
    private static final int ADDITIONAL_VALUE = 4;
    private static final long serialVersionUID = 1466499369062886794L;
    private static final AtomicReference KNOWN_ERAS;
    private final int eraValue;
    private final transient LocalDate since;
    private final transient String name;

    private JapaneseEra(int n, LocalDate localDate, String string) {
        this.eraValue = n;
        this.since = localDate;
        this.name = string;
    }

    private Object readResolve() {
        try {
            return JapaneseEra.of(this.eraValue);
        }
        catch (DateTimeException dateTimeException) {
            InvalidObjectException invalidObjectException = new InvalidObjectException("Invalid era");
            invalidObjectException.initCause(dateTimeException);
            throw invalidObjectException;
        }
    }

    public static JapaneseEra registerEra(LocalDate localDate, String string) {
        JapaneseEra[] japaneseEraArray = (JapaneseEra[])KNOWN_ERAS.get();
        if (japaneseEraArray.length > 5) {
            throw new DateTimeException("Only one additional Japanese era can be added");
        }
        Jdk8Methods.requireNonNull(localDate, "since");
        Jdk8Methods.requireNonNull(string, "name");
        if (!localDate.isAfter(JapaneseEra.REIWA.since)) {
            throw new DateTimeException("Invalid since date for additional Japanese era, must be after Reiwa");
        }
        JapaneseEra japaneseEra = new JapaneseEra(4, localDate, string);
        JapaneseEra[] japaneseEraArray2 = Arrays.copyOf(japaneseEraArray, 6);
        japaneseEraArray2[5] = japaneseEra;
        if (!KNOWN_ERAS.compareAndSet(japaneseEraArray, japaneseEraArray2)) {
            throw new DateTimeException("Only one additional Japanese era can be added");
        }
        return japaneseEra;
    }

    public static JapaneseEra of(int n) {
        JapaneseEra[] japaneseEraArray = (JapaneseEra[])KNOWN_ERAS.get();
        if (n < JapaneseEra.MEIJI.eraValue || n > japaneseEraArray[japaneseEraArray.length - 1].eraValue) {
            throw new DateTimeException("japaneseEra is invalid");
        }
        return japaneseEraArray[JapaneseEra.ordinal(n)];
    }

    public static JapaneseEra valueOf(String string) {
        JapaneseEra[] japaneseEraArray;
        Jdk8Methods.requireNonNull(string, "japaneseEra");
        for (JapaneseEra japaneseEra : japaneseEraArray = (JapaneseEra[])KNOWN_ERAS.get()) {
            if (!string.equals(japaneseEra.name)) continue;
            return japaneseEra;
        }
        throw new IllegalArgumentException("Era not found: " + string);
    }

    public static JapaneseEra[] values() {
        JapaneseEra[] japaneseEraArray = (JapaneseEra[])KNOWN_ERAS.get();
        return Arrays.copyOf(japaneseEraArray, japaneseEraArray.length);
    }

    static JapaneseEra from(LocalDate localDate) {
        if (localDate.isBefore(JapaneseEra.MEIJI.since)) {
            throw new DateTimeException("Date too early: " + localDate);
        }
        JapaneseEra[] japaneseEraArray = (JapaneseEra[])KNOWN_ERAS.get();
        for (int j = japaneseEraArray.length - 1; j >= 0; --j) {
            JapaneseEra japaneseEra = japaneseEraArray[j];
            if (localDate.compareTo(japaneseEra.since) < 0) continue;
            return japaneseEra;
        }
        return null;
    }

    private static int ordinal(int n) {
        return n + 1;
    }

    LocalDate startDate() {
        return this.since;
    }

    LocalDate endDate() {
        JapaneseEra[] japaneseEraArray;
        int n = JapaneseEra.ordinal(this.eraValue);
        if (n >= (japaneseEraArray = JapaneseEra.values()).length - 1) {
            return LocalDate.MAX;
        }
        return japaneseEraArray[n + 1].startDate().minusDays(1L);
    }

    public int getValue() {
        return this.eraValue;
    }

    public ValueRange range(TemporalField temporalField) {
        if (temporalField == ChronoField.ERA) {
            return JapaneseChronology.INSTANCE.range(ChronoField.ERA);
        }
        return super.range(temporalField);
    }

    public String toString() {
        return this.name;
    }

    private Object writeReplace() {
        return new Ser(2, this);
    }

    void writeExternal(DataOutput dataOutput) {
        dataOutput.writeByte(this.getValue());
    }

    static JapaneseEra readExternal(DataInput dataInput) {
        byte by = dataInput.readByte();
        return JapaneseEra.of(by);
    }

    static {
        JapaneseEra[] japaneseEraArray = new JapaneseEra[]{MEIJI, TAISHO, SHOWA, HEISEI, REIWA};
        KNOWN_ERAS = new AtomicReference<JapaneseEra[]>(japaneseEraArray);
    }
}

