/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.chrono;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Serializable;
import oz.threeten.bp.Clock;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.Period;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.chrono.ChronoDateImpl;
import oz.threeten.bp.chrono.ChronoLocalDate;
import oz.threeten.bp.chrono.ChronoLocalDateTime;
import oz.threeten.bp.chrono.ChronoPeriod;
import oz.threeten.bp.chrono.MinguoChronology;
import oz.threeten.bp.chrono.MinguoEra;
import oz.threeten.bp.chrono.Ser;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalAdjuster;
import oz.threeten.bp.temporal.TemporalAmount;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.UnsupportedTemporalTypeException;
import oz.threeten.bp.temporal.ValueRange;

public final class MinguoDate
extends ChronoDateImpl
implements Serializable {
    private static final long serialVersionUID = 1300372329181994526L;
    private final LocalDate isoDate;

    public static MinguoDate now() {
        return MinguoDate.now(Clock.systemDefaultZone());
    }

    public static MinguoDate now(ZoneId zoneId) {
        return MinguoDate.now(Clock.system(zoneId));
    }

    public static MinguoDate now(Clock clock) {
        return new MinguoDate(LocalDate.now(clock));
    }

    public static MinguoDate of(int n, int n2, int n3) {
        return MinguoChronology.INSTANCE.date(n, n2, n3);
    }

    public static MinguoDate from(TemporalAccessor temporalAccessor) {
        return MinguoChronology.INSTANCE.date(temporalAccessor);
    }

    MinguoDate(LocalDate localDate) {
        Jdk8Methods.requireNonNull(localDate, "date");
        this.isoDate = localDate;
    }

    public MinguoChronology getChronology() {
        return MinguoChronology.INSTANCE;
    }

    public MinguoEra getEra() {
        return (MinguoEra)super.getEra();
    }

    public int lengthOfMonth() {
        return this.isoDate.lengthOfMonth();
    }

    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (this.isSupported(temporalField)) {
                ChronoField chronoField = (ChronoField)temporalField;
                switch (chronoField) {
                    case DAY_OF_MONTH: 
                    case DAY_OF_YEAR: 
                    case ALIGNED_WEEK_OF_MONTH: {
                        return this.isoDate.range(temporalField);
                    }
                    case YEAR_OF_ERA: {
                        ValueRange valueRange = ChronoField.YEAR.range();
                        long l = this.getProlepticYear() <= 0 ? -valueRange.getMinimum() + 1L + 1911L : valueRange.getMaximum() - 1911L;
                        return ValueRange.of(1L, l);
                    }
                }
                return this.getChronology().range(chronoField);
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case PROLEPTIC_MONTH: {
                    return this.getProlepticMonth();
                }
                case YEAR_OF_ERA: {
                    int n = this.getProlepticYear();
                    return n >= 1 ? n : 1 - n;
                }
                case YEAR: {
                    return this.getProlepticYear();
                }
                case ERA: {
                    return this.getProlepticYear() >= 1 ? 1 : 0;
                }
            }
            return this.isoDate.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    private long getProlepticMonth() {
        return (long)this.getProlepticYear() * 12L + (long)this.isoDate.getMonthValue() - 1L;
    }

    private int getProlepticYear() {
        return this.isoDate.getYear() - 1911;
    }

    public MinguoDate with(TemporalAdjuster temporalAdjuster) {
        return (MinguoDate)super.with(temporalAdjuster);
    }

    public MinguoDate with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            if (this.getLong(chronoField) == l) {
                return this;
            }
            switch (chronoField) {
                case PROLEPTIC_MONTH: {
                    this.getChronology().range(chronoField).checkValidValue(l, chronoField);
                    return this.plusMonths(l - this.getProlepticMonth());
                }
                case YEAR_OF_ERA: 
                case YEAR: 
                case ERA: {
                    int n = this.getChronology().range(chronoField).checkValidIntValue(l, chronoField);
                    switch (chronoField) {
                        case YEAR_OF_ERA: {
                            return this.with(this.isoDate.withYear(this.getProlepticYear() >= 1 ? n + 1911 : 1 - n + 1911));
                        }
                        case YEAR: {
                            return this.with(this.isoDate.withYear(n + 1911));
                        }
                        case ERA: {
                            return this.with(this.isoDate.withYear(1 - this.getProlepticYear() + 1911));
                        }
                    }
                }
            }
            return this.with(this.isoDate.with(temporalField, l));
        }
        return (MinguoDate)temporalField.adjustInto(this, l);
    }

    public MinguoDate plus(TemporalAmount temporalAmount) {
        return (MinguoDate)super.plus(temporalAmount);
    }

    public MinguoDate plus(long l, TemporalUnit temporalUnit) {
        return (MinguoDate)super.plus(l, temporalUnit);
    }

    public MinguoDate minus(TemporalAmount temporalAmount) {
        return (MinguoDate)super.minus(temporalAmount);
    }

    public MinguoDate minus(long l, TemporalUnit temporalUnit) {
        return (MinguoDate)super.minus(l, temporalUnit);
    }

    MinguoDate plusYears(long l) {
        return this.with(this.isoDate.plusYears(l));
    }

    MinguoDate plusMonths(long l) {
        return this.with(this.isoDate.plusMonths(l));
    }

    MinguoDate plusDays(long l) {
        return this.with(this.isoDate.plusDays(l));
    }

    private MinguoDate with(LocalDate localDate) {
        return localDate.equals(this.isoDate) ? this : new MinguoDate(localDate);
    }

    public final ChronoLocalDateTime atTime(LocalTime localTime) {
        return super.atTime(localTime);
    }

    public ChronoPeriod until(ChronoLocalDate chronoLocalDate) {
        Period period = this.isoDate.until(chronoLocalDate);
        return this.getChronology().period(period.getYears(), period.getMonths(), period.getDays());
    }

    public long toEpochDay() {
        return this.isoDate.toEpochDay();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MinguoDate) {
            MinguoDate minguoDate = (MinguoDate)object;
            return this.isoDate.equals(minguoDate.isoDate);
        }
        return false;
    }

    public int hashCode() {
        return this.getChronology().getId().hashCode() ^ this.isoDate.hashCode();
    }

    private Object writeReplace() {
        return new Ser(5, this);
    }

    void writeExternal(DataOutput dataOutput) {
        dataOutput.writeInt(this.get(ChronoField.YEAR));
        dataOutput.writeByte(this.get(ChronoField.MONTH_OF_YEAR));
        dataOutput.writeByte(this.get(ChronoField.DAY_OF_MONTH));
    }

    static ChronoLocalDate readExternal(DataInput dataInput) {
        int n = dataInput.readInt();
        byte by = dataInput.readByte();
        byte by2 = dataInput.readByte();
        return MinguoChronology.INSTANCE.date(n, by, by2);
    }
}

