/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.chrono;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Serializable;
import oz.threeten.bp.Clock;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.Period;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.chrono.ChronoDateImpl;
import oz.threeten.bp.chrono.ChronoLocalDate;
import oz.threeten.bp.chrono.ChronoLocalDateTime;
import oz.threeten.bp.chrono.ChronoPeriod;
import oz.threeten.bp.chrono.Ser;
import oz.threeten.bp.chrono.ThaiBuddhistChronology;
import oz.threeten.bp.chrono.ThaiBuddhistEra;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalAdjuster;
import oz.threeten.bp.temporal.TemporalAmount;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.UnsupportedTemporalTypeException;
import oz.threeten.bp.temporal.ValueRange;

public final class ThaiBuddhistDate
extends ChronoDateImpl
implements Serializable {
    private static final long serialVersionUID = -8722293800195731463L;
    private final LocalDate isoDate;

    public static ThaiBuddhistDate now() {
        return ThaiBuddhistDate.now(Clock.systemDefaultZone());
    }

    public static ThaiBuddhistDate now(ZoneId zoneId) {
        return ThaiBuddhistDate.now(Clock.system(zoneId));
    }

    public static ThaiBuddhistDate now(Clock clock) {
        return new ThaiBuddhistDate(LocalDate.now(clock));
    }

    public static ThaiBuddhistDate of(int n, int n2, int n3) {
        return ThaiBuddhistChronology.INSTANCE.date(n, n2, n3);
    }

    public static ThaiBuddhistDate from(TemporalAccessor temporalAccessor) {
        return ThaiBuddhistChronology.INSTANCE.date(temporalAccessor);
    }

    ThaiBuddhistDate(LocalDate localDate) {
        Jdk8Methods.requireNonNull(localDate, "date");
        this.isoDate = localDate;
    }

    public ThaiBuddhistChronology getChronology() {
        return ThaiBuddhistChronology.INSTANCE;
    }

    public ThaiBuddhistEra getEra() {
        return (ThaiBuddhistEra)super.getEra();
    }

    public int lengthOfMonth() {
        return this.isoDate.lengthOfMonth();
    }

    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (this.isSupported(temporalField)) {
                ChronoField chronoField = (ChronoField)temporalField;
                switch (chronoField) {
                    case DAY_OF_MONTH: 
                    case DAY_OF_YEAR: 
                    case ALIGNED_WEEK_OF_MONTH: {
                        return this.isoDate.range(temporalField);
                    }
                    case YEAR_OF_ERA: {
                        ValueRange valueRange = ChronoField.YEAR.range();
                        long l = this.getProlepticYear() <= 0 ? -(valueRange.getMinimum() + 543L) + 1L : valueRange.getMaximum() + 543L;
                        return ValueRange.of(1L, l);
                    }
                }
                return this.getChronology().range(chronoField);
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case PROLEPTIC_MONTH: {
                    return this.getProlepticMonth();
                }
                case YEAR_OF_ERA: {
                    int n = this.getProlepticYear();
                    return n >= 1 ? n : 1 - n;
                }
                case YEAR: {
                    return this.getProlepticYear();
                }
                case ERA: {
                    return this.getProlepticYear() >= 1 ? 1 : 0;
                }
            }
            return this.isoDate.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    private long getProlepticMonth() {
        return (long)this.getProlepticYear() * 12L + (long)this.isoDate.getMonthValue() - 1L;
    }

    private int getProlepticYear() {
        return this.isoDate.getYear() + 543;
    }

    public ThaiBuddhistDate with(TemporalAdjuster temporalAdjuster) {
        return (ThaiBuddhistDate)super.with(temporalAdjuster);
    }

    public ThaiBuddhistDate with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            if (this.getLong(chronoField) == l) {
                return this;
            }
            switch (chronoField) {
                case PROLEPTIC_MONTH: {
                    this.getChronology().range(chronoField).checkValidValue(l, chronoField);
                    return this.plusMonths(l - this.getProlepticMonth());
                }
                case YEAR_OF_ERA: 
                case YEAR: 
                case ERA: {
                    int n = this.getChronology().range(chronoField).checkValidIntValue(l, chronoField);
                    switch (chronoField) {
                        case YEAR_OF_ERA: {
                            return this.with(this.isoDate.withYear((this.getProlepticYear() >= 1 ? n : 1 - n) - 543));
                        }
                        case YEAR: {
                            return this.with(this.isoDate.withYear(n - 543));
                        }
                        case ERA: {
                            return this.with(this.isoDate.withYear(1 - this.getProlepticYear() - 543));
                        }
                    }
                }
            }
            return this.with(this.isoDate.with(temporalField, l));
        }
        return (ThaiBuddhistDate)temporalField.adjustInto(this, l);
    }

    public ThaiBuddhistDate plus(TemporalAmount temporalAmount) {
        return (ThaiBuddhistDate)super.plus(temporalAmount);
    }

    public ThaiBuddhistDate plus(long l, TemporalUnit temporalUnit) {
        return (ThaiBuddhistDate)super.plus(l, temporalUnit);
    }

    public ThaiBuddhistDate minus(TemporalAmount temporalAmount) {
        return (ThaiBuddhistDate)super.minus(temporalAmount);
    }

    public ThaiBuddhistDate minus(long l, TemporalUnit temporalUnit) {
        return (ThaiBuddhistDate)super.minus(l, temporalUnit);
    }

    ThaiBuddhistDate plusYears(long l) {
        return this.with(this.isoDate.plusYears(l));
    }

    ThaiBuddhistDate plusMonths(long l) {
        return this.with(this.isoDate.plusMonths(l));
    }

    ThaiBuddhistDate plusDays(long l) {
        return this.with(this.isoDate.plusDays(l));
    }

    private ThaiBuddhistDate with(LocalDate localDate) {
        return localDate.equals(this.isoDate) ? this : new ThaiBuddhistDate(localDate);
    }

    public final ChronoLocalDateTime atTime(LocalTime localTime) {
        return super.atTime(localTime);
    }

    public ChronoPeriod until(ChronoLocalDate chronoLocalDate) {
        Period period = this.isoDate.until(chronoLocalDate);
        return this.getChronology().period(period.getYears(), period.getMonths(), period.getDays());
    }

    public long toEpochDay() {
        return this.isoDate.toEpochDay();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ThaiBuddhistDate) {
            ThaiBuddhistDate thaiBuddhistDate = (ThaiBuddhistDate)object;
            return this.isoDate.equals(thaiBuddhistDate.isoDate);
        }
        return false;
    }

    public int hashCode() {
        return this.getChronology().getId().hashCode() ^ this.isoDate.hashCode();
    }

    private Object writeReplace() {
        return new Ser(7, this);
    }

    void writeExternal(DataOutput dataOutput) {
        dataOutput.writeInt(this.get(ChronoField.YEAR));
        dataOutput.writeByte(this.get(ChronoField.MONTH_OF_YEAR));
        dataOutput.writeByte(this.get(ChronoField.DAY_OF_MONTH));
    }

    static ChronoLocalDate readExternal(DataInput dataInput) {
        int n = dataInput.readInt();
        byte by = dataInput.readByte();
        byte by2 = dataInput.readByte();
        return ThaiBuddhistChronology.INSTANCE.date(n, by, by2);
    }
}

