/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.format;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.Instant;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.Period;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.chrono.ChronoLocalDate;
import oz.threeten.bp.chrono.ChronoLocalDateTime;
import oz.threeten.bp.chrono.ChronoZonedDateTime;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.chrono.IsoChronology;
import oz.threeten.bp.format.ResolverStyle;
import oz.threeten.bp.jdk8.DefaultInterfaceTemporal;
import oz.threeten.bp.jdk8.DefaultInterfaceTemporalAccessor;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalQueries;
import oz.threeten.bp.temporal.TemporalQuery;

final class DateTimeBuilder
extends DefaultInterfaceTemporalAccessor
implements Cloneable,
TemporalAccessor {
    final Map fieldValues = new HashMap();
    Chronology chrono;
    ZoneId zone;
    ChronoLocalDate date;
    LocalTime time;
    boolean leapSecond;
    Period excessDays;

    public DateTimeBuilder() {
    }

    public DateTimeBuilder(TemporalField temporalField, long l) {
        this.addFieldValue(temporalField, l);
    }

    private Long getFieldValue0(TemporalField temporalField) {
        return (Long)this.fieldValues.get(temporalField);
    }

    DateTimeBuilder addFieldValue(TemporalField temporalField, long l) {
        Jdk8Methods.requireNonNull(temporalField, "field");
        Long l2 = this.getFieldValue0(temporalField);
        if (l2 != null && l2 != l) {
            throw new DateTimeException("Conflict found: " + temporalField + " " + l2 + " differs from " + temporalField + " " + l + ": " + this);
        }
        return this.putFieldValue0(temporalField, l);
    }

    private DateTimeBuilder putFieldValue0(TemporalField temporalField, long l) {
        this.fieldValues.put(temporalField, l);
        return this;
    }

    void addObject(ChronoLocalDate chronoLocalDate) {
        this.date = chronoLocalDate;
    }

    void addObject(LocalTime localTime) {
        this.time = localTime;
    }

    public DateTimeBuilder resolve(ResolverStyle resolverStyle, Set set) {
        if (set != null) {
            this.fieldValues.keySet().retainAll(set);
        }
        this.mergeInstantFields();
        this.mergeDate(resolverStyle);
        this.mergeTime(resolverStyle);
        if (this.resolveFields(resolverStyle)) {
            this.mergeInstantFields();
            this.mergeDate(resolverStyle);
            this.mergeTime(resolverStyle);
        }
        this.resolveTimeInferZeroes(resolverStyle);
        this.crossCheck();
        if (this.excessDays != null && !this.excessDays.isZero() && this.date != null && this.time != null) {
            this.date = this.date.plus(this.excessDays);
            this.excessDays = Period.ZERO;
        }
        this.resolveFractional();
        this.resolveInstant();
        return this;
    }

    private boolean resolveFields(ResolverStyle resolverStyle) {
        int n = 0;
        block0: while (n < 100) {
            for (Map.Entry entry : this.fieldValues.entrySet()) {
                TemporalField temporalField = (TemporalField)entry.getKey();
                TemporalAccessor temporalAccessor = temporalField.resolve(this.fieldValues, this, resolverStyle);
                if (temporalAccessor != null) {
                    DefaultInterfaceTemporal defaultInterfaceTemporal;
                    if (temporalAccessor instanceof ChronoZonedDateTime) {
                        defaultInterfaceTemporal = (ChronoZonedDateTime)temporalAccessor;
                        if (this.zone == null) {
                            this.zone = ((ChronoZonedDateTime)defaultInterfaceTemporal).getZone();
                        } else if (!this.zone.equals(((ChronoZonedDateTime)defaultInterfaceTemporal).getZone())) {
                            throw new DateTimeException("ChronoZonedDateTime must use the effective parsed zone: " + this.zone);
                        }
                        temporalAccessor = ((ChronoZonedDateTime)defaultInterfaceTemporal).toLocalDateTime();
                    }
                    if (temporalAccessor instanceof ChronoLocalDate) {
                        this.resolveMakeChanges(temporalField, (ChronoLocalDate)temporalAccessor);
                        ++n;
                        continue block0;
                    }
                    if (temporalAccessor instanceof LocalTime) {
                        this.resolveMakeChanges(temporalField, (LocalTime)temporalAccessor);
                        ++n;
                        continue block0;
                    }
                    if (temporalAccessor instanceof ChronoLocalDateTime) {
                        defaultInterfaceTemporal = (ChronoLocalDateTime)temporalAccessor;
                        this.resolveMakeChanges(temporalField, ((ChronoLocalDateTime)defaultInterfaceTemporal).toLocalDate());
                        this.resolveMakeChanges(temporalField, ((ChronoLocalDateTime)defaultInterfaceTemporal).toLocalTime());
                        ++n;
                        continue block0;
                    }
                    throw new DateTimeException("Unknown type: " + temporalAccessor.getClass().getName());
                }
                if (this.fieldValues.containsKey(temporalField)) continue;
                ++n;
                continue block0;
            }
        }
        if (n == 100) {
            throw new DateTimeException("Badly written field");
        }
        return n > 0;
    }

    private void resolveMakeChanges(TemporalField temporalField, ChronoLocalDate chronoLocalDate) {
        if (!this.chrono.equals(chronoLocalDate.getChronology())) {
            throw new DateTimeException("ChronoLocalDate must use the effective parsed chronology: " + this.chrono);
        }
        long l = chronoLocalDate.toEpochDay();
        Long l2 = this.fieldValues.put(ChronoField.EPOCH_DAY, l);
        if (l2 != null && l2 != l) {
            throw new DateTimeException("Conflict found: " + LocalDate.ofEpochDay(l2) + " differs from " + LocalDate.ofEpochDay(l) + " while resolving  " + temporalField);
        }
    }

    private void resolveMakeChanges(TemporalField temporalField, LocalTime localTime) {
        long l = localTime.toNanoOfDay();
        Long l2 = this.fieldValues.put(ChronoField.NANO_OF_DAY, l);
        if (l2 != null && l2 != l) {
            throw new DateTimeException("Conflict found: " + LocalTime.ofNanoOfDay(l2) + " differs from " + localTime + " while resolving  " + temporalField);
        }
    }

    private void mergeDate(ResolverStyle resolverStyle) {
        if (this.chrono instanceof IsoChronology) {
            this.checkDate(IsoChronology.INSTANCE.resolveDate(this.fieldValues, resolverStyle));
        } else if (this.fieldValues.containsKey(ChronoField.EPOCH_DAY)) {
            this.checkDate(LocalDate.ofEpochDay((Long)this.fieldValues.remove(ChronoField.EPOCH_DAY)));
            return;
        }
    }

    private void checkDate(LocalDate localDate) {
        if (localDate != null) {
            this.addObject(localDate);
            for (TemporalField temporalField : this.fieldValues.keySet()) {
                long l;
                if (!(temporalField instanceof ChronoField) || !temporalField.isDateBased()) continue;
                try {
                    l = localDate.getLong(temporalField);
                }
                catch (DateTimeException dateTimeException) {
                    continue;
                }
                Long l2 = (Long)this.fieldValues.get(temporalField);
                if (l == l2) continue;
                throw new DateTimeException("Conflict found: Field " + temporalField + " " + l + " differs from " + temporalField + " " + l2 + " derived from " + localDate);
            }
        }
    }

    private void mergeTime(ResolverStyle resolverStyle) {
        long l;
        long l2;
        if (this.fieldValues.containsKey(ChronoField.CLOCK_HOUR_OF_DAY)) {
            l2 = (Long)this.fieldValues.remove(ChronoField.CLOCK_HOUR_OF_DAY);
            if (resolverStyle != ResolverStyle.LENIENT && (resolverStyle != ResolverStyle.SMART || l2 != 0L)) {
                ChronoField.CLOCK_HOUR_OF_DAY.checkValidValue(l2);
            }
            this.addFieldValue(ChronoField.HOUR_OF_DAY, l2 == 24L ? 0L : l2);
        }
        if (this.fieldValues.containsKey(ChronoField.CLOCK_HOUR_OF_AMPM)) {
            l2 = (Long)this.fieldValues.remove(ChronoField.CLOCK_HOUR_OF_AMPM);
            if (resolverStyle != ResolverStyle.LENIENT && (resolverStyle != ResolverStyle.SMART || l2 != 0L)) {
                ChronoField.CLOCK_HOUR_OF_AMPM.checkValidValue(l2);
            }
            this.addFieldValue(ChronoField.HOUR_OF_AMPM, l2 == 12L ? 0L : l2);
        }
        if (resolverStyle != ResolverStyle.LENIENT) {
            if (this.fieldValues.containsKey(ChronoField.AMPM_OF_DAY)) {
                ChronoField.AMPM_OF_DAY.checkValidValue((Long)this.fieldValues.get(ChronoField.AMPM_OF_DAY));
            }
            if (this.fieldValues.containsKey(ChronoField.HOUR_OF_AMPM)) {
                ChronoField.HOUR_OF_AMPM.checkValidValue((Long)this.fieldValues.get(ChronoField.HOUR_OF_AMPM));
            }
        }
        if (this.fieldValues.containsKey(ChronoField.AMPM_OF_DAY) && this.fieldValues.containsKey(ChronoField.HOUR_OF_AMPM)) {
            l2 = (Long)this.fieldValues.remove(ChronoField.AMPM_OF_DAY);
            l = (Long)this.fieldValues.remove(ChronoField.HOUR_OF_AMPM);
            this.addFieldValue(ChronoField.HOUR_OF_DAY, l2 * 12L + l);
        }
        if (this.fieldValues.containsKey(ChronoField.NANO_OF_DAY)) {
            l2 = (Long)this.fieldValues.remove(ChronoField.NANO_OF_DAY);
            if (resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.NANO_OF_DAY.checkValidValue(l2);
            }
            this.addFieldValue(ChronoField.SECOND_OF_DAY, l2 / 1000000000L);
            this.addFieldValue(ChronoField.NANO_OF_SECOND, l2 % 1000000000L);
        }
        if (this.fieldValues.containsKey(ChronoField.MICRO_OF_DAY)) {
            l2 = (Long)this.fieldValues.remove(ChronoField.MICRO_OF_DAY);
            if (resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.MICRO_OF_DAY.checkValidValue(l2);
            }
            this.addFieldValue(ChronoField.SECOND_OF_DAY, l2 / 1000000L);
            this.addFieldValue(ChronoField.MICRO_OF_SECOND, l2 % 1000000L);
        }
        if (this.fieldValues.containsKey(ChronoField.MILLI_OF_DAY)) {
            l2 = (Long)this.fieldValues.remove(ChronoField.MILLI_OF_DAY);
            if (resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.MILLI_OF_DAY.checkValidValue(l2);
            }
            this.addFieldValue(ChronoField.SECOND_OF_DAY, l2 / 1000L);
            this.addFieldValue(ChronoField.MILLI_OF_SECOND, l2 % 1000L);
        }
        if (this.fieldValues.containsKey(ChronoField.SECOND_OF_DAY)) {
            l2 = (Long)this.fieldValues.remove(ChronoField.SECOND_OF_DAY);
            if (resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.SECOND_OF_DAY.checkValidValue(l2);
            }
            this.addFieldValue(ChronoField.HOUR_OF_DAY, l2 / 3600L);
            this.addFieldValue(ChronoField.MINUTE_OF_HOUR, l2 / 60L % 60L);
            this.addFieldValue(ChronoField.SECOND_OF_MINUTE, l2 % 60L);
        }
        if (this.fieldValues.containsKey(ChronoField.MINUTE_OF_DAY)) {
            l2 = (Long)this.fieldValues.remove(ChronoField.MINUTE_OF_DAY);
            if (resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.MINUTE_OF_DAY.checkValidValue(l2);
            }
            this.addFieldValue(ChronoField.HOUR_OF_DAY, l2 / 60L);
            this.addFieldValue(ChronoField.MINUTE_OF_HOUR, l2 % 60L);
        }
        if (resolverStyle != ResolverStyle.LENIENT) {
            if (this.fieldValues.containsKey(ChronoField.MILLI_OF_SECOND)) {
                ChronoField.MILLI_OF_SECOND.checkValidValue((Long)this.fieldValues.get(ChronoField.MILLI_OF_SECOND));
            }
            if (this.fieldValues.containsKey(ChronoField.MICRO_OF_SECOND)) {
                ChronoField.MICRO_OF_SECOND.checkValidValue((Long)this.fieldValues.get(ChronoField.MICRO_OF_SECOND));
            }
        }
        if (this.fieldValues.containsKey(ChronoField.MILLI_OF_SECOND) && this.fieldValues.containsKey(ChronoField.MICRO_OF_SECOND)) {
            l2 = (Long)this.fieldValues.remove(ChronoField.MILLI_OF_SECOND);
            l = (Long)this.fieldValues.get(ChronoField.MICRO_OF_SECOND);
            this.addFieldValue(ChronoField.MICRO_OF_SECOND, l2 * 1000L + l % 1000L);
        }
        if (this.fieldValues.containsKey(ChronoField.MICRO_OF_SECOND) && this.fieldValues.containsKey(ChronoField.NANO_OF_SECOND)) {
            l2 = (Long)this.fieldValues.get(ChronoField.NANO_OF_SECOND);
            this.addFieldValue(ChronoField.MICRO_OF_SECOND, l2 / 1000L);
            this.fieldValues.remove(ChronoField.MICRO_OF_SECOND);
        }
        if (this.fieldValues.containsKey(ChronoField.MILLI_OF_SECOND) && this.fieldValues.containsKey(ChronoField.NANO_OF_SECOND)) {
            l2 = (Long)this.fieldValues.get(ChronoField.NANO_OF_SECOND);
            this.addFieldValue(ChronoField.MILLI_OF_SECOND, l2 / 1000000L);
            this.fieldValues.remove(ChronoField.MILLI_OF_SECOND);
        }
        if (this.fieldValues.containsKey(ChronoField.MICRO_OF_SECOND)) {
            l2 = (Long)this.fieldValues.remove(ChronoField.MICRO_OF_SECOND);
            this.addFieldValue(ChronoField.NANO_OF_SECOND, l2 * 1000L);
        } else if (this.fieldValues.containsKey(ChronoField.MILLI_OF_SECOND)) {
            l2 = (Long)this.fieldValues.remove(ChronoField.MILLI_OF_SECOND);
            this.addFieldValue(ChronoField.NANO_OF_SECOND, l2 * 1000000L);
        }
    }

    private void resolveTimeInferZeroes(ResolverStyle resolverStyle) {
        Long l = (Long)this.fieldValues.get(ChronoField.HOUR_OF_DAY);
        Long l2 = (Long)this.fieldValues.get(ChronoField.MINUTE_OF_HOUR);
        Long l3 = (Long)this.fieldValues.get(ChronoField.SECOND_OF_MINUTE);
        Long l4 = (Long)this.fieldValues.get(ChronoField.NANO_OF_SECOND);
        if (l == null) {
            return;
        }
        if (l2 == null && (l3 != null || l4 != null)) {
            return;
        }
        if (l2 != null && l3 == null && l4 != null) {
            return;
        }
        if (resolverStyle != ResolverStyle.LENIENT) {
            if (l != null) {
                if (!(resolverStyle != ResolverStyle.SMART || l != 24L || l2 != null && l2 != 0L || l3 != null && l3 != 0L || l4 != null && l4 != 0L)) {
                    l = 0L;
                    this.excessDays = Period.ofDays(1);
                }
                int n = ChronoField.HOUR_OF_DAY.checkValidIntValue(l);
                if (l2 != null) {
                    int n2 = ChronoField.MINUTE_OF_HOUR.checkValidIntValue(l2);
                    if (l3 != null) {
                        int n3 = ChronoField.SECOND_OF_MINUTE.checkValidIntValue(l3);
                        if (l4 != null) {
                            int n4 = ChronoField.NANO_OF_SECOND.checkValidIntValue(l4);
                            this.addObject(LocalTime.of(n, n2, n3, n4));
                        } else {
                            this.addObject(LocalTime.of(n, n2, n3));
                        }
                    } else if (l4 == null) {
                        this.addObject(LocalTime.of(n, n2));
                    }
                } else if (l3 == null && l4 == null) {
                    this.addObject(LocalTime.of(n, 0));
                }
            }
        } else if (l != null) {
            long l5 = l;
            if (l2 != null) {
                if (l3 != null) {
                    if (l4 == null) {
                        l4 = 0L;
                    }
                    long l6 = Jdk8Methods.safeMultiply(l5, 3600000000000L);
                    l6 = Jdk8Methods.safeAdd(l6, Jdk8Methods.safeMultiply((long)l2, 60000000000L));
                    l6 = Jdk8Methods.safeAdd(l6, Jdk8Methods.safeMultiply((long)l3, 1000000000L));
                    l6 = Jdk8Methods.safeAdd(l6, l4);
                    int n = (int)Jdk8Methods.floorDiv(l6, 86400000000000L);
                    long l7 = Jdk8Methods.floorMod(l6, 86400000000000L);
                    this.addObject(LocalTime.ofNanoOfDay(l7));
                    this.excessDays = Period.ofDays(n);
                } else {
                    long l8 = Jdk8Methods.safeMultiply(l5, 3600L);
                    l8 = Jdk8Methods.safeAdd(l8, Jdk8Methods.safeMultiply((long)l2, 60L));
                    int n = (int)Jdk8Methods.floorDiv(l8, 86400L);
                    long l9 = Jdk8Methods.floorMod(l8, 86400L);
                    this.addObject(LocalTime.ofSecondOfDay(l9));
                    this.excessDays = Period.ofDays(n);
                }
            } else {
                int n = Jdk8Methods.safeToInt(Jdk8Methods.floorDiv(l5, 24L));
                l5 = Jdk8Methods.floorMod(l5, 24);
                this.addObject(LocalTime.of((int)l5, 0));
                this.excessDays = Period.ofDays(n);
            }
        }
        this.fieldValues.remove(ChronoField.HOUR_OF_DAY);
        this.fieldValues.remove(ChronoField.MINUTE_OF_HOUR);
        this.fieldValues.remove(ChronoField.SECOND_OF_MINUTE);
        this.fieldValues.remove(ChronoField.NANO_OF_SECOND);
    }

    private void mergeInstantFields() {
        if (this.fieldValues.containsKey(ChronoField.INSTANT_SECONDS)) {
            if (this.zone != null) {
                this.mergeInstantFields0(this.zone);
            } else {
                Long l = (Long)this.fieldValues.get(ChronoField.OFFSET_SECONDS);
                if (l != null) {
                    ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(l.intValue());
                    this.mergeInstantFields0(zoneOffset);
                }
            }
        }
    }

    private void mergeInstantFields0(ZoneId zoneId) {
        Instant instant = Instant.ofEpochSecond((Long)this.fieldValues.remove(ChronoField.INSTANT_SECONDS));
        ChronoZonedDateTime chronoZonedDateTime = this.chrono.zonedDateTime(instant, zoneId);
        if (this.date == null) {
            this.addObject(chronoZonedDateTime.toLocalDate());
        } else {
            this.resolveMakeChanges((TemporalField)ChronoField.INSTANT_SECONDS, chronoZonedDateTime.toLocalDate());
        }
        this.addFieldValue(ChronoField.SECOND_OF_DAY, chronoZonedDateTime.toLocalTime().toSecondOfDay());
    }

    private void crossCheck() {
        if (this.fieldValues.size() > 0) {
            if (this.date != null && this.time != null) {
                this.crossCheck(this.date.atTime(this.time));
            } else if (this.date != null) {
                this.crossCheck(this.date);
            } else if (this.time != null) {
                this.crossCheck(this.time);
            }
        }
    }

    private void crossCheck(TemporalAccessor temporalAccessor) {
        Iterator iterator = this.fieldValues.entrySet().iterator();
        while (iterator.hasNext()) {
            long l;
            Map.Entry entry = iterator.next();
            TemporalField temporalField = (TemporalField)entry.getKey();
            long l2 = (Long)entry.getValue();
            if (!temporalAccessor.isSupported(temporalField)) continue;
            try {
                l = temporalAccessor.getLong(temporalField);
            }
            catch (RuntimeException runtimeException) {
                continue;
            }
            if (l != l2) {
                throw new DateTimeException("Cross check failed: " + temporalField + " " + l + " vs " + temporalField + " " + l2);
            }
            iterator.remove();
        }
    }

    private void resolveFractional() {
        if (this.time == null && (this.fieldValues.containsKey(ChronoField.INSTANT_SECONDS) || this.fieldValues.containsKey(ChronoField.SECOND_OF_DAY) || this.fieldValues.containsKey(ChronoField.SECOND_OF_MINUTE))) {
            if (this.fieldValues.containsKey(ChronoField.NANO_OF_SECOND)) {
                long l = (Long)this.fieldValues.get(ChronoField.NANO_OF_SECOND);
                this.fieldValues.put(ChronoField.MICRO_OF_SECOND, l / 1000L);
                this.fieldValues.put(ChronoField.MILLI_OF_SECOND, l / 1000000L);
            } else {
                this.fieldValues.put(ChronoField.NANO_OF_SECOND, 0L);
                this.fieldValues.put(ChronoField.MICRO_OF_SECOND, 0L);
                this.fieldValues.put(ChronoField.MILLI_OF_SECOND, 0L);
            }
        }
    }

    private void resolveInstant() {
        if (this.date != null && this.time != null) {
            Long l = (Long)this.fieldValues.get(ChronoField.OFFSET_SECONDS);
            if (l != null) {
                ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(l.intValue());
                long l2 = this.date.atTime(this.time).atZone(zoneOffset).getLong(ChronoField.INSTANT_SECONDS);
                this.fieldValues.put(ChronoField.INSTANT_SECONDS, l2);
            } else if (this.zone != null) {
                long l3 = this.date.atTime(this.time).atZone(this.zone).getLong(ChronoField.INSTANT_SECONDS);
                this.fieldValues.put(ChronoField.INSTANT_SECONDS, l3);
            }
        }
    }

    public Object build(TemporalQuery temporalQuery) {
        return temporalQuery.queryFrom(this);
    }

    public boolean isSupported(TemporalField temporalField) {
        if (temporalField == null) {
            return false;
        }
        return this.fieldValues.containsKey(temporalField) || this.date != null && this.date.isSupported(temporalField) || this.time != null && this.time.isSupported(temporalField);
    }

    public long getLong(TemporalField temporalField) {
        Jdk8Methods.requireNonNull(temporalField, "field");
        Long l = this.getFieldValue0(temporalField);
        if (l == null) {
            if (this.date != null && this.date.isSupported(temporalField)) {
                return this.date.getLong(temporalField);
            }
            if (this.time != null && this.time.isSupported(temporalField)) {
                return this.time.getLong(temporalField);
            }
            throw new DateTimeException("Field not found: " + temporalField);
        }
        return l;
    }

    public Object query(TemporalQuery temporalQuery) {
        if (temporalQuery == TemporalQueries.zoneId()) {
            return this.zone;
        }
        if (temporalQuery == TemporalQueries.chronology()) {
            return this.chrono;
        }
        if (temporalQuery == TemporalQueries.localDate()) {
            return this.date != null ? LocalDate.from(this.date) : null;
        }
        if (temporalQuery == TemporalQueries.localTime()) {
            return this.time;
        }
        if (temporalQuery == TemporalQueries.zone() || temporalQuery == TemporalQueries.offset()) {
            return temporalQuery.queryFrom(this);
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return null;
        }
        return temporalQuery.queryFrom(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("DateTimeBuilder[");
        if (this.fieldValues.size() > 0) {
            stringBuilder.append("fields=").append(this.fieldValues);
        }
        stringBuilder.append(", ").append(this.chrono);
        stringBuilder.append(", ").append(this.zone);
        stringBuilder.append(", ").append(this.date);
        stringBuilder.append(", ").append(this.time);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

