/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.format;

import java.io.IOException;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.chrono.IsoChronology;
import oz.threeten.bp.format.DateTimeBuilder;
import oz.threeten.bp.format.DateTimeFormatter$1;
import oz.threeten.bp.format.DateTimeFormatter$2;
import oz.threeten.bp.format.DateTimeFormatter$ClassicFormat;
import oz.threeten.bp.format.DateTimeFormatterBuilder;
import oz.threeten.bp.format.DateTimeFormatterBuilder$CompositePrinterParser;
import oz.threeten.bp.format.DateTimeParseContext;
import oz.threeten.bp.format.DateTimeParseContext$Parsed;
import oz.threeten.bp.format.DateTimeParseException;
import oz.threeten.bp.format.DateTimePrintContext;
import oz.threeten.bp.format.DecimalStyle;
import oz.threeten.bp.format.FormatStyle;
import oz.threeten.bp.format.ResolverStyle;
import oz.threeten.bp.format.SignStyle;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.IsoFields;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalQuery;

public final class DateTimeFormatter {
    public static final DateTimeFormatter ISO_LOCAL_DATE = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    public static final DateTimeFormatter ISO_OFFSET_DATE = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE).appendOffsetId().toFormatter(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    public static final DateTimeFormatter ISO_DATE = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE).optionalStart().appendOffsetId().toFormatter(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    public static final DateTimeFormatter ISO_LOCAL_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter(ResolverStyle.STRICT);
    public static final DateTimeFormatter ISO_OFFSET_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_TIME).appendOffsetId().toFormatter(ResolverStyle.STRICT);
    public static final DateTimeFormatter ISO_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_TIME).optionalStart().appendOffsetId().toFormatter(ResolverStyle.STRICT);
    public static final DateTimeFormatter ISO_LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE).appendLiteral('T').append(ISO_LOCAL_TIME).toFormatter(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_TIME).appendOffsetId().toFormatter(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    public static final DateTimeFormatter ISO_ZONED_DATE_TIME = new DateTimeFormatterBuilder().append(ISO_OFFSET_DATE_TIME).optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    public static final DateTimeFormatter ISO_DATE_TIME = new DateTimeFormatterBuilder().append(ISO_LOCAL_DATE_TIME).optionalStart().appendOffsetId().optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    public static final DateTimeFormatter ISO_ORDINAL_DATE = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.DAY_OF_YEAR, 3).optionalStart().appendOffsetId().toFormatter(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    public static final DateTimeFormatter ISO_WEEK_DATE = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(IsoFields.WEEK_BASED_YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral("-W").appendValue(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_WEEK, 1).optionalStart().appendOffsetId().toFormatter(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    public static final DateTimeFormatter ISO_INSTANT = new DateTimeFormatterBuilder().parseCaseInsensitive().appendInstant().toFormatter(ResolverStyle.STRICT);
    public static final DateTimeFormatter BASIC_ISO_DATE = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).optionalStart().appendOffset("+HHMMss", "Z").toFormatter(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    public static final DateTimeFormatter RFC_1123_DATE_TIME;
    private static final TemporalQuery PARSED_EXCESS_DAYS;
    private static final TemporalQuery PARSED_LEAP_SECOND;
    private final DateTimeFormatterBuilder$CompositePrinterParser printerParser;
    private final Locale locale;
    private final DecimalStyle decimalStyle;
    private final ResolverStyle resolverStyle;
    private final Set resolverFields;
    private final Chronology chrono;
    private final ZoneId zone;

    public static DateTimeFormatter ofPattern(String string) {
        return new DateTimeFormatterBuilder().appendPattern(string).toFormatter();
    }

    public static DateTimeFormatter ofPattern(String string, Locale locale) {
        return new DateTimeFormatterBuilder().appendPattern(string).toFormatter(locale);
    }

    public static DateTimeFormatter ofLocalizedDate(FormatStyle formatStyle) {
        Jdk8Methods.requireNonNull((Object)formatStyle, "dateStyle");
        return new DateTimeFormatterBuilder().appendLocalized(formatStyle, null).toFormatter().withChronology(IsoChronology.INSTANCE);
    }

    public static DateTimeFormatter ofLocalizedTime(FormatStyle formatStyle) {
        Jdk8Methods.requireNonNull((Object)formatStyle, "timeStyle");
        return new DateTimeFormatterBuilder().appendLocalized(null, formatStyle).toFormatter().withChronology(IsoChronology.INSTANCE);
    }

    public static DateTimeFormatter ofLocalizedDateTime(FormatStyle formatStyle) {
        Jdk8Methods.requireNonNull((Object)formatStyle, "dateTimeStyle");
        return new DateTimeFormatterBuilder().appendLocalized(formatStyle, formatStyle).toFormatter().withChronology(IsoChronology.INSTANCE);
    }

    public static DateTimeFormatter ofLocalizedDateTime(FormatStyle formatStyle, FormatStyle formatStyle2) {
        Jdk8Methods.requireNonNull((Object)formatStyle, "dateStyle");
        Jdk8Methods.requireNonNull((Object)formatStyle2, "timeStyle");
        return new DateTimeFormatterBuilder().appendLocalized(formatStyle, formatStyle2).toFormatter().withChronology(IsoChronology.INSTANCE);
    }

    public static final TemporalQuery parsedExcessDays() {
        return PARSED_EXCESS_DAYS;
    }

    public static final TemporalQuery parsedLeapSecond() {
        return PARSED_LEAP_SECOND;
    }

    DateTimeFormatter(DateTimeFormatterBuilder$CompositePrinterParser dateTimeFormatterBuilder$CompositePrinterParser, Locale locale, DecimalStyle decimalStyle, ResolverStyle resolverStyle, Set set, Chronology chronology, ZoneId zoneId) {
        this.printerParser = (DateTimeFormatterBuilder$CompositePrinterParser)Jdk8Methods.requireNonNull(dateTimeFormatterBuilder$CompositePrinterParser, "printerParser");
        this.locale = (Locale)Jdk8Methods.requireNonNull(locale, "locale");
        this.decimalStyle = (DecimalStyle)Jdk8Methods.requireNonNull(decimalStyle, "decimalStyle");
        this.resolverStyle = (ResolverStyle)((Object)Jdk8Methods.requireNonNull((Object)resolverStyle, "resolverStyle"));
        this.resolverFields = set;
        this.chrono = chronology;
        this.zone = zoneId;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public DateTimeFormatter withLocale(Locale locale) {
        if (this.locale.equals(locale)) {
            return this;
        }
        return new DateTimeFormatter(this.printerParser, locale, this.decimalStyle, this.resolverStyle, this.resolverFields, this.chrono, this.zone);
    }

    public DecimalStyle getDecimalStyle() {
        return this.decimalStyle;
    }

    public DateTimeFormatter withDecimalStyle(DecimalStyle decimalStyle) {
        if (this.decimalStyle.equals(decimalStyle)) {
            return this;
        }
        return new DateTimeFormatter(this.printerParser, this.locale, decimalStyle, this.resolverStyle, this.resolverFields, this.chrono, this.zone);
    }

    public Chronology getChronology() {
        return this.chrono;
    }

    public DateTimeFormatter withChronology(Chronology chronology) {
        if (Jdk8Methods.equals(this.chrono, chronology)) {
            return this;
        }
        return new DateTimeFormatter(this.printerParser, this.locale, this.decimalStyle, this.resolverStyle, this.resolverFields, chronology, this.zone);
    }

    public ZoneId getZone() {
        return this.zone;
    }

    public DateTimeFormatter withZone(ZoneId zoneId) {
        if (Jdk8Methods.equals(this.zone, zoneId)) {
            return this;
        }
        return new DateTimeFormatter(this.printerParser, this.locale, this.decimalStyle, this.resolverStyle, this.resolverFields, this.chrono, zoneId);
    }

    public ResolverStyle getResolverStyle() {
        return this.resolverStyle;
    }

    public DateTimeFormatter withResolverStyle(ResolverStyle resolverStyle) {
        Jdk8Methods.requireNonNull((Object)resolverStyle, "resolverStyle");
        if (Jdk8Methods.equals((Object)this.resolverStyle, (Object)resolverStyle)) {
            return this;
        }
        return new DateTimeFormatter(this.printerParser, this.locale, this.decimalStyle, resolverStyle, this.resolverFields, this.chrono, this.zone);
    }

    public Set getResolverFields() {
        return this.resolverFields;
    }

    public DateTimeFormatter withResolverFields(TemporalField ... temporalFieldArray) {
        if (temporalFieldArray == null) {
            return new DateTimeFormatter(this.printerParser, this.locale, this.decimalStyle, this.resolverStyle, null, this.chrono, this.zone);
        }
        Set<TemporalField> set = new HashSet<TemporalField>(Arrays.asList(temporalFieldArray));
        if (Jdk8Methods.equals(this.resolverFields, set)) {
            return this;
        }
        set = Collections.unmodifiableSet(set);
        return new DateTimeFormatter(this.printerParser, this.locale, this.decimalStyle, this.resolverStyle, set, this.chrono, this.zone);
    }

    public DateTimeFormatter withResolverFields(Set set) {
        if (set == null) {
            return new DateTimeFormatter(this.printerParser, this.locale, this.decimalStyle, this.resolverStyle, null, this.chrono, this.zone);
        }
        if (Jdk8Methods.equals(this.resolverFields, set)) {
            return this;
        }
        set = Collections.unmodifiableSet(new HashSet(set));
        return new DateTimeFormatter(this.printerParser, this.locale, this.decimalStyle, this.resolverStyle, set, this.chrono, this.zone);
    }

    public String format(TemporalAccessor temporalAccessor) {
        StringBuilder stringBuilder = new StringBuilder(32);
        this.formatTo(temporalAccessor, stringBuilder);
        return stringBuilder.toString();
    }

    public void formatTo(TemporalAccessor temporalAccessor, Appendable appendable) {
        Jdk8Methods.requireNonNull(temporalAccessor, "temporal");
        Jdk8Methods.requireNonNull(appendable, "appendable");
        try {
            DateTimePrintContext dateTimePrintContext = new DateTimePrintContext(temporalAccessor, this);
            if (appendable instanceof StringBuilder) {
                this.printerParser.print(dateTimePrintContext, (StringBuilder)appendable);
            } else {
                StringBuilder stringBuilder = new StringBuilder(32);
                this.printerParser.print(dateTimePrintContext, stringBuilder);
                appendable.append(stringBuilder);
            }
        }
        catch (IOException iOException) {
            throw new DateTimeException(iOException.getMessage(), iOException);
        }
    }

    public TemporalAccessor parse(CharSequence charSequence) {
        Jdk8Methods.requireNonNull(charSequence, "text");
        try {
            return this.parseToBuilder(charSequence, null).resolve(this.resolverStyle, this.resolverFields);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw dateTimeParseException;
        }
        catch (RuntimeException runtimeException) {
            throw this.createError(charSequence, runtimeException);
        }
    }

    public TemporalAccessor parse(CharSequence charSequence, ParsePosition parsePosition) {
        Jdk8Methods.requireNonNull(charSequence, "text");
        Jdk8Methods.requireNonNull(parsePosition, "position");
        try {
            return this.parseToBuilder(charSequence, parsePosition).resolve(this.resolverStyle, this.resolverFields);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw dateTimeParseException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw indexOutOfBoundsException;
        }
        catch (RuntimeException runtimeException) {
            throw this.createError(charSequence, runtimeException);
        }
    }

    public Object parse(CharSequence charSequence, TemporalQuery temporalQuery) {
        Jdk8Methods.requireNonNull(charSequence, "text");
        Jdk8Methods.requireNonNull(temporalQuery, "type");
        try {
            DateTimeBuilder dateTimeBuilder = this.parseToBuilder(charSequence, null).resolve(this.resolverStyle, this.resolverFields);
            return dateTimeBuilder.build(temporalQuery);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw dateTimeParseException;
        }
        catch (RuntimeException runtimeException) {
            throw this.createError(charSequence, runtimeException);
        }
    }

    public TemporalAccessor parseBest(CharSequence charSequence, TemporalQuery ... temporalQueryArray) {
        Jdk8Methods.requireNonNull(charSequence, "text");
        Jdk8Methods.requireNonNull(temporalQueryArray, "types");
        if (temporalQueryArray.length < 2) {
            throw new IllegalArgumentException("At least two types must be specified");
        }
        try {
            DateTimeBuilder dateTimeBuilder = this.parseToBuilder(charSequence, null).resolve(this.resolverStyle, this.resolverFields);
            for (TemporalQuery temporalQuery : temporalQueryArray) {
                try {
                    return (TemporalAccessor)dateTimeBuilder.build(temporalQuery);
                }
                catch (RuntimeException runtimeException) {
                }
            }
            throw new DateTimeException("Unable to convert parsed text to any specified type: " + Arrays.toString(temporalQueryArray));
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw dateTimeParseException;
        }
        catch (RuntimeException runtimeException) {
            throw this.createError(charSequence, runtimeException);
        }
    }

    private DateTimeParseException createError(CharSequence charSequence, RuntimeException runtimeException) {
        String string = "";
        string = charSequence.length() > 64 ? charSequence.subSequence(0, 64).toString() + "..." : charSequence.toString();
        return new DateTimeParseException("Text '" + string + "' could not be parsed: " + runtimeException.getMessage(), charSequence, 0, runtimeException);
    }

    private DateTimeBuilder parseToBuilder(CharSequence charSequence, ParsePosition parsePosition) {
        ParsePosition parsePosition2 = parsePosition != null ? parsePosition : new ParsePosition(0);
        DateTimeParseContext$Parsed dateTimeParseContext$Parsed = this.parseUnresolved0(charSequence, parsePosition2);
        if (dateTimeParseContext$Parsed == null || parsePosition2.getErrorIndex() >= 0 || parsePosition == null && parsePosition2.getIndex() < charSequence.length()) {
            String string = "";
            string = charSequence.length() > 64 ? charSequence.subSequence(0, 64).toString() + "..." : charSequence.toString();
            if (parsePosition2.getErrorIndex() >= 0) {
                throw new DateTimeParseException("Text '" + string + "' could not be parsed at index " + parsePosition2.getErrorIndex(), charSequence, parsePosition2.getErrorIndex());
            }
            throw new DateTimeParseException("Text '" + string + "' could not be parsed, unparsed text found at index " + parsePosition2.getIndex(), charSequence, parsePosition2.getIndex());
        }
        return dateTimeParseContext$Parsed.toBuilder();
    }

    public TemporalAccessor parseUnresolved(CharSequence charSequence, ParsePosition parsePosition) {
        return this.parseUnresolved0(charSequence, parsePosition);
    }

    private DateTimeParseContext$Parsed parseUnresolved0(CharSequence charSequence, ParsePosition parsePosition) {
        Jdk8Methods.requireNonNull(charSequence, "text");
        Jdk8Methods.requireNonNull(parsePosition, "position");
        DateTimeParseContext dateTimeParseContext = new DateTimeParseContext(this);
        int n = parsePosition.getIndex();
        n = this.printerParser.parse(dateTimeParseContext, charSequence, n);
        if (n < 0) {
            parsePosition.setErrorIndex(~n);
            return null;
        }
        parsePosition.setIndex(n);
        return dateTimeParseContext.toParsed();
    }

    DateTimeFormatterBuilder$CompositePrinterParser toPrinterParser(boolean bl) {
        return this.printerParser.withOptional(bl);
    }

    public Format toFormat() {
        return new DateTimeFormatter$ClassicFormat(this, null);
    }

    public Format toFormat(TemporalQuery temporalQuery) {
        Jdk8Methods.requireNonNull(temporalQuery, "query");
        return new DateTimeFormatter$ClassicFormat(this, temporalQuery);
    }

    public String toString() {
        String string = this.printerParser.toString();
        return string.startsWith("[") ? string : string.substring(1, string.length() - 1);
    }

    static /* synthetic */ DateTimeBuilder access$000(DateTimeFormatter dateTimeFormatter, CharSequence charSequence, ParsePosition parsePosition) {
        return dateTimeFormatter.parseToBuilder(charSequence, parsePosition);
    }

    static /* synthetic */ DateTimeParseContext$Parsed access$100(DateTimeFormatter dateTimeFormatter, CharSequence charSequence, ParsePosition parsePosition) {
        return dateTimeFormatter.parseUnresolved0(charSequence, parsePosition);
    }

    static {
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        hashMap.put(1L, "Mon");
        hashMap.put(2L, "Tue");
        hashMap.put(3L, "Wed");
        hashMap.put(4L, "Thu");
        hashMap.put(5L, "Fri");
        hashMap.put(6L, "Sat");
        hashMap.put(7L, "Sun");
        HashMap<Long, String> hashMap2 = new HashMap<Long, String>();
        hashMap2.put(1L, "Jan");
        hashMap2.put(2L, "Feb");
        hashMap2.put(3L, "Mar");
        hashMap2.put(4L, "Apr");
        hashMap2.put(5L, "May");
        hashMap2.put(6L, "Jun");
        hashMap2.put(7L, "Jul");
        hashMap2.put(8L, "Aug");
        hashMap2.put(9L, "Sep");
        hashMap2.put(10L, "Oct");
        hashMap2.put(11L, "Nov");
        hashMap2.put(12L, "Dec");
        RFC_1123_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().optionalStart().appendText((TemporalField)ChronoField.DAY_OF_WEEK, hashMap).appendLiteral(", ").optionalEnd().appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(' ').appendText((TemporalField)ChronoField.MONTH_OF_YEAR, hashMap2).appendLiteral(' ').appendValue(ChronoField.YEAR, 4).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().appendLiteral(' ').appendOffset("+HHMM", "GMT").toFormatter(ResolverStyle.SMART).withChronology(IsoChronology.INSTANCE);
        PARSED_EXCESS_DAYS = new DateTimeFormatter$1();
        PARSED_LEAP_SECOND = new DateTimeFormatter$2();
    }
}

