/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.format;

import java.math.BigDecimal;
import java.math.RoundingMode;
import oz.threeten.bp.format.DateTimeFormatterBuilder$DateTimePrinterParser;
import oz.threeten.bp.format.DateTimeParseContext;
import oz.threeten.bp.format.DateTimePrintContext;
import oz.threeten.bp.format.DecimalStyle;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.ValueRange;

final class DateTimeFormatterBuilder$FractionPrinterParser
implements DateTimeFormatterBuilder$DateTimePrinterParser {
    private final TemporalField field;
    private final int minWidth;
    private final int maxWidth;
    private final boolean decimalPoint;

    DateTimeFormatterBuilder$FractionPrinterParser(TemporalField temporalField, int n, int n2, boolean bl) {
        Jdk8Methods.requireNonNull(temporalField, "field");
        if (!temporalField.range().isFixed()) {
            throw new IllegalArgumentException("Field must have a fixed set of values: " + temporalField);
        }
        if (n < 0 || n > 9) {
            throw new IllegalArgumentException("Minimum width must be from 0 to 9 inclusive but was " + n);
        }
        if (n2 < 1 || n2 > 9) {
            throw new IllegalArgumentException("Maximum width must be from 1 to 9 inclusive but was " + n2);
        }
        if (n2 < n) {
            throw new IllegalArgumentException("Maximum width must exceed or equal the minimum width but " + n2 + " < " + n);
        }
        this.field = temporalField;
        this.minWidth = n;
        this.maxWidth = n2;
        this.decimalPoint = bl;
    }

    public boolean print(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
        Long l = dateTimePrintContext.getValue(this.field);
        if (l == null) {
            return false;
        }
        DecimalStyle decimalStyle = dateTimePrintContext.getSymbols();
        BigDecimal bigDecimal = this.convertToFraction(l);
        if (bigDecimal.scale() == 0) {
            if (this.minWidth > 0) {
                if (this.decimalPoint) {
                    stringBuilder.append(decimalStyle.getDecimalSeparator());
                }
                for (int j = 0; j < this.minWidth; ++j) {
                    stringBuilder.append(decimalStyle.getZeroDigit());
                }
            }
        } else {
            int n = Math.min(Math.max(bigDecimal.scale(), this.minWidth), this.maxWidth);
            bigDecimal = bigDecimal.setScale(n, RoundingMode.FLOOR);
            String string = bigDecimal.toPlainString().substring(2);
            string = decimalStyle.convertNumberToI18N(string);
            if (this.decimalPoint) {
                stringBuilder.append(decimalStyle.getDecimalSeparator());
            }
            stringBuilder.append(string);
        }
        return true;
    }

    public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
        int n2;
        int n3 = dateTimeParseContext.isStrict() ? this.minWidth : 0;
        int n4 = dateTimeParseContext.isStrict() ? this.maxWidth : 9;
        int n5 = charSequence.length();
        if (n == n5) {
            return n3 > 0 ? ~n : n;
        }
        if (this.decimalPoint) {
            if (charSequence.charAt(n) != dateTimeParseContext.getSymbols().getDecimalSeparator()) {
                return n3 > 0 ? ~n : n;
            }
            ++n;
        }
        if ((n2 = n + n3) > n5) {
            return ~n;
        }
        int n6 = Math.min(n + n4, n5);
        int n7 = 0;
        int n8 = n;
        while (n8 < n6) {
            char c2 = charSequence.charAt(n8++);
            int n9 = dateTimeParseContext.getSymbols().convertToDigit(c2);
            if (n9 < 0) {
                if (n8 < n2) {
                    return ~n;
                }
                --n8;
                break;
            }
            n7 = n7 * 10 + n9;
        }
        BigDecimal bigDecimal = new BigDecimal(n7).movePointLeft(n8 - n);
        long l = this.convertFromFraction(bigDecimal);
        return dateTimeParseContext.setParsedField(this.field, l, n, n8);
    }

    private BigDecimal convertToFraction(long l) {
        ValueRange valueRange = this.field.range();
        valueRange.checkValidValue(l, this.field);
        BigDecimal bigDecimal = BigDecimal.valueOf(valueRange.getMinimum());
        BigDecimal bigDecimal2 = BigDecimal.valueOf(valueRange.getMaximum()).subtract(bigDecimal).add(BigDecimal.ONE);
        BigDecimal bigDecimal3 = BigDecimal.valueOf(l).subtract(bigDecimal);
        BigDecimal bigDecimal4 = bigDecimal3.divide(bigDecimal2, 9, RoundingMode.FLOOR);
        return bigDecimal4.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : bigDecimal4.stripTrailingZeros();
    }

    private long convertFromFraction(BigDecimal bigDecimal) {
        ValueRange valueRange = this.field.range();
        BigDecimal bigDecimal2 = BigDecimal.valueOf(valueRange.getMinimum());
        BigDecimal bigDecimal3 = BigDecimal.valueOf(valueRange.getMaximum()).subtract(bigDecimal2).add(BigDecimal.ONE);
        BigDecimal bigDecimal4 = bigDecimal.multiply(bigDecimal3).setScale(0, RoundingMode.FLOOR).add(bigDecimal2);
        return bigDecimal4.longValueExact();
    }

    public String toString() {
        String string = this.decimalPoint ? ",DecimalPoint" : "";
        return "Fraction(" + this.field + "," + this.minWidth + "," + this.maxWidth + string + ")";
    }
}

