/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.format;

import oz.threeten.bp.format.DateTimeFormatterBuilder$DateTimePrinterParser;
import oz.threeten.bp.format.DateTimeParseContext;
import oz.threeten.bp.format.DateTimePrintContext;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;

final class DateTimeFormatterBuilder$OffsetIdPrinterParser
implements DateTimeFormatterBuilder$DateTimePrinterParser {
    static final String[] PATTERNS = new String[]{"+HH", "+HHmm", "+HH:mm", "+HHMM", "+HH:MM", "+HHMMss", "+HH:MM:ss", "+HHMMSS", "+HH:MM:SS"};
    static final DateTimeFormatterBuilder$OffsetIdPrinterParser INSTANCE_ID = new DateTimeFormatterBuilder$OffsetIdPrinterParser("Z", "+HH:MM:ss");
    static final DateTimeFormatterBuilder$OffsetIdPrinterParser INSTANCE_ID_ZERO = new DateTimeFormatterBuilder$OffsetIdPrinterParser("0", "+HH:MM:ss");
    private final String noOffsetText;
    private final int type;

    DateTimeFormatterBuilder$OffsetIdPrinterParser(String string, String string2) {
        Jdk8Methods.requireNonNull(string, "noOffsetText");
        Jdk8Methods.requireNonNull(string2, "pattern");
        this.noOffsetText = string;
        this.type = this.checkPattern(string2);
    }

    private int checkPattern(String string) {
        for (int j = 0; j < PATTERNS.length; ++j) {
            if (!PATTERNS[j].equals(string)) continue;
            return j;
        }
        throw new IllegalArgumentException("Invalid zone offset pattern: " + string);
    }

    public boolean print(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
        Long l = dateTimePrintContext.getValue(ChronoField.OFFSET_SECONDS);
        if (l == null) {
            return false;
        }
        int n = Jdk8Methods.safeToInt(l);
        if (n == 0) {
            stringBuilder.append(this.noOffsetText);
        } else {
            int n2 = Math.abs(n / 3600 % 100);
            int n3 = Math.abs(n / 60 % 60);
            int n4 = Math.abs(n % 60);
            int n5 = stringBuilder.length();
            int n6 = n2;
            stringBuilder.append(n < 0 ? "-" : "+").append((char)(n2 / 10 + 48)).append((char)(n2 % 10 + 48));
            if (this.type >= 3 || this.type >= 1 && n3 > 0) {
                stringBuilder.append(this.type % 2 == 0 ? ":" : "").append((char)(n3 / 10 + 48)).append((char)(n3 % 10 + 48));
                n6 += n3;
                if (this.type >= 7 || this.type >= 5 && n4 > 0) {
                    stringBuilder.append(this.type % 2 == 0 ? ":" : "").append((char)(n4 / 10 + 48)).append((char)(n4 % 10 + 48));
                    n6 += n4;
                }
            }
            if (n6 == 0) {
                stringBuilder.setLength(n5);
                stringBuilder.append(this.noOffsetText);
            }
        }
        return true;
    }

    public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
        char c2;
        int n2 = charSequence.length();
        int n3 = this.noOffsetText.length();
        if (n3 == 0) {
            if (n == n2) {
                return dateTimeParseContext.setParsedField(ChronoField.OFFSET_SECONDS, 0L, n, n);
            }
        } else {
            if (n == n2) {
                return ~n;
            }
            if (dateTimeParseContext.subSequenceEquals(charSequence, n, this.noOffsetText, 0, n3)) {
                return dateTimeParseContext.setParsedField(ChronoField.OFFSET_SECONDS, 0L, n, n + n3);
            }
        }
        if ((c2 = charSequence.charAt(n)) == '+' || c2 == '-') {
            int n4 = c2 == '-' ? -1 : 1;
            int[] nArray = new int[4];
            nArray[0] = n + 1;
            if (!(this.parseNumber(nArray, 1, charSequence, true) || this.parseNumber(nArray, 2, charSequence, this.type >= 3) || this.parseNumber(nArray, 3, charSequence, false))) {
                long l = (long)n4 * ((long)nArray[1] * 3600L + (long)nArray[2] * 60L + (long)nArray[3]);
                return dateTimeParseContext.setParsedField(ChronoField.OFFSET_SECONDS, l, n, nArray[0]);
            }
        }
        if (n3 == 0) {
            return dateTimeParseContext.setParsedField(ChronoField.OFFSET_SECONDS, 0L, n, n + n3);
        }
        return ~n;
    }

    private boolean parseNumber(int[] nArray, int n, CharSequence charSequence, boolean bl) {
        if ((this.type + 3) / 2 < n) {
            return false;
        }
        int n2 = nArray[0];
        if (this.type % 2 == 0 && n > 1) {
            if (n2 + 1 > charSequence.length() || charSequence.charAt(n2) != ':') {
                return bl;
            }
            ++n2;
        }
        if (n2 + 2 > charSequence.length()) {
            return bl;
        }
        char c2 = charSequence.charAt(n2++);
        char c3 = charSequence.charAt(n2++);
        if (c2 < '0' || c2 > '9' || c3 < '0' || c3 > '9') {
            return bl;
        }
        int n3 = (c2 - 48) * 10 + (c3 - 48);
        if (n3 < 0 || n3 > 59) {
            return bl;
        }
        nArray[n] = n3;
        nArray[0] = n2;
        return false;
    }

    public String toString() {
        String string = this.noOffsetText.replace("'", "''");
        return "Offset(" + PATTERNS[this.type] + ",'" + string + "')";
    }
}

