/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.format;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.Instant;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.format.DateTimeFormatterBuilder$DateTimePrinterParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$OffsetIdPrinterParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$ZoneTextPrinterParser$1;
import oz.threeten.bp.format.DateTimeParseContext;
import oz.threeten.bp.format.DateTimePrintContext;
import oz.threeten.bp.format.TextStyle;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalQueries;

final class DateTimeFormatterBuilder$ZoneTextPrinterParser
implements DateTimeFormatterBuilder$DateTimePrinterParser {
    private static final Comparator LENGTH_COMPARATOR = new DateTimeFormatterBuilder$ZoneTextPrinterParser$1();
    private final TextStyle textStyle;

    DateTimeFormatterBuilder$ZoneTextPrinterParser(TextStyle textStyle) {
        this.textStyle = (TextStyle)((Object)Jdk8Methods.requireNonNull((Object)textStyle, "textStyle"));
    }

    public boolean print(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
        Serializable serializable;
        ZoneId zoneId = (ZoneId)dateTimePrintContext.getValue(TemporalQueries.zoneId());
        if (zoneId == null) {
            return false;
        }
        if (zoneId.normalized() instanceof ZoneOffset) {
            stringBuilder.append(zoneId.getId());
            return true;
        }
        TemporalAccessor temporalAccessor = dateTimePrintContext.getTemporal();
        boolean bl = false;
        if (temporalAccessor.isSupported(ChronoField.INSTANT_SECONDS)) {
            serializable = Instant.ofEpochSecond(temporalAccessor.getLong(ChronoField.INSTANT_SECONDS));
            bl = zoneId.getRules().isDaylightSavings((Instant)serializable);
        }
        serializable = TimeZone.getTimeZone(zoneId.getId());
        int n = this.textStyle.asNormal() == TextStyle.FULL ? 1 : 0;
        String string = ((TimeZone)serializable).getDisplayName(bl, n, dateTimePrintContext.getLocale());
        stringBuilder.append(string);
        return true;
    }

    public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
        Object object;
        int n2 = charSequence.length();
        if (n > n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n == n2) {
            return ~n;
        }
        char c2 = charSequence.charAt(n);
        if (c2 == '+' || c2 == '-') {
            if (n + 6 > n2) {
                return ~n;
            }
            return this.parseOffset(dateTimeParseContext, charSequence, n, "");
        }
        if (dateTimeParseContext.subSequenceEquals(charSequence, n, "GMT", 0, 3)) {
            return this.parseOffset(dateTimeParseContext, charSequence, n, "GMT");
        }
        if (dateTimeParseContext.subSequenceEquals(charSequence, n, "UTC", 0, 3)) {
            return this.parseOffset(dateTimeParseContext, charSequence, n, "UTC");
        }
        if (dateTimeParseContext.subSequenceEquals(charSequence, n, "UT", 0, 2)) {
            return this.parseOffset(dateTimeParseContext, charSequence, n, "UT");
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>(LENGTH_COMPARATOR);
        for (String object2 : ZoneId.getAvailableZoneIds()) {
            treeMap.put(object2, object2);
            object = TimeZone.getTimeZone(object2);
            int n3 = this.textStyle.asNormal() == TextStyle.FULL ? 1 : 0;
            String string = ((TimeZone)object).getDisplayName(false, n3, dateTimeParseContext.getLocale());
            if (object2.startsWith("Etc/") || !string.startsWith("GMT+") && !string.startsWith("GMT+")) {
                treeMap.put(string, object2);
            }
            String string2 = ((TimeZone)object).getDisplayName(true, n3, dateTimeParseContext.getLocale());
            if (!object2.startsWith("Etc/") && (string2.startsWith("GMT+") || string2.startsWith("GMT+"))) continue;
            treeMap.put(string2, object2);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            object = (String)entry.getKey();
            if (!dateTimeParseContext.subSequenceEquals(charSequence, n, (CharSequence)object, 0, ((String)object).length())) continue;
            dateTimeParseContext.setParsed(ZoneId.of((String)entry.getValue()));
            return n + ((String)object).length();
        }
        if (c2 == 'Z') {
            dateTimeParseContext.setParsed(ZoneOffset.UTC);
            return n + 1;
        }
        return ~n;
    }

    private int parseOffset(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n, String string) {
        int n2 = string.length();
        int n3 = n + n2;
        if (n3 >= charSequence.length()) {
            dateTimeParseContext.setParsed(ZoneId.of(string));
            return n3;
        }
        char c2 = charSequence.charAt(n3);
        if (c2 != '+' && c2 != '-') {
            dateTimeParseContext.setParsed(ZoneId.of(string));
            return n3;
        }
        DateTimeParseContext dateTimeParseContext2 = dateTimeParseContext.copy();
        try {
            int n4 = DateTimeFormatterBuilder$OffsetIdPrinterParser.INSTANCE_ID_ZERO.parse(dateTimeParseContext2, charSequence, n3);
            if (n4 < 0) {
                dateTimeParseContext.setParsed(ZoneId.of(string));
                return n3;
            }
            int n5 = (int)dateTimeParseContext2.getParsed(ChronoField.OFFSET_SECONDS).longValue();
            ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(n5);
            dateTimeParseContext.setParsed(n2 == 0 ? zoneOffset : ZoneId.ofOffset(string, zoneOffset));
            return n4;
        }
        catch (DateTimeException dateTimeException) {
            return ~n;
        }
    }

    public String toString() {
        return "ZoneText(" + (Object)((Object)this.textStyle) + ")";
    }
}

