/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.format;

import java.util.ArrayList;
import java.util.Locale;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.chrono.IsoChronology;
import oz.threeten.bp.format.DateTimeFormatter;
import oz.threeten.bp.format.DateTimeFormatterBuilder$ReducedPrinterParser;
import oz.threeten.bp.format.DateTimeParseContext$Parsed;
import oz.threeten.bp.format.DecimalStyle;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.TemporalField;

final class DateTimeParseContext {
    private Locale locale;
    private DecimalStyle symbols;
    private Chronology overrideChronology;
    private ZoneId overrideZone;
    private boolean caseSensitive = true;
    private boolean strict = true;
    private final ArrayList parsed = new ArrayList();

    DateTimeParseContext(DateTimeFormatter dateTimeFormatter) {
        this.locale = dateTimeFormatter.getLocale();
        this.symbols = dateTimeFormatter.getDecimalStyle();
        this.overrideChronology = dateTimeFormatter.getChronology();
        this.overrideZone = dateTimeFormatter.getZone();
        this.parsed.add(new DateTimeParseContext$Parsed(this, null));
    }

    DateTimeParseContext(Locale locale, DecimalStyle decimalStyle, Chronology chronology) {
        this.locale = locale;
        this.symbols = decimalStyle;
        this.overrideChronology = chronology;
        this.overrideZone = null;
        this.parsed.add(new DateTimeParseContext$Parsed(this, null));
    }

    DateTimeParseContext(DateTimeParseContext dateTimeParseContext) {
        this.locale = dateTimeParseContext.locale;
        this.symbols = dateTimeParseContext.symbols;
        this.overrideChronology = dateTimeParseContext.overrideChronology;
        this.overrideZone = dateTimeParseContext.overrideZone;
        this.caseSensitive = dateTimeParseContext.caseSensitive;
        this.strict = dateTimeParseContext.strict;
        this.parsed.add(new DateTimeParseContext$Parsed(this, null));
    }

    DateTimeParseContext copy() {
        return new DateTimeParseContext(this);
    }

    Locale getLocale() {
        return this.locale;
    }

    DecimalStyle getSymbols() {
        return this.symbols;
    }

    Chronology getEffectiveChronology() {
        Chronology chronology = this.currentParsed().chrono;
        if (chronology == null && (chronology = this.overrideChronology) == null) {
            chronology = IsoChronology.INSTANCE;
        }
        return chronology;
    }

    boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    boolean subSequenceEquals(CharSequence charSequence, int n, CharSequence charSequence2, int n2, int n3) {
        if (n + n3 > charSequence.length() || n2 + n3 > charSequence2.length()) {
            return false;
        }
        if (this.isCaseSensitive()) {
            for (int j = 0; j < n3; ++j) {
                char c2;
                char c3 = charSequence.charAt(n + j);
                if (c3 == (c2 = charSequence2.charAt(n2 + j))) continue;
                return false;
            }
        } else {
            for (int j = 0; j < n3; ++j) {
                char c4;
                char c5 = charSequence.charAt(n + j);
                if (c5 == (c4 = charSequence2.charAt(n2 + j)) || Character.toUpperCase(c5) == Character.toUpperCase(c4) || Character.toLowerCase(c5) == Character.toLowerCase(c4)) continue;
                return false;
            }
        }
        return true;
    }

    boolean charEquals(char c2, char c3) {
        if (this.isCaseSensitive()) {
            return c2 == c3;
        }
        return DateTimeParseContext.charEqualsIgnoreCase(c2, c3);
    }

    static boolean charEqualsIgnoreCase(char c2, char c3) {
        return c2 == c3 || Character.toUpperCase(c2) == Character.toUpperCase(c3) || Character.toLowerCase(c2) == Character.toLowerCase(c3);
    }

    boolean isStrict() {
        return this.strict;
    }

    void setStrict(boolean bl) {
        this.strict = bl;
    }

    void startOptional() {
        this.parsed.add(this.currentParsed().copy());
    }

    void endOptional(boolean bl) {
        if (bl) {
            this.parsed.remove(this.parsed.size() - 2);
        } else {
            this.parsed.remove(this.parsed.size() - 1);
        }
    }

    private DateTimeParseContext$Parsed currentParsed() {
        return (DateTimeParseContext$Parsed)this.parsed.get(this.parsed.size() - 1);
    }

    Long getParsed(TemporalField temporalField) {
        return (Long)this.currentParsed().fieldValues.get(temporalField);
    }

    int setParsedField(TemporalField temporalField, long l, int n, int n2) {
        Jdk8Methods.requireNonNull(temporalField, "field");
        Long l2 = this.currentParsed().fieldValues.put(temporalField, l);
        return l2 != null && l2 != l ? ~n : n2;
    }

    void setParsed(Chronology chronology) {
        Jdk8Methods.requireNonNull(chronology, "chrono");
        DateTimeParseContext$Parsed dateTimeParseContext$Parsed = this.currentParsed();
        dateTimeParseContext$Parsed.chrono = chronology;
        if (dateTimeParseContext$Parsed.callbacks != null) {
            ArrayList arrayList = new ArrayList(dateTimeParseContext$Parsed.callbacks);
            dateTimeParseContext$Parsed.callbacks.clear();
            for (Object[] objectArray : arrayList) {
                DateTimeFormatterBuilder$ReducedPrinterParser dateTimeFormatterBuilder$ReducedPrinterParser = (DateTimeFormatterBuilder$ReducedPrinterParser)objectArray[0];
                dateTimeFormatterBuilder$ReducedPrinterParser.setValue(this, (Long)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3]);
            }
        }
    }

    void addChronologyChangedParser(DateTimeFormatterBuilder$ReducedPrinterParser dateTimeFormatterBuilder$ReducedPrinterParser, long l, int n, int n2) {
        DateTimeParseContext$Parsed dateTimeParseContext$Parsed = this.currentParsed();
        if (dateTimeParseContext$Parsed.callbacks == null) {
            dateTimeParseContext$Parsed.callbacks = new ArrayList(2);
        }
        dateTimeParseContext$Parsed.callbacks.add(new Object[]{dateTimeFormatterBuilder$ReducedPrinterParser, l, n, n2});
    }

    void setParsed(ZoneId zoneId) {
        Jdk8Methods.requireNonNull(zoneId, "zone");
        this.currentParsed().zone = zoneId;
    }

    void setParsedLeapSecond() {
        this.currentParsed().leapSecond = true;
    }

    DateTimeParseContext$Parsed toParsed() {
        return this.currentParsed();
    }

    public String toString() {
        return this.currentParsed().toString();
    }

    void setLocale(Locale locale) {
        Jdk8Methods.requireNonNull(locale, "locale");
        this.locale = locale;
    }

    static /* synthetic */ ZoneId access$100(DateTimeParseContext dateTimeParseContext) {
        return dateTimeParseContext.overrideZone;
    }
}

