/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.temporal;

import oz.threeten.bp.Duration;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.IsoFields;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalUnit;

enum IsoFields$Unit implements TemporalUnit
{
    WEEK_BASED_YEARS("WeekBasedYears", Duration.ofSeconds(31556952L)),
    QUARTER_YEARS("QuarterYears", Duration.ofSeconds(7889238L));

    private final String name;
    private final Duration duration;

    /*
     * WARNING - void declaration
     */
    private IsoFields$Unit() {
        void var4_1;
        void var3_2;
        this.name = var3_2;
        this.duration = var4_1;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public boolean isDurationEstimated() {
        return true;
    }

    public boolean isDateBased() {
        return true;
    }

    public boolean isTimeBased() {
        return false;
    }

    public boolean isSupportedBy(Temporal temporal) {
        return temporal.isSupported(ChronoField.EPOCH_DAY);
    }

    public Temporal addTo(Temporal temporal, long l) {
        switch (this) {
            case WEEK_BASED_YEARS: {
                long l2 = Jdk8Methods.safeAdd((long)temporal.get(IsoFields.WEEK_BASED_YEAR), l);
                return temporal.with(IsoFields.WEEK_BASED_YEAR, l2);
            }
            case QUARTER_YEARS: {
                return temporal.plus(l / 256L, ChronoUnit.YEARS).plus(l % 256L * 3L, ChronoUnit.MONTHS);
            }
        }
        throw new IllegalStateException("Unreachable");
    }

    public long between(Temporal temporal, Temporal temporal2) {
        switch (this) {
            case WEEK_BASED_YEARS: {
                return Jdk8Methods.safeSubtract(temporal2.getLong(IsoFields.WEEK_BASED_YEAR), temporal.getLong(IsoFields.WEEK_BASED_YEAR));
            }
            case QUARTER_YEARS: {
                return temporal.until(temporal2, ChronoUnit.MONTHS) / 3L;
            }
        }
        throw new IllegalStateException("Unreachable");
    }

    public String toString() {
        return this.name;
    }
}

