/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.temporal;

import java.util.Locale;
import java.util.Map;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.Year;
import oz.threeten.bp.chrono.ChronoLocalDate;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.format.ResolverStyle;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.IsoFields;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.ValueRange;
import oz.threeten.bp.temporal.WeekFields;

class WeekFields$ComputedDayOfField
implements TemporalField {
    private final String name;
    private final WeekFields weekDef;
    private final TemporalUnit baseUnit;
    private final TemporalUnit rangeUnit;
    private final ValueRange range;
    private static final ValueRange DAY_OF_WEEK_RANGE = ValueRange.of(1L, 7L);
    private static final ValueRange WEEK_OF_MONTH_RANGE = ValueRange.of(0L, 1L, 4L, 6L);
    private static final ValueRange WEEK_OF_YEAR_RANGE = ValueRange.of(0L, 1L, 52L, 54L);
    private static final ValueRange WEEK_OF_WEEK_BASED_YEAR_RANGE = ValueRange.of(1L, 52L, 53L);
    private static final ValueRange WEEK_BASED_YEAR_RANGE = ChronoField.YEAR.range();

    static WeekFields$ComputedDayOfField ofDayOfWeekField(WeekFields weekFields) {
        return new WeekFields$ComputedDayOfField("DayOfWeek", weekFields, ChronoUnit.DAYS, ChronoUnit.WEEKS, DAY_OF_WEEK_RANGE);
    }

    static WeekFields$ComputedDayOfField ofWeekOfMonthField(WeekFields weekFields) {
        return new WeekFields$ComputedDayOfField("WeekOfMonth", weekFields, ChronoUnit.WEEKS, ChronoUnit.MONTHS, WEEK_OF_MONTH_RANGE);
    }

    static WeekFields$ComputedDayOfField ofWeekOfYearField(WeekFields weekFields) {
        return new WeekFields$ComputedDayOfField("WeekOfYear", weekFields, ChronoUnit.WEEKS, ChronoUnit.YEARS, WEEK_OF_YEAR_RANGE);
    }

    static WeekFields$ComputedDayOfField ofWeekOfWeekBasedYearField(WeekFields weekFields) {
        return new WeekFields$ComputedDayOfField("WeekOfWeekBasedYear", weekFields, ChronoUnit.WEEKS, IsoFields.WEEK_BASED_YEARS, WEEK_OF_WEEK_BASED_YEAR_RANGE);
    }

    static WeekFields$ComputedDayOfField ofWeekBasedYearField(WeekFields weekFields) {
        return new WeekFields$ComputedDayOfField("WeekBasedYear", weekFields, IsoFields.WEEK_BASED_YEARS, ChronoUnit.FOREVER, WEEK_BASED_YEAR_RANGE);
    }

    private WeekFields$ComputedDayOfField(String string, WeekFields weekFields, TemporalUnit temporalUnit, TemporalUnit temporalUnit2, ValueRange valueRange) {
        this.name = string;
        this.weekDef = weekFields;
        this.baseUnit = temporalUnit;
        this.rangeUnit = temporalUnit2;
        this.range = valueRange;
    }

    public long getFrom(TemporalAccessor temporalAccessor) {
        int n = this.weekDef.getFirstDayOfWeek().getValue();
        int n2 = temporalAccessor.get(ChronoField.DAY_OF_WEEK);
        int n3 = Jdk8Methods.floorMod(n2 - n, 7) + 1;
        if (this.rangeUnit == ChronoUnit.WEEKS) {
            return n3;
        }
        if (this.rangeUnit == ChronoUnit.MONTHS) {
            int n4 = temporalAccessor.get(ChronoField.DAY_OF_MONTH);
            int n5 = this.startOfWeekOffset(n4, n3);
            return this.computeWeek(n5, n4);
        }
        if (this.rangeUnit == ChronoUnit.YEARS) {
            int n6 = temporalAccessor.get(ChronoField.DAY_OF_YEAR);
            int n7 = this.startOfWeekOffset(n6, n3);
            return this.computeWeek(n7, n6);
        }
        if (this.rangeUnit == IsoFields.WEEK_BASED_YEARS) {
            return this.localizedWOWBY(temporalAccessor);
        }
        if (this.rangeUnit == ChronoUnit.FOREVER) {
            return this.localizedWBY(temporalAccessor);
        }
        throw new IllegalStateException("unreachable");
    }

    private int localizedDayOfWeek(TemporalAccessor temporalAccessor, int n) {
        int n2 = temporalAccessor.get(ChronoField.DAY_OF_WEEK);
        return Jdk8Methods.floorMod(n2 - n, 7) + 1;
    }

    private long localizedWeekOfMonth(TemporalAccessor temporalAccessor, int n) {
        int n2 = temporalAccessor.get(ChronoField.DAY_OF_MONTH);
        int n3 = this.startOfWeekOffset(n2, n);
        return this.computeWeek(n3, n2);
    }

    private long localizedWeekOfYear(TemporalAccessor temporalAccessor, int n) {
        int n2 = temporalAccessor.get(ChronoField.DAY_OF_YEAR);
        int n3 = this.startOfWeekOffset(n2, n);
        return this.computeWeek(n3, n2);
    }

    private int localizedWOWBY(TemporalAccessor temporalAccessor) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.weekDef.getFirstDayOfWeek().getValue();
        int n6 = temporalAccessor.get(ChronoField.DAY_OF_WEEK);
        int n7 = Jdk8Methods.floorMod(n6 - n5, 7) + 1;
        long l = this.localizedWeekOfYear(temporalAccessor, n7);
        if (l == 0L) {
            ChronoLocalDate chronoLocalDate = Chronology.from(temporalAccessor).date(temporalAccessor).minus(1L, ChronoUnit.WEEKS);
            return (int)this.localizedWeekOfYear(chronoLocalDate, n7) + 1;
        }
        if (l >= 53L && l >= (long)(n4 = this.computeWeek(n3 = this.startOfWeekOffset(temporalAccessor.get(ChronoField.DAY_OF_YEAR), n7), (n2 = Year.isLeap(n = temporalAccessor.get(ChronoField.YEAR)) ? 366 : 365) + this.weekDef.getMinimalDaysInFirstWeek()))) {
            return (int)(l - (long)(n4 - 1));
        }
        return (int)l;
    }

    private int localizedWBY(TemporalAccessor temporalAccessor) {
        int n;
        int n2 = this.weekDef.getFirstDayOfWeek().getValue();
        int n3 = temporalAccessor.get(ChronoField.DAY_OF_WEEK);
        int n4 = Jdk8Methods.floorMod(n3 - n2, 7) + 1;
        int n5 = temporalAccessor.get(ChronoField.YEAR);
        long l = this.localizedWeekOfYear(temporalAccessor, n4);
        if (l == 0L) {
            return n5 - 1;
        }
        if (l < 53L) {
            return n5;
        }
        int n6 = this.startOfWeekOffset(temporalAccessor.get(ChronoField.DAY_OF_YEAR), n4);
        int n7 = this.computeWeek(n6, (n = Year.isLeap(n5) ? 366 : 365) + this.weekDef.getMinimalDaysInFirstWeek());
        if (l >= (long)n7) {
            return n5 + 1;
        }
        return n5;
    }

    private int startOfWeekOffset(int n, int n2) {
        int n3 = Jdk8Methods.floorMod(n - n2, 7);
        int n4 = -n3;
        if (n3 + 1 > this.weekDef.getMinimalDaysInFirstWeek()) {
            n4 = 7 - n3;
        }
        return n4;
    }

    private int computeWeek(int n, int n2) {
        return (7 + n + (n2 - 1)) / 7;
    }

    public Temporal adjustInto(Temporal temporal, long l) {
        int n;
        int n2 = this.range.checkValidIntValue(l, this);
        if (n2 == (n = temporal.get(this))) {
            return temporal;
        }
        if (this.rangeUnit == ChronoUnit.FOREVER) {
            int n3 = temporal.get(WeekFields.access$000(this.weekDef));
            long l2 = (long)((double)(l - (long)n) * 52.1775);
            Temporal temporal2 = temporal.plus(l2, ChronoUnit.WEEKS);
            if (temporal2.get(this) > n2) {
                int n4 = temporal2.get(WeekFields.access$000(this.weekDef));
                temporal2 = temporal2.minus(n4, ChronoUnit.WEEKS);
            } else {
                int n5;
                if (temporal2.get(this) < n2) {
                    temporal2 = temporal2.plus(2L, ChronoUnit.WEEKS);
                }
                if ((temporal2 = temporal2.plus(n3 - (n5 = temporal2.get(WeekFields.access$000(this.weekDef))), ChronoUnit.WEEKS)).get(this) > n2) {
                    temporal2 = temporal2.minus(1L, ChronoUnit.WEEKS);
                }
            }
            return temporal2;
        }
        int n6 = n2 - n;
        return temporal.plus(n6, this.baseUnit);
    }

    public TemporalAccessor resolve(Map map, TemporalAccessor temporalAccessor, ResolverStyle resolverStyle) {
        int n = this.weekDef.getFirstDayOfWeek().getValue();
        if (this.rangeUnit == ChronoUnit.WEEKS) {
            long l = (Long)map.remove(this);
            int n2 = this.range.checkValidIntValue(l, this);
            int n3 = Jdk8Methods.floorMod(n - 1 + (n2 - 1), 7) + 1;
            map.put(ChronoField.DAY_OF_WEEK, Long.valueOf(n3));
            return null;
        }
        if (!map.containsKey(ChronoField.DAY_OF_WEEK)) {
            return null;
        }
        if (this.rangeUnit == ChronoUnit.FOREVER) {
            long l;
            ChronoLocalDate chronoLocalDate;
            if (!map.containsKey(WeekFields.access$000(this.weekDef))) {
                return null;
            }
            Chronology chronology = Chronology.from(temporalAccessor);
            int n4 = ChronoField.DAY_OF_WEEK.checkValidIntValue((Long)map.get(ChronoField.DAY_OF_WEEK));
            int n5 = Jdk8Methods.floorMod(n4 - n, 7) + 1;
            int n6 = this.range().checkValidIntValue((Long)map.get(this), this);
            if (resolverStyle == ResolverStyle.LENIENT) {
                chronoLocalDate = chronology.date(n6, 1, this.weekDef.getMinimalDaysInFirstWeek());
                long l2 = (Long)map.get(WeekFields.access$000(this.weekDef));
                int n7 = this.localizedDayOfWeek(chronoLocalDate, n);
                long l3 = l2 - this.localizedWeekOfYear(chronoLocalDate, n7);
                l = l3 * 7L + (long)(n5 - n7);
            } else {
                chronoLocalDate = chronology.date(n6, 1, this.weekDef.getMinimalDaysInFirstWeek());
                long l4 = WeekFields.access$000(this.weekDef).range().checkValidIntValue((Long)map.get(WeekFields.access$000(this.weekDef)), WeekFields.access$000(this.weekDef));
                int n8 = this.localizedDayOfWeek(chronoLocalDate, n);
                long l5 = l4 - this.localizedWeekOfYear(chronoLocalDate, n8);
                l = l5 * 7L + (long)(n5 - n8);
            }
            chronoLocalDate = chronoLocalDate.plus(l, ChronoUnit.DAYS);
            if (resolverStyle == ResolverStyle.STRICT && chronoLocalDate.getLong(this) != ((Long)map.get(this)).longValue()) {
                throw new DateTimeException("Strict mode rejected date parsed to a different year");
            }
            map.remove(this);
            map.remove(WeekFields.access$000(this.weekDef));
            map.remove(ChronoField.DAY_OF_WEEK);
            return chronoLocalDate;
        }
        if (!map.containsKey(ChronoField.YEAR)) {
            return null;
        }
        int n9 = ChronoField.DAY_OF_WEEK.checkValidIntValue((Long)map.get(ChronoField.DAY_OF_WEEK));
        int n10 = Jdk8Methods.floorMod(n9 - n, 7) + 1;
        int n11 = ChronoField.YEAR.checkValidIntValue((Long)map.get(ChronoField.YEAR));
        Chronology chronology = Chronology.from(temporalAccessor);
        if (this.rangeUnit == ChronoUnit.MONTHS) {
            long l;
            ChronoLocalDate chronoLocalDate;
            if (!map.containsKey(ChronoField.MONTH_OF_YEAR)) {
                return null;
            }
            long l6 = (Long)map.remove(this);
            if (resolverStyle == ResolverStyle.LENIENT) {
                long l7 = (Long)map.get(ChronoField.MONTH_OF_YEAR);
                chronoLocalDate = chronology.date(n11, 1, 1);
                chronoLocalDate = chronoLocalDate.plus(l7 - 1L, ChronoUnit.MONTHS);
                int n12 = this.localizedDayOfWeek(chronoLocalDate, n);
                long l8 = l6 - this.localizedWeekOfMonth(chronoLocalDate, n12);
                l = l8 * 7L + (long)(n10 - n12);
            } else {
                int n13 = ChronoField.MONTH_OF_YEAR.checkValidIntValue((Long)map.get(ChronoField.MONTH_OF_YEAR));
                chronoLocalDate = chronology.date(n11, n13, 8);
                int n14 = this.localizedDayOfWeek(chronoLocalDate, n);
                int n15 = this.range.checkValidIntValue(l6, this);
                long l9 = (long)n15 - this.localizedWeekOfMonth(chronoLocalDate, n14);
                l = l9 * 7L + (long)(n10 - n14);
            }
            chronoLocalDate = chronoLocalDate.plus(l, ChronoUnit.DAYS);
            if (resolverStyle == ResolverStyle.STRICT && chronoLocalDate.getLong(ChronoField.MONTH_OF_YEAR) != ((Long)map.get(ChronoField.MONTH_OF_YEAR)).longValue()) {
                throw new DateTimeException("Strict mode rejected date parsed to a different month");
            }
            map.remove(this);
            map.remove(ChronoField.YEAR);
            map.remove(ChronoField.MONTH_OF_YEAR);
            map.remove(ChronoField.DAY_OF_WEEK);
            return chronoLocalDate;
        }
        if (this.rangeUnit == ChronoUnit.YEARS) {
            long l;
            long l10 = (Long)map.remove(this);
            ChronoLocalDate chronoLocalDate = chronology.date(n11, 1, 1);
            if (resolverStyle == ResolverStyle.LENIENT) {
                int n16 = this.localizedDayOfWeek(chronoLocalDate, n);
                long l11 = l10 - this.localizedWeekOfYear(chronoLocalDate, n16);
                l = l11 * 7L + (long)(n10 - n16);
            } else {
                int n17 = this.localizedDayOfWeek(chronoLocalDate, n);
                int n18 = this.range.checkValidIntValue(l10, this);
                long l12 = (long)n18 - this.localizedWeekOfYear(chronoLocalDate, n17);
                l = l12 * 7L + (long)(n10 - n17);
            }
            chronoLocalDate = chronoLocalDate.plus(l, ChronoUnit.DAYS);
            if (resolverStyle == ResolverStyle.STRICT && chronoLocalDate.getLong(ChronoField.YEAR) != ((Long)map.get(ChronoField.YEAR)).longValue()) {
                throw new DateTimeException("Strict mode rejected date parsed to a different year");
            }
            map.remove(this);
            map.remove(ChronoField.YEAR);
            map.remove(ChronoField.DAY_OF_WEEK);
            return chronoLocalDate;
        }
        throw new IllegalStateException("unreachable");
    }

    public TemporalUnit getBaseUnit() {
        return this.baseUnit;
    }

    public TemporalUnit getRangeUnit() {
        return this.rangeUnit;
    }

    public ValueRange range() {
        return this.range;
    }

    public boolean isDateBased() {
        return true;
    }

    public boolean isTimeBased() {
        return false;
    }

    public boolean isSupportedBy(TemporalAccessor temporalAccessor) {
        if (temporalAccessor.isSupported(ChronoField.DAY_OF_WEEK)) {
            if (this.rangeUnit == ChronoUnit.WEEKS) {
                return true;
            }
            if (this.rangeUnit == ChronoUnit.MONTHS) {
                return temporalAccessor.isSupported(ChronoField.DAY_OF_MONTH);
            }
            if (this.rangeUnit == ChronoUnit.YEARS) {
                return temporalAccessor.isSupported(ChronoField.DAY_OF_YEAR);
            }
            if (this.rangeUnit == IsoFields.WEEK_BASED_YEARS) {
                return temporalAccessor.isSupported(ChronoField.EPOCH_DAY);
            }
            if (this.rangeUnit == ChronoUnit.FOREVER) {
                return temporalAccessor.isSupported(ChronoField.EPOCH_DAY);
            }
        }
        return false;
    }

    public ValueRange rangeRefinedBy(TemporalAccessor temporalAccessor) {
        if (this.rangeUnit == ChronoUnit.WEEKS) {
            return this.range;
        }
        ChronoField chronoField = null;
        if (this.rangeUnit == ChronoUnit.MONTHS) {
            chronoField = ChronoField.DAY_OF_MONTH;
        } else if (this.rangeUnit == ChronoUnit.YEARS) {
            chronoField = ChronoField.DAY_OF_YEAR;
        } else {
            if (this.rangeUnit == IsoFields.WEEK_BASED_YEARS) {
                return this.rangeWOWBY(temporalAccessor);
            }
            if (this.rangeUnit == ChronoUnit.FOREVER) {
                return temporalAccessor.range(ChronoField.YEAR);
            }
            throw new IllegalStateException("unreachable");
        }
        int n = this.weekDef.getFirstDayOfWeek().getValue();
        int n2 = temporalAccessor.get(ChronoField.DAY_OF_WEEK);
        int n3 = Jdk8Methods.floorMod(n2 - n, 7) + 1;
        int n4 = this.startOfWeekOffset(temporalAccessor.get(chronoField), n3);
        ValueRange valueRange = temporalAccessor.range(chronoField);
        return ValueRange.of(this.computeWeek(n4, (int)valueRange.getMinimum()), this.computeWeek(n4, (int)valueRange.getMaximum()));
    }

    private ValueRange rangeWOWBY(TemporalAccessor temporalAccessor) {
        int n;
        int n2;
        int n3 = this.weekDef.getFirstDayOfWeek().getValue();
        int n4 = temporalAccessor.get(ChronoField.DAY_OF_WEEK);
        int n5 = Jdk8Methods.floorMod(n4 - n3, 7) + 1;
        long l = this.localizedWeekOfYear(temporalAccessor, n5);
        if (l == 0L) {
            return this.rangeWOWBY(Chronology.from(temporalAccessor).date(temporalAccessor).minus(2L, ChronoUnit.WEEKS));
        }
        int n6 = this.startOfWeekOffset(temporalAccessor.get(ChronoField.DAY_OF_YEAR), n5);
        int n7 = this.computeWeek(n6, (n2 = Year.isLeap(n = temporalAccessor.get(ChronoField.YEAR)) ? 366 : 365) + this.weekDef.getMinimalDaysInFirstWeek());
        if (l >= (long)n7) {
            return this.rangeWOWBY(Chronology.from(temporalAccessor).date(temporalAccessor).plus(2L, ChronoUnit.WEEKS));
        }
        return ValueRange.of(1L, n7 - 1);
    }

    public String getDisplayName(Locale locale) {
        Jdk8Methods.requireNonNull(locale, "locale");
        if (this.rangeUnit == ChronoUnit.YEARS) {
            return "Week";
        }
        return this.toString();
    }

    public String toString() {
        return this.name + "[" + this.weekDef.toString() + "]";
    }
}

