/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.temporal;

import java.io.InvalidObjectException;
import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import oz.threeten.bp.DayOfWeek;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.WeekFields$ComputedDayOfField;

public final class WeekFields
implements Serializable {
    private static final ConcurrentMap CACHE = new ConcurrentHashMap(4, 0.75f, 2);
    public static final WeekFields ISO = new WeekFields(DayOfWeek.MONDAY, 4);
    public static final WeekFields SUNDAY_START = WeekFields.of(DayOfWeek.SUNDAY, 1);
    private static final long serialVersionUID = -1177360819670808121L;
    private final DayOfWeek firstDayOfWeek;
    private final int minimalDays;
    private final transient TemporalField dayOfWeek = WeekFields$ComputedDayOfField.ofDayOfWeekField(this);
    private final transient TemporalField weekOfMonth = WeekFields$ComputedDayOfField.ofWeekOfMonthField(this);
    private final transient TemporalField weekOfYear = WeekFields$ComputedDayOfField.ofWeekOfYearField(this);
    private final transient TemporalField weekOfWeekBasedYear = WeekFields$ComputedDayOfField.ofWeekOfWeekBasedYearField(this);
    private final transient TemporalField weekBasedYear = WeekFields$ComputedDayOfField.ofWeekBasedYearField(this);

    public static WeekFields of(Locale locale) {
        Jdk8Methods.requireNonNull(locale, "locale");
        locale = new Locale(locale.getLanguage(), locale.getCountry());
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        int n = gregorianCalendar.getFirstDayOfWeek();
        DayOfWeek dayOfWeek = DayOfWeek.SUNDAY.plus(n - 1);
        int n2 = gregorianCalendar.getMinimalDaysInFirstWeek();
        return WeekFields.of(dayOfWeek, n2);
    }

    public static WeekFields of(DayOfWeek dayOfWeek, int n) {
        String string = dayOfWeek.toString() + n;
        WeekFields weekFields = (WeekFields)CACHE.get(string);
        if (weekFields == null) {
            weekFields = new WeekFields(dayOfWeek, n);
            CACHE.putIfAbsent(string, weekFields);
            weekFields = (WeekFields)CACHE.get(string);
        }
        return weekFields;
    }

    private WeekFields(DayOfWeek dayOfWeek, int n) {
        Jdk8Methods.requireNonNull(dayOfWeek, "firstDayOfWeek");
        if (n < 1 || n > 7) {
            throw new IllegalArgumentException("Minimal number of days is invalid");
        }
        this.firstDayOfWeek = dayOfWeek;
        this.minimalDays = n;
    }

    private Object readResolve() {
        try {
            return WeekFields.of(this.firstDayOfWeek, this.minimalDays);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidObjectException("Invalid WeekFields" + illegalArgumentException.getMessage());
        }
    }

    public DayOfWeek getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDays;
    }

    public TemporalField dayOfWeek() {
        return this.dayOfWeek;
    }

    public TemporalField weekOfMonth() {
        return this.weekOfMonth;
    }

    public TemporalField weekOfYear() {
        return this.weekOfYear;
    }

    public TemporalField weekOfWeekBasedYear() {
        return this.weekOfWeekBasedYear;
    }

    public TemporalField weekBasedYear() {
        return this.weekBasedYear;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WeekFields) {
            return this.hashCode() == object.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return this.firstDayOfWeek.ordinal() * 7 + this.minimalDays;
    }

    public String toString() {
        return "WeekFields[" + this.firstDayOfWeek + ',' + this.minimalDays + ']';
    }

    static /* synthetic */ TemporalField access$000(WeekFields weekFields) {
        return weekFields.weekOfWeekBasedYear;
    }
}

