/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.zone;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import oz.threeten.bp.Duration;
import oz.threeten.bp.Instant;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalDateTime;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.zone.Ser;
import oz.threeten.bp.zone.ZoneOffsetTransition;
import oz.threeten.bp.zone.ZoneOffsetTransitionRule;
import oz.threeten.bp.zone.ZoneRules;
import oz.threeten.bp.zone.ZoneRules$Fixed;

final class StandardZoneRules
extends ZoneRules
implements Serializable {
    private static final long serialVersionUID = 3044319355680032515L;
    private static final int LAST_CACHED_YEAR = 2100;
    private final long[] standardTransitions;
    private final ZoneOffset[] standardOffsets;
    private final long[] savingsInstantTransitions;
    private final LocalDateTime[] savingsLocalTransitions;
    private final ZoneOffset[] wallOffsets;
    private final ZoneOffsetTransitionRule[] lastRules;
    private final ConcurrentMap lastRulesCache = new ConcurrentHashMap();

    StandardZoneRules(ZoneOffset zoneOffset, ZoneOffset zoneOffset2, List list, List list2, List list3) {
        this.standardTransitions = new long[list.size()];
        this.standardOffsets = new ZoneOffset[list.size() + 1];
        this.standardOffsets[0] = zoneOffset;
        for (int j = 0; j < list.size(); ++j) {
            this.standardTransitions[j] = ((ZoneOffsetTransition)list.get(j)).toEpochSecond();
            this.standardOffsets[j + 1] = ((ZoneOffsetTransition)list.get(j)).getOffsetAfter();
        }
        ArrayList<LocalDateTime> arrayList = new ArrayList<LocalDateTime>();
        ArrayList<ZoneOffset> arrayList2 = new ArrayList<ZoneOffset>();
        arrayList2.add(zoneOffset2);
        for (ZoneOffsetTransition zoneOffsetTransition : list2) {
            if (zoneOffsetTransition.isGap()) {
                arrayList.add(zoneOffsetTransition.getDateTimeBefore());
                arrayList.add(zoneOffsetTransition.getDateTimeAfter());
            } else {
                arrayList.add(zoneOffsetTransition.getDateTimeAfter());
                arrayList.add(zoneOffsetTransition.getDateTimeBefore());
            }
            arrayList2.add(zoneOffsetTransition.getOffsetAfter());
        }
        this.savingsLocalTransitions = arrayList.toArray(new LocalDateTime[arrayList.size()]);
        this.wallOffsets = arrayList2.toArray(new ZoneOffset[arrayList2.size()]);
        this.savingsInstantTransitions = new long[list2.size()];
        for (int j = 0; j < list2.size(); ++j) {
            this.savingsInstantTransitions[j] = ((ZoneOffsetTransition)list2.get(j)).getInstant().getEpochSecond();
        }
        if (list3.size() > 15) {
            throw new IllegalArgumentException("Too many transition rules");
        }
        this.lastRules = list3.toArray(new ZoneOffsetTransitionRule[list3.size()]);
    }

    private StandardZoneRules(long[] lArray, ZoneOffset[] zoneOffsetArray, long[] lArray2, ZoneOffset[] zoneOffsetArray2, ZoneOffsetTransitionRule[] zoneOffsetTransitionRuleArray) {
        this.standardTransitions = lArray;
        this.standardOffsets = zoneOffsetArray;
        this.savingsInstantTransitions = lArray2;
        this.wallOffsets = zoneOffsetArray2;
        this.lastRules = zoneOffsetTransitionRuleArray;
        ArrayList<LocalDateTime> arrayList = new ArrayList<LocalDateTime>();
        for (int j = 0; j < lArray2.length; ++j) {
            ZoneOffset zoneOffset = zoneOffsetArray2[j];
            ZoneOffset zoneOffset2 = zoneOffsetArray2[j + 1];
            ZoneOffsetTransition zoneOffsetTransition = new ZoneOffsetTransition(lArray2[j], zoneOffset, zoneOffset2);
            if (zoneOffsetTransition.isGap()) {
                arrayList.add(zoneOffsetTransition.getDateTimeBefore());
                arrayList.add(zoneOffsetTransition.getDateTimeAfter());
                continue;
            }
            arrayList.add(zoneOffsetTransition.getDateTimeAfter());
            arrayList.add(zoneOffsetTransition.getDateTimeBefore());
        }
        this.savingsLocalTransitions = arrayList.toArray(new LocalDateTime[arrayList.size()]);
    }

    private Object writeReplace() {
        return new Ser(1, this);
    }

    void writeExternal(DataOutput dataOutput) {
        dataOutput.writeInt(this.standardTransitions.length);
        for (long l : this.standardTransitions) {
            Ser.writeEpochSec(l, dataOutput);
        }
        for (ZoneOffset zoneOffset : this.standardOffsets) {
            Ser.writeOffset(zoneOffset, dataOutput);
        }
        dataOutput.writeInt(this.savingsInstantTransitions.length);
        for (long l : this.savingsInstantTransitions) {
            Ser.writeEpochSec(l, dataOutput);
        }
        for (ZoneOffset zoneOffset : this.wallOffsets) {
            Ser.writeOffset(zoneOffset, dataOutput);
        }
        dataOutput.writeByte(this.lastRules.length);
        for (ZoneOffsetTransitionRule zoneOffsetTransitionRule : this.lastRules) {
            zoneOffsetTransitionRule.writeExternal(dataOutput);
        }
    }

    static StandardZoneRules readExternal(DataInput dataInput) {
        int n;
        int n2;
        int n3 = dataInput.readInt();
        long[] lArray = new long[n3];
        for (int j = 0; j < n3; ++j) {
            lArray[j] = Ser.readEpochSec(dataInput);
        }
        ZoneOffset[] zoneOffsetArray = new ZoneOffset[n3 + 1];
        for (n2 = 0; n2 < zoneOffsetArray.length; ++n2) {
            zoneOffsetArray[n2] = Ser.readOffset(dataInput);
        }
        n2 = dataInput.readInt();
        long[] lArray2 = new long[n2];
        for (int j = 0; j < n2; ++j) {
            lArray2[j] = Ser.readEpochSec(dataInput);
        }
        ZoneOffset[] zoneOffsetArray2 = new ZoneOffset[n2 + 1];
        for (n = 0; n < zoneOffsetArray2.length; ++n) {
            zoneOffsetArray2[n] = Ser.readOffset(dataInput);
        }
        n = dataInput.readByte();
        ZoneOffsetTransitionRule[] zoneOffsetTransitionRuleArray = new ZoneOffsetTransitionRule[n];
        for (int j = 0; j < n; ++j) {
            zoneOffsetTransitionRuleArray[j] = ZoneOffsetTransitionRule.readExternal(dataInput);
        }
        return new StandardZoneRules(lArray, zoneOffsetArray, lArray2, zoneOffsetArray2, zoneOffsetTransitionRuleArray);
    }

    public boolean isFixedOffset() {
        return this.savingsInstantTransitions.length == 0 && this.lastRules.length == 0 && this.wallOffsets[0].equals(this.standardOffsets[0]);
    }

    public ZoneOffset getOffset(Instant instant) {
        long l = instant.getEpochSecond();
        if (this.lastRules.length > 0 && (this.savingsInstantTransitions.length == 0 || l > this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1])) {
            int n = this.findYear(l, this.wallOffsets[this.wallOffsets.length - 1]);
            ZoneOffsetTransition[] zoneOffsetTransitionArray = this.findTransitionArray(n);
            ZoneOffsetTransition zoneOffsetTransition = null;
            for (int j = 0; j < zoneOffsetTransitionArray.length; ++j) {
                zoneOffsetTransition = zoneOffsetTransitionArray[j];
                if (l >= zoneOffsetTransition.toEpochSecond()) continue;
                return zoneOffsetTransition.getOffsetBefore();
            }
            return zoneOffsetTransition.getOffsetAfter();
        }
        int n = Arrays.binarySearch(this.savingsInstantTransitions, l);
        if (n < 0) {
            n = -n - 2;
        }
        return this.wallOffsets[n + 1];
    }

    public ZoneOffset getOffset(LocalDateTime localDateTime) {
        Object object = this.getOffsetInfo(localDateTime);
        if (object instanceof ZoneOffsetTransition) {
            return ((ZoneOffsetTransition)object).getOffsetBefore();
        }
        return (ZoneOffset)object;
    }

    public List getValidOffsets(LocalDateTime localDateTime) {
        Object object = this.getOffsetInfo(localDateTime);
        if (object instanceof ZoneOffsetTransition) {
            return ((ZoneOffsetTransition)object).getValidOffsets();
        }
        return Collections.singletonList((ZoneOffset)object);
    }

    public ZoneOffsetTransition getTransition(LocalDateTime localDateTime) {
        Object object = this.getOffsetInfo(localDateTime);
        return object instanceof ZoneOffsetTransition ? (ZoneOffsetTransition)object : null;
    }

    private Object getOffsetInfo(LocalDateTime localDateTime) {
        if (this.lastRules.length > 0 && (this.savingsLocalTransitions.length == 0 || localDateTime.isAfter(this.savingsLocalTransitions[this.savingsLocalTransitions.length - 1]))) {
            ZoneOffsetTransition[] zoneOffsetTransitionArray = this.findTransitionArray(localDateTime.getYear());
            Object object = null;
            for (ZoneOffsetTransition zoneOffsetTransition : zoneOffsetTransitionArray) {
                object = this.findOffsetInfo(localDateTime, zoneOffsetTransition);
                if (!(object instanceof ZoneOffsetTransition) && !object.equals(zoneOffsetTransition.getOffsetBefore())) continue;
                return object;
            }
            return object;
        }
        int n = Arrays.binarySearch(this.savingsLocalTransitions, localDateTime);
        if (n == -1) {
            return this.wallOffsets[0];
        }
        if (n < 0) {
            n = -n - 2;
        } else if (n < this.savingsLocalTransitions.length - 1 && this.savingsLocalTransitions[n].equals(this.savingsLocalTransitions[n + 1])) {
            ++n;
        }
        if ((n & 1) == 0) {
            LocalDateTime localDateTime2 = this.savingsLocalTransitions[n];
            LocalDateTime localDateTime3 = this.savingsLocalTransitions[n + 1];
            ZoneOffset zoneOffset = this.wallOffsets[n / 2];
            ZoneOffset zoneOffset2 = this.wallOffsets[n / 2 + 1];
            if (zoneOffset2.getTotalSeconds() > zoneOffset.getTotalSeconds()) {
                return new ZoneOffsetTransition(localDateTime2, zoneOffset, zoneOffset2);
            }
            return new ZoneOffsetTransition(localDateTime3, zoneOffset, zoneOffset2);
        }
        return this.wallOffsets[n / 2 + 1];
    }

    private Object findOffsetInfo(LocalDateTime localDateTime, ZoneOffsetTransition zoneOffsetTransition) {
        LocalDateTime localDateTime2 = zoneOffsetTransition.getDateTimeBefore();
        if (zoneOffsetTransition.isGap()) {
            if (localDateTime.isBefore(localDateTime2)) {
                return zoneOffsetTransition.getOffsetBefore();
            }
            if (localDateTime.isBefore(zoneOffsetTransition.getDateTimeAfter())) {
                return zoneOffsetTransition;
            }
            return zoneOffsetTransition.getOffsetAfter();
        }
        if (!localDateTime.isBefore(localDateTime2)) {
            return zoneOffsetTransition.getOffsetAfter();
        }
        if (localDateTime.isBefore(zoneOffsetTransition.getDateTimeAfter())) {
            return zoneOffsetTransition.getOffsetBefore();
        }
        return zoneOffsetTransition;
    }

    public boolean isValidOffset(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        return this.getValidOffsets(localDateTime).contains(zoneOffset);
    }

    private ZoneOffsetTransition[] findTransitionArray(int n) {
        Integer n2 = n;
        ZoneOffsetTransition[] zoneOffsetTransitionArray = (ZoneOffsetTransition[])this.lastRulesCache.get(n2);
        if (zoneOffsetTransitionArray != null) {
            return zoneOffsetTransitionArray;
        }
        ZoneOffsetTransitionRule[] zoneOffsetTransitionRuleArray = this.lastRules;
        zoneOffsetTransitionArray = new ZoneOffsetTransition[zoneOffsetTransitionRuleArray.length];
        for (int j = 0; j < zoneOffsetTransitionRuleArray.length; ++j) {
            zoneOffsetTransitionArray[j] = zoneOffsetTransitionRuleArray[j].createTransition(n);
        }
        if (n < 2100) {
            this.lastRulesCache.putIfAbsent(n2, zoneOffsetTransitionArray);
        }
        return zoneOffsetTransitionArray;
    }

    public ZoneOffset getStandardOffset(Instant instant) {
        long l = instant.getEpochSecond();
        int n = Arrays.binarySearch(this.standardTransitions, l);
        if (n < 0) {
            n = -n - 2;
        }
        return this.standardOffsets[n + 1];
    }

    public Duration getDaylightSavings(Instant instant) {
        ZoneOffset zoneOffset = this.getStandardOffset(instant);
        ZoneOffset zoneOffset2 = this.getOffset(instant);
        return Duration.ofSeconds(zoneOffset2.getTotalSeconds() - zoneOffset.getTotalSeconds());
    }

    public boolean isDaylightSavings(Instant instant) {
        return !this.getStandardOffset(instant).equals(this.getOffset(instant));
    }

    public ZoneOffsetTransition nextTransition(Instant instant) {
        if (this.savingsInstantTransitions.length == 0) {
            return null;
        }
        long l = instant.getEpochSecond();
        if (l >= this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1]) {
            ZoneOffsetTransition[] zoneOffsetTransitionArray;
            if (this.lastRules.length == 0) {
                return null;
            }
            int n = this.findYear(l, this.wallOffsets[this.wallOffsets.length - 1]);
            for (ZoneOffsetTransition zoneOffsetTransition : zoneOffsetTransitionArray = this.findTransitionArray(n)) {
                if (l >= zoneOffsetTransition.toEpochSecond()) continue;
                return zoneOffsetTransition;
            }
            if (n < 999999999) {
                zoneOffsetTransitionArray = this.findTransitionArray(n + 1);
                return zoneOffsetTransitionArray[0];
            }
            return null;
        }
        int n = Arrays.binarySearch(this.savingsInstantTransitions, l);
        n = n < 0 ? -n - 1 : ++n;
        return new ZoneOffsetTransition(this.savingsInstantTransitions[n], this.wallOffsets[n], this.wallOffsets[n + 1]);
    }

    public ZoneOffsetTransition previousTransition(Instant instant) {
        int n;
        if (this.savingsInstantTransitions.length == 0) {
            return null;
        }
        long l = instant.getEpochSecond();
        if (instant.getNano() > 0 && l < Long.MAX_VALUE) {
            ++l;
        }
        long l2 = this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1];
        if (this.lastRules.length > 0 && l > l2) {
            int n2;
            ZoneOffset zoneOffset = this.wallOffsets[this.wallOffsets.length - 1];
            int n3 = this.findYear(l, zoneOffset);
            ZoneOffsetTransition[] zoneOffsetTransitionArray = this.findTransitionArray(n3);
            for (n2 = zoneOffsetTransitionArray.length - 1; n2 >= 0; --n2) {
                if (l <= zoneOffsetTransitionArray[n2].toEpochSecond()) continue;
                return zoneOffsetTransitionArray[n2];
            }
            n2 = this.findYear(l2, zoneOffset);
            if (--n3 > n2) {
                zoneOffsetTransitionArray = this.findTransitionArray(n3);
                return zoneOffsetTransitionArray[zoneOffsetTransitionArray.length - 1];
            }
        }
        if ((n = Arrays.binarySearch(this.savingsInstantTransitions, l)) < 0) {
            n = -n - 1;
        }
        if (n <= 0) {
            return null;
        }
        return new ZoneOffsetTransition(this.savingsInstantTransitions[n - 1], this.wallOffsets[n - 1], this.wallOffsets[n]);
    }

    private int findYear(long l, ZoneOffset zoneOffset) {
        long l2 = l + (long)zoneOffset.getTotalSeconds();
        long l3 = Jdk8Methods.floorDiv(l2, 86400L);
        return LocalDate.ofEpochDay(l3).getYear();
    }

    public List getTransitions() {
        ArrayList<ZoneOffsetTransition> arrayList = new ArrayList<ZoneOffsetTransition>();
        for (int j = 0; j < this.savingsInstantTransitions.length; ++j) {
            arrayList.add(new ZoneOffsetTransition(this.savingsInstantTransitions[j], this.wallOffsets[j], this.wallOffsets[j + 1]));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List getTransitionRules() {
        return Collections.unmodifiableList(Arrays.asList(this.lastRules));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof StandardZoneRules) {
            StandardZoneRules standardZoneRules = (StandardZoneRules)object;
            return Arrays.equals(this.standardTransitions, standardZoneRules.standardTransitions) && Arrays.equals(this.standardOffsets, standardZoneRules.standardOffsets) && Arrays.equals(this.savingsInstantTransitions, standardZoneRules.savingsInstantTransitions) && Arrays.equals(this.wallOffsets, standardZoneRules.wallOffsets) && Arrays.equals(this.lastRules, standardZoneRules.lastRules);
        }
        if (object instanceof ZoneRules$Fixed) {
            return this.isFixedOffset() && this.getOffset(Instant.EPOCH).equals(((ZoneRules$Fixed)object).getOffset(Instant.EPOCH));
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.standardTransitions) ^ Arrays.hashCode(this.standardOffsets) ^ Arrays.hashCode(this.savingsInstantTransitions) ^ Arrays.hashCode(this.wallOffsets) ^ Arrays.hashCode(this.lastRules);
    }

    public String toString() {
        return "StandardZoneRules[currentStandardOffset=" + this.standardOffsets[this.standardOffsets.length - 1] + "]";
    }
}

