/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.zone;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReferenceArray;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.zone.TzdbZoneRulesProvider$Version;
import oz.threeten.bp.zone.ZoneRules;
import oz.threeten.bp.zone.ZoneRulesException;
import oz.threeten.bp.zone.ZoneRulesProvider;

public final class TzdbZoneRulesProvider
extends ZoneRulesProvider {
    private List regionIds;
    private final ConcurrentNavigableMap versions = new ConcurrentSkipListMap();
    private Set loadedUrls = new CopyOnWriteArraySet();

    public TzdbZoneRulesProvider() {
        if (!this.load(ZoneRulesProvider.class.getClassLoader())) {
            throw new ZoneRulesException("No time-zone rules found for 'TZDB'");
        }
    }

    public TzdbZoneRulesProvider(URL uRL) {
        try {
            if (!this.load(uRL)) {
                throw new ZoneRulesException("No time-zone rules found: " + uRL);
            }
        }
        catch (Exception exception) {
            throw new ZoneRulesException("Unable to load TZDB time-zone rules: " + uRL, exception);
        }
    }

    public TzdbZoneRulesProvider(InputStream inputStream) {
        try {
            this.load(inputStream);
        }
        catch (Exception exception) {
            throw new ZoneRulesException("Unable to load TZDB time-zone rules", exception);
        }
    }

    protected Set provideZoneIds() {
        return new HashSet(this.regionIds);
    }

    protected ZoneRules provideRules(String string, boolean bl) {
        Jdk8Methods.requireNonNull(string, "zoneId");
        ZoneRules zoneRules = ((TzdbZoneRulesProvider$Version)this.versions.lastEntry().getValue()).getRules(string);
        if (zoneRules == null) {
            throw new ZoneRulesException("Unknown time-zone ID: " + string);
        }
        return zoneRules;
    }

    protected NavigableMap provideVersions(String string) {
        TreeMap<String, ZoneRules> treeMap = new TreeMap<String, ZoneRules>();
        for (TzdbZoneRulesProvider$Version tzdbZoneRulesProvider$Version : this.versions.values()) {
            ZoneRules zoneRules = tzdbZoneRulesProvider$Version.getRules(string);
            if (zoneRules == null) continue;
            treeMap.put(TzdbZoneRulesProvider$Version.access$000(tzdbZoneRulesProvider$Version), zoneRules);
        }
        return treeMap;
    }

    private boolean load(ClassLoader classLoader) {
        boolean bl = false;
        URL uRL = null;
        try {
            Enumeration<URL> enumeration = classLoader.getResources("org/threeten/bp/TZDB.dat");
            while (enumeration.hasMoreElements()) {
                uRL = enumeration.nextElement();
                bl |= this.load(uRL);
            }
        }
        catch (Exception exception) {
            throw new ZoneRulesException("Unable to load TZDB time-zone rules: " + uRL, exception);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean load(URL uRL) {
        boolean bl = false;
        if (this.loadedUrls.add(uRL.toExternalForm())) {
            InputStream inputStream = null;
            try {
                inputStream = uRL.openStream();
                bl |= this.load(inputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return bl;
    }

    private boolean load(InputStream inputStream) {
        boolean bl = false;
        Iterable iterable = this.loadData(inputStream);
        for (TzdbZoneRulesProvider$Version tzdbZoneRulesProvider$Version : iterable) {
            TzdbZoneRulesProvider$Version tzdbZoneRulesProvider$Version2 = this.versions.putIfAbsent(TzdbZoneRulesProvider$Version.access$000(tzdbZoneRulesProvider$Version), tzdbZoneRulesProvider$Version);
            if (tzdbZoneRulesProvider$Version2 != null && !TzdbZoneRulesProvider$Version.access$000(tzdbZoneRulesProvider$Version2).equals(TzdbZoneRulesProvider$Version.access$000(tzdbZoneRulesProvider$Version))) {
                throw new ZoneRulesException("Data already loaded for TZDB time-zone rules version: " + TzdbZoneRulesProvider$Version.access$000(tzdbZoneRulesProvider$Version));
            }
            bl = true;
        }
        return bl;
    }

    private Iterable loadData(InputStream inputStream) {
        Object object;
        int n;
        int n2;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (dataInputStream.readByte() != 1) {
            throw new StreamCorruptedException("File format not recognised");
        }
        String string = dataInputStream.readUTF();
        if (!"TZDB".equals(string)) {
            throw new StreamCorruptedException("File format not recognised");
        }
        int n3 = dataInputStream.readShort();
        String[] stringArray = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = dataInputStream.readUTF();
        }
        n2 = dataInputStream.readShort();
        String[] stringArray2 = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray2[n] = dataInputStream.readUTF();
        }
        this.regionIds = Arrays.asList(stringArray2);
        n = dataInputStream.readShort();
        Object[] objectArray = new Object[n];
        for (int j = 0; j < n; ++j) {
            object = new byte[dataInputStream.readShort()];
            dataInputStream.readFully((byte[])object);
            objectArray[j] = object;
        }
        AtomicReferenceArray<Object> atomicReferenceArray = new AtomicReferenceArray<Object>(objectArray);
        object = new HashSet(n3);
        for (int j = 0; j < n3; ++j) {
            int n4 = dataInputStream.readShort();
            String[] stringArray3 = new String[n4];
            short[] sArray = new short[n4];
            for (int k = 0; k < n4; ++k) {
                stringArray3[k] = stringArray2[dataInputStream.readShort()];
                sArray[k] = dataInputStream.readShort();
            }
            object.add(new TzdbZoneRulesProvider$Version(stringArray[j], stringArray3, sArray, atomicReferenceArray));
        }
        return object;
    }

    public String toString() {
        return "TZDB";
    }
}

