/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.zone;

import java.util.Collections;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.zone.ZoneRules;
import oz.threeten.bp.zone.ZoneRulesException;
import oz.threeten.bp.zone.ZoneRulesInitializer;

public abstract class ZoneRulesProvider {
    private static final CopyOnWriteArrayList PROVIDERS = new CopyOnWriteArrayList();
    private static final ConcurrentMap ZONES = new ConcurrentHashMap(512, 0.75f, 2);

    public static Set getAvailableZoneIds() {
        return Collections.unmodifiableSet(ZONES.keySet());
    }

    public static ZoneRules getRules(String string, boolean bl) {
        Jdk8Methods.requireNonNull(string, "zoneId");
        return ZoneRulesProvider.getProvider(string).provideRules(string, bl);
    }

    public static NavigableMap getVersions(String string) {
        Jdk8Methods.requireNonNull(string, "zoneId");
        return ZoneRulesProvider.getProvider(string).provideVersions(string);
    }

    private static ZoneRulesProvider getProvider(String string) {
        ZoneRulesProvider zoneRulesProvider = (ZoneRulesProvider)ZONES.get(string);
        if (zoneRulesProvider == null) {
            if (ZONES.isEmpty()) {
                throw new ZoneRulesException("No time-zone data files registered");
            }
            throw new ZoneRulesException("Unknown time-zone ID: " + string);
        }
        return zoneRulesProvider;
    }

    public static void registerProvider(ZoneRulesProvider zoneRulesProvider) {
        Jdk8Methods.requireNonNull(zoneRulesProvider, "provider");
        ZoneRulesProvider.registerProvider0(zoneRulesProvider);
        PROVIDERS.add(zoneRulesProvider);
    }

    private static void registerProvider0(ZoneRulesProvider zoneRulesProvider) {
        for (String string : zoneRulesProvider.provideZoneIds()) {
            Jdk8Methods.requireNonNull(string, "zoneId");
            ZoneRulesProvider zoneRulesProvider2 = ZONES.putIfAbsent(string, zoneRulesProvider);
            if (zoneRulesProvider2 == null) continue;
            throw new ZoneRulesException("Unable to register zone as one already registered with that ID: " + string + ", currently loading from provider: " + zoneRulesProvider);
        }
    }

    public static boolean refresh() {
        boolean bl = false;
        for (ZoneRulesProvider zoneRulesProvider : PROVIDERS) {
            bl |= zoneRulesProvider.provideRefresh();
        }
        return bl;
    }

    protected ZoneRulesProvider() {
    }

    protected abstract Set provideZoneIds();

    protected abstract ZoneRules provideRules(String var1, boolean var2);

    protected abstract NavigableMap provideVersions(String var1);

    protected boolean provideRefresh() {
        return false;
    }

    static {
        ZoneRulesInitializer.initialize();
    }
}

