/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.Writer;
import oz.util.barcode.aztec.AztecWriter;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.datamatrix.DataMatrixWriter;
import oz.util.barcode.oned.CodaBarWriter;
import oz.util.barcode.oned.Code128Writer;
import oz.util.barcode.oned.Code39Writer;
import oz.util.barcode.oned.Code93Writer;
import oz.util.barcode.oned.EAN13Writer;
import oz.util.barcode.oned.EAN8Writer;
import oz.util.barcode.oned.ITFWriter;
import oz.util.barcode.oned.UPCAWriter;
import oz.util.barcode.oned.UPCEWriter;
import oz.util.barcode.pdf417.PDF417Writer;
import oz.util.barcode.qrcode.QRCodeWriter;

public final class MultiFormatWriter
implements Writer {
    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2) {
        return this.encode(string, barcodeFormat, n, n2, null);
    }

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        Writer writer;
        switch (barcodeFormat) {
            case EAN_8: {
                writer = new EAN8Writer();
                break;
            }
            case UPC_E: {
                writer = new UPCEWriter();
                break;
            }
            case EAN_13: {
                writer = new EAN13Writer();
                break;
            }
            case UPC_A: {
                writer = new UPCAWriter();
                break;
            }
            case QR_CODE: {
                writer = new QRCodeWriter();
                break;
            }
            case CODE_39: {
                writer = new Code39Writer();
                break;
            }
            case CODE_93: {
                writer = new Code93Writer();
                break;
            }
            case CODE_128: {
                writer = new Code128Writer();
                break;
            }
            case ITF: {
                writer = new ITFWriter();
                break;
            }
            case PDF_417: {
                writer = new PDF417Writer();
                break;
            }
            case CODABAR: {
                writer = new CodaBarWriter();
                break;
            }
            case DATA_MATRIX: {
                writer = new DataMatrixWriter();
                break;
            }
            case AZTEC: {
                writer = new AztecWriter();
                break;
            }
            default: {
                throw new IllegalArgumentException("No encoder available for format " + (Object)((Object)barcodeFormat));
            }
        }
        return writer.encode(string, barcodeFormat, n, n2, map);
    }
}

