/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode;

import oz.util.barcode.common.detector.MathUtils;

public class ResultPoint {
    private final float x;
    private final float y;

    public ResultPoint(float f2, float f3) {
        this.x = f2;
        this.y = f3;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final boolean equals(Object object) {
        if (object instanceof ResultPoint) {
            ResultPoint resultPoint = (ResultPoint)object;
            return this.x == resultPoint.x && this.y == resultPoint.y;
        }
        return false;
    }

    public final int hashCode() {
        return 31 * Float.floatToIntBits(this.x) + Float.floatToIntBits(this.y);
    }

    public final String toString() {
        return "(" + this.x + ',' + this.y + ')';
    }

    public static void orderBestPatterns(ResultPoint[] resultPointArray) {
        ResultPoint resultPoint;
        ResultPoint resultPoint2;
        ResultPoint resultPoint3;
        float f2 = ResultPoint.distance(resultPointArray[0], resultPointArray[1]);
        float f3 = ResultPoint.distance(resultPointArray[1], resultPointArray[2]);
        float f4 = ResultPoint.distance(resultPointArray[0], resultPointArray[2]);
        if (f3 >= f2 && f3 >= f4) {
            resultPoint3 = resultPointArray[0];
            resultPoint2 = resultPointArray[1];
            resultPoint = resultPointArray[2];
        } else if (f4 >= f3 && f4 >= f2) {
            resultPoint3 = resultPointArray[1];
            resultPoint2 = resultPointArray[0];
            resultPoint = resultPointArray[2];
        } else {
            resultPoint3 = resultPointArray[2];
            resultPoint2 = resultPointArray[0];
            resultPoint = resultPointArray[1];
        }
        if (ResultPoint.crossProductZ(resultPoint2, resultPoint3, resultPoint) < 0.0f) {
            ResultPoint resultPoint4 = resultPoint2;
            resultPoint2 = resultPoint;
            resultPoint = resultPoint4;
        }
        resultPointArray[0] = resultPoint2;
        resultPointArray[1] = resultPoint3;
        resultPointArray[2] = resultPoint;
    }

    public static float distance(ResultPoint resultPoint, ResultPoint resultPoint2) {
        return MathUtils.distance(resultPoint.x, resultPoint.y, resultPoint2.x, resultPoint2.y);
    }

    private static float crossProductZ(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3) {
        float f2 = resultPoint2.x;
        float f3 = resultPoint2.y;
        return (resultPoint3.x - f2) * (resultPoint.y - f3) - (resultPoint3.y - f3) * (resultPoint.x - f2);
    }
}

