/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.aztec.encoder;

import oz.util.barcode.aztec.encoder.AztecCode;
import oz.util.barcode.aztec.encoder.HighLevelEncoder;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.common.reedsolomon.GenericGF;
import oz.util.barcode.common.reedsolomon.ReedSolomonEncoder;

public final class Encoder {
    public static final int DEFAULT_EC_PERCENT = 33;
    public static final int DEFAULT_AZTEC_LAYERS = 0;
    private static final int MAX_NB_BITS = 32;
    private static final int MAX_NB_BITS_COMPACT = 4;
    private static final int[] WORD_SIZE = new int[]{4, 6, 6, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};

    private Encoder() {
    }

    public static AztecCode encode(byte[] byArray) {
        return Encoder.encode(byArray, 33, 0);
    }

    public static AztecCode encode(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        BitArray bitArray;
        int n9;
        int n10;
        int n11;
        int n12;
        boolean bl;
        BitArray bitArray2 = new HighLevelEncoder(byArray).encode();
        int n13 = bitArray2.getSize() * n / 100 + 11;
        int n14 = bitArray2.getSize() + n13;
        if (n2 != 0) {
            bl = n2 < 0;
            n12 = Math.abs(n2);
            if (n12 > (bl ? 4 : 32)) {
                throw new IllegalArgumentException(String.format("Illegal value %s for layers", n2));
            }
            n11 = Encoder.totalBitsInLayer(n12, bl);
            n10 = WORD_SIZE[n12];
            n9 = n11 - n11 % n10;
            bitArray = Encoder.stuffBits(bitArray2, n10);
            if (bitArray.getSize() + n13 > n9) {
                throw new IllegalArgumentException("Data to large for user specified layer");
            }
            if (bl && bitArray.getSize() > n10 * 64) {
                throw new IllegalArgumentException("Data to large for user specified layer");
            }
        } else {
            n10 = 0;
            bitArray = null;
            n9 = 0;
            while (true) {
                if (n9 > 32) {
                    throw new IllegalArgumentException("Data too large for an Aztec code");
                }
                bl = n9 <= 3;
                n12 = bl ? n9 + 1 : n9;
                n11 = Encoder.totalBitsInLayer(n12, bl);
                if (n14 <= n11) {
                    if (bitArray == null || n10 != WORD_SIZE[n12]) {
                        n10 = WORD_SIZE[n12];
                        bitArray = Encoder.stuffBits(bitArray2, n10);
                    }
                    n8 = n11 - n11 % n10;
                    if ((!bl || bitArray.getSize() <= n10 * 64) && bitArray.getSize() + n13 <= n8) break;
                }
                ++n9;
            }
        }
        BitArray bitArray3 = Encoder.generateCheckWords(bitArray, n11, n10);
        n8 = bitArray.getSize() / n10;
        BitArray bitArray4 = Encoder.generateModeMessage(bl, n12, n8);
        int n15 = (bl ? 11 : 14) + n12 * 4;
        int[] nArray = new int[n15];
        if (bl) {
            n7 = n15;
            n6 = 0;
            while (n6 < nArray.length) {
                nArray[n6] = n6;
                ++n6;
            }
        } else {
            n7 = n15 + 1 + 2 * ((n15 / 2 - 1) / 15);
            n6 = n15 / 2;
            n5 = n7 / 2;
            n4 = 0;
            while (n4 < n6) {
                n3 = n4 + n4 / 15;
                nArray[n6 - n4 - 1] = n5 - n3 - 1;
                nArray[n6 + n4] = n5 + n3 + 1;
                ++n4;
            }
        }
        BitMatrix bitMatrix = new BitMatrix(n7);
        n5 = 0;
        n4 = 0;
        while (n5 < n12) {
            n3 = (n12 - n5) * 4 + (bl ? 9 : 12);
            int n16 = 0;
            while (n16 < n3) {
                int n17 = n16 * 2;
                int n18 = 0;
                while (n18 < 2) {
                    if (bitArray3.get(n4 + n17 + n18)) {
                        bitMatrix.set(nArray[n5 * 2 + n18], nArray[n5 * 2 + n16]);
                    }
                    if (bitArray3.get(n4 + n3 * 2 + n17 + n18)) {
                        bitMatrix.set(nArray[n5 * 2 + n16], nArray[n15 - 1 - n5 * 2 - n18]);
                    }
                    if (bitArray3.get(n4 + n3 * 4 + n17 + n18)) {
                        bitMatrix.set(nArray[n15 - 1 - n5 * 2 - n18], nArray[n15 - 1 - n5 * 2 - n16]);
                    }
                    if (bitArray3.get(n4 + n3 * 6 + n17 + n18)) {
                        bitMatrix.set(nArray[n15 - 1 - n5 * 2 - n16], nArray[n5 * 2 + n18]);
                    }
                    ++n18;
                }
                ++n16;
            }
            n4 += n3 * 8;
            ++n5;
        }
        Encoder.drawModeMessage(bitMatrix, bl, n7, bitArray4);
        if (bl) {
            Encoder.drawBullsEye(bitMatrix, n7 / 2, 5);
        } else {
            Encoder.drawBullsEye(bitMatrix, n7 / 2, 7);
            n5 = 0;
            n4 = 0;
            while (n5 < n15 / 2 - 1) {
                n3 = n7 / 2 & 1;
                while (n3 < n7) {
                    bitMatrix.set(n7 / 2 - n4, n3);
                    bitMatrix.set(n7 / 2 + n4, n3);
                    bitMatrix.set(n3, n7 / 2 - n4);
                    bitMatrix.set(n3, n7 / 2 + n4);
                    n3 += 2;
                }
                n5 += 15;
                n4 += 16;
            }
        }
        AztecCode aztecCode = new AztecCode();
        aztecCode.setCompact(bl);
        aztecCode.setSize(n7);
        aztecCode.setLayers(n12);
        aztecCode.setCodeWords(n8);
        aztecCode.setMatrix(bitMatrix);
        return aztecCode;
    }

    private static void drawBullsEye(BitMatrix bitMatrix, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n - n3;
            while (n4 <= n + n3) {
                bitMatrix.set(n4, n - n3);
                bitMatrix.set(n4, n + n3);
                bitMatrix.set(n - n3, n4);
                bitMatrix.set(n + n3, n4);
                ++n4;
            }
            n3 += 2;
        }
        bitMatrix.set(n - n2, n - n2);
        bitMatrix.set(n - n2 + 1, n - n2);
        bitMatrix.set(n - n2, n - n2 + 1);
        bitMatrix.set(n + n2, n - n2);
        bitMatrix.set(n + n2, n - n2 + 1);
        bitMatrix.set(n + n2, n + n2 - 1);
    }

    static BitArray generateModeMessage(boolean bl, int n, int n2) {
        BitArray bitArray = new BitArray();
        if (bl) {
            bitArray.appendBits(n - 1, 2);
            bitArray.appendBits(n2 - 1, 6);
            bitArray = Encoder.generateCheckWords(bitArray, 28, 4);
        } else {
            bitArray.appendBits(n - 1, 5);
            bitArray.appendBits(n2 - 1, 11);
            bitArray = Encoder.generateCheckWords(bitArray, 40, 4);
        }
        return bitArray;
    }

    private static void drawModeMessage(BitMatrix bitMatrix, boolean bl, int n, BitArray bitArray) {
        int n2 = n / 2;
        if (bl) {
            int n3 = 0;
            while (n3 < 7) {
                int n4 = n2 - 3 + n3;
                if (bitArray.get(n3)) {
                    bitMatrix.set(n4, n2 - 5);
                }
                if (bitArray.get(n3 + 7)) {
                    bitMatrix.set(n2 + 5, n4);
                }
                if (bitArray.get(20 - n3)) {
                    bitMatrix.set(n4, n2 + 5);
                }
                if (bitArray.get(27 - n3)) {
                    bitMatrix.set(n2 - 5, n4);
                }
                ++n3;
            }
        } else {
            int n5 = 0;
            while (n5 < 10) {
                int n6 = n2 - 5 + n5 + n5 / 5;
                if (bitArray.get(n5)) {
                    bitMatrix.set(n6, n2 - 7);
                }
                if (bitArray.get(n5 + 10)) {
                    bitMatrix.set(n2 + 7, n6);
                }
                if (bitArray.get(29 - n5)) {
                    bitMatrix.set(n6, n2 + 7);
                }
                if (bitArray.get(39 - n5)) {
                    bitMatrix.set(n2 - 7, n6);
                }
                ++n5;
            }
        }
    }

    private static BitArray generateCheckWords(BitArray bitArray, int n, int n2) {
        int n3 = bitArray.getSize() / n2;
        ReedSolomonEncoder reedSolomonEncoder = new ReedSolomonEncoder(Encoder.getGF(n2));
        int n4 = n / n2;
        int[] nArray = Encoder.bitsToWords(bitArray, n2, n4);
        reedSolomonEncoder.encode(nArray, n4 - n3);
        int n5 = n % n2;
        BitArray bitArray2 = new BitArray();
        bitArray2.appendBits(0, n5);
        int[] nArray2 = nArray;
        int n6 = nArray.length;
        int n7 = 0;
        while (n7 < n6) {
            int n8 = nArray2[n7];
            bitArray2.appendBits(n8, n2);
            ++n7;
        }
        return bitArray2;
    }

    private static int[] bitsToWords(BitArray bitArray, int n, int n2) {
        int[] nArray = new int[n2];
        int n3 = 0;
        int n4 = bitArray.getSize() / n;
        while (n3 < n4) {
            int n5 = 0;
            int n6 = 0;
            while (n6 < n) {
                n5 |= bitArray.get(n3 * n + n6) ? 1 << n - n6 - 1 : 0;
                ++n6;
            }
            nArray[n3] = n5;
            ++n3;
        }
        return nArray;
    }

    private static GenericGF getGF(int n) {
        switch (n) {
            case 4: {
                return GenericGF.AZTEC_PARAM;
            }
            case 6: {
                return GenericGF.AZTEC_DATA_6;
            }
            case 8: {
                return GenericGF.AZTEC_DATA_8;
            }
            case 10: {
                return GenericGF.AZTEC_DATA_10;
            }
            case 12: {
                return GenericGF.AZTEC_DATA_12;
            }
        }
        throw new IllegalArgumentException("Unsupported word size " + n);
    }

    static BitArray stuffBits(BitArray bitArray, int n) {
        BitArray bitArray2 = new BitArray();
        int n2 = bitArray.getSize();
        int n3 = (1 << n) - 2;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            int n6 = 0;
            while (n6 < n) {
                if (n4 + n6 >= n2 || bitArray.get(n4 + n6)) {
                    n5 |= 1 << n - 1 - n6;
                }
                ++n6;
            }
            if ((n5 & n3) == n3) {
                bitArray2.appendBits(n5 & n3, n);
                --n4;
            } else if ((n5 & n3) == 0) {
                bitArray2.appendBits(n5 | 1, n);
                --n4;
            } else {
                bitArray2.appendBits(n5, n);
            }
            n4 += n;
        }
        return bitArray2;
    }

    private static int totalBitsInLayer(int n, boolean bl) {
        return ((bl ? 88 : 112) + 16 * n) * n;
    }
}

