/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.android;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Vibrator;
import android.preference.PreferenceManager;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import oz.main.OZStorage;

final class BeepManager {
    private static final String TAG = BeepManager.class.getSimpleName();
    private static final float BEEP_VOLUME = 0.5f;
    private static final long VIBRATE_DURATION = 200L;
    private final Activity activity;
    private MediaPlayer mediaPlayer;
    private boolean playBeep;
    private boolean vibrate;

    BeepManager(Activity activity) {
        this.activity = activity;
        this.mediaPlayer = null;
        this.updatePrefs();
    }

    void updatePrefs() {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.activity);
        this.playBeep = BeepManager.shouldBeep(sharedPreferences, (Context)this.activity);
        this.vibrate = true;
        if (this.playBeep && this.mediaPlayer == null) {
            this.activity.setVolumeControlStream(3);
            this.mediaPlayer = BeepManager.buildMediaPlayer((Context)this.activity);
        }
    }

    void playBeepSoundAndVibrate() {
        if (this.playBeep && this.mediaPlayer != null) {
            this.mediaPlayer.seekTo(0);
            this.mediaPlayer.start();
        }
        if (this.vibrate) {
            try {
                Vibrator vibrator = (Vibrator)this.activity.getSystemService("vibrator");
                vibrator.vibrate(200L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static boolean shouldBeep(SharedPreferences sharedPreferences, Context context) {
        AudioManager audioManager;
        boolean bl = true;
        if (bl && (audioManager = (AudioManager)context.getSystemService("audio")).getRingerMode() != 2) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MediaPlayer buildMediaPlayer(Context context) {
        MediaPlayer mediaPlayer = new MediaPlayer();
        mediaPlayer.setAudioStreamType(3);
        String string = OZStorage.tmpCacheDir + "/OZReport Viewer/res/beep.mp3";
        File file = new File(string);
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = context.getResources().getAssets().open("resource/beep.mp3");
            if (!file.exists() || file.length() != (long)inputStream.available()) {
                if (file.exists()) {
                    file.delete();
                }
                fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[4096];
                int n = 0;
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)"OZViewer", (String)"file copy error", (Throwable)exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        try {
            mediaPlayer.setDataSource(string);
            mediaPlayer.setVolume(0.5f, 0.5f);
            mediaPlayer.prepare();
        }
        catch (IOException iOException) {
            Log.w((String)TAG, (String)iOException.getMessage());
            mediaPlayer = null;
        }
        return mediaPlayer;
    }
}

