/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.android;

import android.content.Context;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.BinaryBitmap;
import oz.util.barcode.DecodeHintType;
import oz.util.barcode.MultiFormatReader;
import oz.util.barcode.PlanarYUVLuminanceSource;
import oz.util.barcode.ReaderException;
import oz.util.barcode.Result;
import oz.util.barcode.client.android.DecodeFormatManager;
import oz.util.barcode.common.HybridBinarizer;

public final class OZBarcodeDecoder {
    private Collection decodeFormats;
    private Map decodeHints;
    private final MultiFormatReader multiFormatReader;
    private String characterSet;

    public OZBarcodeDecoder(Context context, Collection collection) {
        this.decodeFormats = collection;
        this.decodeHints = new EnumMap(DecodeHintType.class);
        if (this.decodeFormats == null || this.decodeFormats.isEmpty()) {
            this.decodeFormats = EnumSet.noneOf(BarcodeFormat.class);
            this.decodeFormats.addAll(DecodeFormatManager.ONE_D_FORMATS);
        }
        this.decodeHints.put(DecodeHintType.POSSIBLE_FORMATS, this.decodeFormats);
        if (this.characterSet != null) {
            this.decodeHints.put(DecodeHintType.CHARACTER_SET, this.characterSet);
        }
        this.multiFormatReader = new MultiFormatReader();
        this.multiFormatReader.setHints(this.decodeHints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result decode(byte[] byArray, int n, int n2) {
        long l = System.currentTimeMillis();
        Result result = null;
        PlanarYUVLuminanceSource planarYUVLuminanceSource = new PlanarYUVLuminanceSource(byArray, n, n2, 0, 0, n, n2, false);
        if (planarYUVLuminanceSource != null) {
            BinaryBitmap binaryBitmap = new BinaryBitmap(new HybridBinarizer(planarYUVLuminanceSource));
            try {
                result = this.multiFormatReader.decodeWithState(binaryBitmap);
            }
            catch (ReaderException readerException) {
            }
            finally {
                this.multiFormatReader.reset();
            }
        }
        return result;
    }
}

