/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.result;

import java.util.regex.Pattern;
import oz.util.barcode.Result;
import oz.util.barcode.client.result.AbstractDoCoMoResultParser;
import oz.util.barcode.client.result.EmailAddressParsedResult;

public final class EmailDoCoMoResultParser
extends AbstractDoCoMoResultParser {
    private static final Pattern ATEXT_ALPHANUMERIC = Pattern.compile("[a-zA-Z0-9@.!#$%&'*+\\-/=?^_`{|}~]+");

    @Override
    public EmailAddressParsedResult parse(Result result) {
        String string;
        String string2 = EmailDoCoMoResultParser.getMassagedText(result);
        if (!string2.startsWith("MATMSG:")) {
            return null;
        }
        String[] stringArray = EmailDoCoMoResultParser.matchDoCoMoPrefixedField("TO:", string2, true);
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            string = stringArray2[n2];
            if (!EmailDoCoMoResultParser.isBasicallyValidEmailAddress(string)) {
                return null;
            }
            ++n2;
        }
        string = EmailDoCoMoResultParser.matchSingleDoCoMoPrefixedField("SUB:", string2, false);
        String string3 = EmailDoCoMoResultParser.matchSingleDoCoMoPrefixedField("BODY:", string2, false);
        return new EmailAddressParsedResult(stringArray, null, null, string, string3);
    }

    static boolean isBasicallyValidEmailAddress(String string) {
        return string != null && ATEXT_ALPHANUMERIC.matcher(string).matches() && string.indexOf(64) >= 0;
    }
}

