/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.result;

import java.util.regex.Pattern;
import oz.util.barcode.client.result.ParsedResult;
import oz.util.barcode.client.result.ParsedResultType;
import oz.util.barcode.client.result.ResultParser;

public final class URIParsedResult
extends ParsedResult {
    private static final Pattern USER_IN_HOST = Pattern.compile(":/*([^/@]+)@[^/]+");
    private final String uri;
    private final String title;

    public URIParsedResult(String string, String string2) {
        super(ParsedResultType.URI);
        this.uri = URIParsedResult.massageURI(string);
        this.title = string2;
    }

    public String getURI() {
        return this.uri;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isPossiblyMaliciousURI() {
        return USER_IN_HOST.matcher(this.uri).find();
    }

    @Override
    public String getDisplayResult() {
        StringBuilder stringBuilder = new StringBuilder(30);
        URIParsedResult.maybeAppend(this.title, stringBuilder);
        URIParsedResult.maybeAppend(this.uri, stringBuilder);
        return stringBuilder.toString();
    }

    private static String massageURI(String string) {
        int n = (string = string.trim()).indexOf(58);
        if (n < 0 || URIParsedResult.isColonFollowedByPortNumber(string, n)) {
            string = "http://" + string;
        }
        return string;
    }

    private static boolean isColonFollowedByPortNumber(String string, int n) {
        int n2 = n + 1;
        int n3 = string.indexOf(47, n2);
        if (n3 < 0) {
            n3 = string.length();
        }
        return ResultParser.isSubstringOfDigits(string, n2, n3 - n2);
    }
}

