/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.result;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oz.util.barcode.Result;
import oz.util.barcode.client.result.AddressBookParsedResult;
import oz.util.barcode.client.result.ResultParser;

public final class VCardResultParser
extends ResultParser {
    private static final Pattern BEGIN_VCARD = Pattern.compile("BEGIN:VCARD", 2);
    private static final Pattern VCARD_LIKE_DATE = Pattern.compile("\\d{4}-?\\d{2}-?\\d{2}");
    private static final Pattern CR_LF_SPACE_TAB = Pattern.compile("\r\n[ \t]");
    private static final Pattern NEWLINE_ESCAPE = Pattern.compile("\\\\[nN]");
    private static final Pattern VCARD_ESCAPES = Pattern.compile("\\\\([,;\\\\])");
    private static final Pattern EQUALS = Pattern.compile("=");
    private static final Pattern SEMICOLON = Pattern.compile(";");
    private static final Pattern UNESCAPED_SEMICOLONS = Pattern.compile("(?<!\\\\);+");
    private static final Pattern COMMA = Pattern.compile(",");
    private static final Pattern SEMICOLON_OR_COMMA = Pattern.compile("[;,]");

    @Override
    public AddressBookParsedResult parse(Result result) {
        String[] stringArray;
        List list;
        String string = VCardResultParser.getMassagedText(result);
        Matcher matcher = BEGIN_VCARD.matcher(string);
        if (!matcher.find() || matcher.start() != 0) {
            return null;
        }
        List list2 = VCardResultParser.matchVCardPrefixedField("FN", string, true, false);
        if (list2 == null) {
            list2 = VCardResultParser.matchVCardPrefixedField("N", string, true, false);
            VCardResultParser.formatNames(list2);
        }
        String[] stringArray2 = (list = VCardResultParser.matchSingleVCardPrefixedField("NICKNAME", string, true, false)) == null ? null : COMMA.split((CharSequence)list.get(0));
        List list3 = VCardResultParser.matchVCardPrefixedField("TEL", string, true, false);
        List list4 = VCardResultParser.matchVCardPrefixedField("EMAIL", string, true, false);
        List list5 = VCardResultParser.matchSingleVCardPrefixedField("NOTE", string, false, false);
        List list6 = VCardResultParser.matchVCardPrefixedField("ADR", string, true, true);
        List list7 = VCardResultParser.matchSingleVCardPrefixedField("ORG", string, true, true);
        List list8 = VCardResultParser.matchSingleVCardPrefixedField("BDAY", string, true, false);
        if (list8 != null && !VCardResultParser.isLikeVCardDate((CharSequence)list8.get(0))) {
            list8 = null;
        }
        List list9 = VCardResultParser.matchSingleVCardPrefixedField("TITLE", string, true, false);
        List list10 = VCardResultParser.matchVCardPrefixedField("URL", string, true, false);
        List list11 = VCardResultParser.matchSingleVCardPrefixedField("IMPP", string, true, false);
        List list12 = VCardResultParser.matchSingleVCardPrefixedField("GEO", string, true, false);
        String[] stringArray3 = stringArray = list12 == null ? null : SEMICOLON_OR_COMMA.split((CharSequence)list12.get(0));
        if (stringArray != null && stringArray.length != 2) {
            stringArray = null;
        }
        return new AddressBookParsedResult(VCardResultParser.toPrimaryValues(list2), stringArray2, null, VCardResultParser.toPrimaryValues(list3), VCardResultParser.toTypes(list3), VCardResultParser.toPrimaryValues(list4), VCardResultParser.toTypes(list4), VCardResultParser.toPrimaryValue(list11), VCardResultParser.toPrimaryValue(list5), VCardResultParser.toPrimaryValues(list6), VCardResultParser.toTypes(list6), VCardResultParser.toPrimaryValue(list7), VCardResultParser.toPrimaryValue(list8), VCardResultParser.toPrimaryValue(list9), VCardResultParser.toPrimaryValues(list10), stringArray);
    }

    static List matchVCardPrefixedField(CharSequence charSequence, String string, boolean bl, boolean bl2) {
        ArrayList arrayList = null;
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            Matcher matcher = Pattern.compile("(?:^|\n)" + charSequence + "(?:;([^:]*))?:", 2).matcher(string);
            if (n > 0) {
                --n;
            }
            if (!matcher.find(n)) break;
            n = matcher.end(0);
            String string2 = matcher.group(1);
            ArrayList<String> arrayList2 = null;
            boolean bl3 = false;
            String string3 = null;
            String string4 = null;
            if (string2 != null) {
                String[] stringArray = SEMICOLON.split(string2);
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String string5 = stringArray[n4];
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<String>(1);
                    }
                    arrayList2.add(string5);
                    String[] stringArray2 = EQUALS.split(string5, 2);
                    if (stringArray2.length > 1) {
                        String string6 = stringArray2[0];
                        String string7 = stringArray2[1];
                        if ("ENCODING".equalsIgnoreCase(string6) && "QUOTED-PRINTABLE".equalsIgnoreCase(string7)) {
                            bl3 = true;
                        } else if ("CHARSET".equalsIgnoreCase(string6)) {
                            string3 = string7;
                        } else if ("VALUE".equalsIgnoreCase(string6)) {
                            string4 = string7;
                        }
                    }
                    ++n4;
                }
            }
            int n5 = n;
            while ((n = string.indexOf(10, n)) >= 0) {
                if (n < string.length() - 1 && (string.charAt(n + 1) == ' ' || string.charAt(n + 1) == '\t')) {
                    n += 2;
                    continue;
                }
                if (!bl3 || (n < 1 || string.charAt(n - 1) != '=') && (n < 2 || string.charAt(n - 2) != '=')) break;
                ++n;
            }
            if (n < 0) {
                n = n2;
                continue;
            }
            if (n > n5) {
                if (arrayList == null) {
                    arrayList = new ArrayList(1);
                }
                if (n >= 1 && string.charAt(n - 1) == '\r') {
                    --n;
                }
                String string8 = string.substring(n5, n);
                if (bl) {
                    string8 = string8.trim();
                }
                if (bl3) {
                    string8 = VCardResultParser.decodeQuotedPrintable(string8, string3);
                    if (bl2) {
                        string8 = UNESCAPED_SEMICOLONS.matcher(string8).replaceAll("\n").trim();
                    }
                } else {
                    if (bl2) {
                        string8 = UNESCAPED_SEMICOLONS.matcher(string8).replaceAll("\n").trim();
                    }
                    string8 = CR_LF_SPACE_TAB.matcher(string8).replaceAll("");
                    string8 = NEWLINE_ESCAPE.matcher(string8).replaceAll("\n");
                    string8 = VCARD_ESCAPES.matcher(string8).replaceAll("$1");
                }
                if ("uri".equals(string4)) {
                    try {
                        string8 = URI.create(string8).getSchemeSpecificPart();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (arrayList2 == null) {
                    ArrayList<String> arrayList3 = new ArrayList<String>(1);
                    arrayList3.add(string8);
                    arrayList.add(arrayList3);
                } else {
                    arrayList2.add(0, string8);
                    arrayList.add(arrayList2);
                }
                ++n;
                continue;
            }
            ++n;
        }
        return arrayList;
    }

    private static String decodeQuotedPrintable(CharSequence charSequence, String string) {
        int n = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while (n2 < n) {
            char c2 = charSequence.charAt(n2);
            switch (c2) {
                case '\n': 
                case '\r': {
                    break;
                }
                case '=': {
                    char c3;
                    if (n2 >= n - 2 || (c3 = charSequence.charAt(n2 + 1)) == '\r' || c3 == '\n') break;
                    char c4 = charSequence.charAt(n2 + 2);
                    int n3 = VCardResultParser.parseHexDigit(c3);
                    int n4 = VCardResultParser.parseHexDigit(c4);
                    if (n3 >= 0 && n4 >= 0) {
                        byteArrayOutputStream.write((n3 << 4) + n4);
                    }
                    n2 += 2;
                    break;
                }
                default: {
                    VCardResultParser.maybeAppendFragment(byteArrayOutputStream, string, stringBuilder);
                    stringBuilder.append(c2);
                }
            }
            ++n2;
        }
        VCardResultParser.maybeAppendFragment(byteArrayOutputStream, string, stringBuilder);
        return stringBuilder.toString();
    }

    private static void maybeAppendFragment(ByteArrayOutputStream byteArrayOutputStream, String string, StringBuilder stringBuilder) {
        if (byteArrayOutputStream.size() > 0) {
            String string2;
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (string == null) {
                string2 = new String(byArray, StandardCharsets.UTF_8);
            } else {
                try {
                    string2 = new String(byArray, string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string2 = new String(byArray, StandardCharsets.UTF_8);
                }
            }
            byteArrayOutputStream.reset();
            stringBuilder.append(string2);
        }
    }

    static List matchSingleVCardPrefixedField(CharSequence charSequence, String string, boolean bl, boolean bl2) {
        List list = VCardResultParser.matchVCardPrefixedField(charSequence, string, bl, bl2);
        return list == null || list.isEmpty() ? null : (List)list.get(0);
    }

    private static String toPrimaryValue(List list) {
        return list == null || list.isEmpty() ? null : (String)list.get(0);
    }

    private static String[] toPrimaryValues(Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (List list : collection) {
            String string = (String)list.get(0);
            if (string == null || string.isEmpty()) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String[] toTypes(Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (List list : collection) {
            String string = (String)list.get(0);
            if (string == null || string.isEmpty()) continue;
            String string2 = null;
            int n = 1;
            while (n < list.size()) {
                String string3 = (String)list.get(n);
                int n2 = string3.indexOf(61);
                if (n2 < 0) {
                    string2 = string3;
                    break;
                }
                if ("TYPE".equalsIgnoreCase(string3.substring(0, n2))) {
                    string2 = string3.substring(n2 + 1);
                    break;
                }
                ++n;
            }
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static boolean isLikeVCardDate(CharSequence charSequence) {
        return charSequence == null || VCARD_LIKE_DATE.matcher(charSequence).matches();
    }

    private static void formatNames(Iterable iterable) {
        if (iterable != null) {
            for (List list : iterable) {
                int n;
                String string = (String)list.get(0);
                String[] stringArray = new String[5];
                int n2 = 0;
                int n3 = 0;
                while (n3 < stringArray.length - 1 && (n = string.indexOf(59, n2)) >= 0) {
                    stringArray[n3] = string.substring(n2, n);
                    ++n3;
                    n2 = n + 1;
                }
                stringArray[n3] = string.substring(n2);
                StringBuilder stringBuilder = new StringBuilder(100);
                VCardResultParser.maybeAppendComponent(stringArray, 3, stringBuilder);
                VCardResultParser.maybeAppendComponent(stringArray, 1, stringBuilder);
                VCardResultParser.maybeAppendComponent(stringArray, 2, stringBuilder);
                VCardResultParser.maybeAppendComponent(stringArray, 0, stringBuilder);
                VCardResultParser.maybeAppendComponent(stringArray, 4, stringBuilder);
                list.set(0, stringBuilder.toString().trim());
            }
        }
    }

    private static void maybeAppendComponent(String[] stringArray, int n, StringBuilder stringBuilder) {
        if (stringArray[n] != null && !stringArray[n].isEmpty()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(stringArray[n]);
        }
    }
}

