/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.common.reedsolomon;

import oz.util.barcode.common.reedsolomon.GenericGFPoly;

public final class GenericGF {
    public static final GenericGF AZTEC_DATA_12 = new GenericGF(4201, 4096, 1);
    public static final GenericGF AZTEC_DATA_10 = new GenericGF(1033, 1024, 1);
    public static final GenericGF AZTEC_DATA_6 = new GenericGF(67, 64, 1);
    public static final GenericGF AZTEC_PARAM = new GenericGF(19, 16, 1);
    public static final GenericGF QR_CODE_FIELD_256 = new GenericGF(285, 256, 0);
    public static final GenericGF DATA_MATRIX_FIELD_256;
    public static final GenericGF AZTEC_DATA_8;
    public static final GenericGF MAXICODE_FIELD_64;
    private final int[] expTable;
    private final int[] logTable;
    private final GenericGFPoly zero;
    private final GenericGFPoly one;
    private final int size;
    private final int primitive;
    private final int generatorBase;

    static {
        AZTEC_DATA_8 = DATA_MATRIX_FIELD_256 = new GenericGF(301, 256, 1);
        MAXICODE_FIELD_64 = AZTEC_DATA_6;
    }

    public GenericGF(int n, int n2, int n3) {
        this.primitive = n;
        this.size = n2;
        this.generatorBase = n3;
        this.expTable = new int[n2];
        this.logTable = new int[n2];
        int n4 = 1;
        int n5 = 0;
        while (n5 < n2) {
            this.expTable[n5] = n4;
            if ((n4 *= 2) >= n2) {
                n4 ^= n;
                n4 &= n2 - 1;
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < n2 - 1) {
            this.logTable[this.expTable[n5]] = n5;
            ++n5;
        }
        this.zero = new GenericGFPoly(this, new int[1]);
        this.one = new GenericGFPoly(this, new int[]{1});
    }

    GenericGFPoly getZero() {
        return this.zero;
    }

    GenericGFPoly getOne() {
        return this.one;
    }

    GenericGFPoly buildMonomial(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n2 == 0) {
            return this.zero;
        }
        int[] nArray = new int[n + 1];
        nArray[0] = n2;
        return new GenericGFPoly(this, nArray);
    }

    static int addOrSubtract(int n, int n2) {
        return n ^ n2;
    }

    int exp(int n) {
        return this.expTable[n];
    }

    int log(int n) {
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        return this.logTable[n];
    }

    int inverse(int n) {
        if (n == 0) {
            throw new ArithmeticException();
        }
        return this.expTable[this.size - this.logTable[n] - 1];
    }

    int multiply(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return 0;
        }
        return this.expTable[(this.logTable[n] + this.logTable[n2]) % (this.size - 1)];
    }

    public int getSize() {
        return this.size;
    }

    public int getGeneratorBase() {
        return this.generatorBase;
    }

    public String toString() {
        return "GF(0x" + Integer.toHexString(this.primitive) + ',' + this.size + ')';
    }
}

