/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.datamatrix.decoder;

import oz.util.barcode.ChecksumException;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.common.DecoderResult;
import oz.util.barcode.common.reedsolomon.GenericGF;
import oz.util.barcode.common.reedsolomon.ReedSolomonDecoder;
import oz.util.barcode.common.reedsolomon.ReedSolomonException;
import oz.util.barcode.datamatrix.decoder.BitMatrixParser;
import oz.util.barcode.datamatrix.decoder.DataBlock;
import oz.util.barcode.datamatrix.decoder.DecodedBitStreamParser;
import oz.util.barcode.datamatrix.decoder.Version;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.DATA_MATRIX_FIELD_256);

    public DecoderResult decode(boolean[][] blArray) {
        return this.decode(BitMatrix.parse(blArray));
    }

    public DecoderResult decode(BitMatrix bitMatrix) {
        Object object;
        BitMatrixParser bitMatrixParser = new BitMatrixParser(bitMatrix);
        Version version = bitMatrixParser.getVersion();
        byte[] byArray = bitMatrixParser.readCodewords();
        DataBlock[] dataBlockArray = DataBlock.getDataBlocks(byArray, version);
        int n = 0;
        Object object2 = dataBlockArray;
        int n2 = dataBlockArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = object2[n3];
            n += ((DataBlock)object).getNumDataCodewords();
            ++n3;
        }
        object = new byte[n];
        n3 = dataBlockArray.length;
        n2 = 0;
        while (n2 < n3) {
            object2 = dataBlockArray[n2];
            byte[] byArray2 = ((DataBlock)object2).getCodewords();
            int n4 = ((DataBlock)object2).getNumDataCodewords();
            this.correctErrors(byArray2, n4);
            int n5 = 0;
            while (n5 < n4) {
                object[n5 * n3 + n2] = byArray2[n5];
                ++n5;
            }
            ++n2;
        }
        return DecodedBitStreamParser.decode((byte[])object);
    }

    private void correctErrors(byte[] byArray, int n) {
        int n2 = byArray.length;
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = byArray[n3] & 0xFF;
            ++n3;
        }
        try {
            this.rsDecoder.decode(nArray, byArray.length - n);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        n3 = 0;
        while (n3 < n) {
            byArray[n3] = (byte)nArray[n3];
            ++n3;
        }
    }
}

