/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.datamatrix.encoder;

import oz.util.barcode.datamatrix.encoder.Encoder;
import oz.util.barcode.datamatrix.encoder.EncoderContext;
import oz.util.barcode.datamatrix.encoder.HighLevelEncoder;

final class ASCIIEncoder
implements Encoder {
    ASCIIEncoder() {
    }

    @Override
    public int getEncodingMode() {
        return 0;
    }

    @Override
    public void encode(EncoderContext encoderContext) {
        block12: {
            char c2;
            block13: {
                block11: {
                    int n = HighLevelEncoder.determineConsecutiveDigitCount(encoderContext.getMessage(), encoderContext.pos);
                    if (n < 2) break block11;
                    encoderContext.writeCodeword(ASCIIEncoder.encodeASCIIDigits(encoderContext.getMessage().charAt(encoderContext.pos), encoderContext.getMessage().charAt(encoderContext.pos + 1)));
                    encoderContext.pos += 2;
                    break block12;
                }
                c2 = encoderContext.getCurrentChar();
                int n = HighLevelEncoder.lookAheadTest(encoderContext.getMessage(), encoderContext.pos, this.getEncodingMode());
                if (n == this.getEncodingMode()) break block13;
                switch (n) {
                    case 5: {
                        encoderContext.writeCodeword('\u00e7');
                        encoderContext.signalEncoderChange(5);
                        return;
                    }
                    case 1: {
                        encoderContext.writeCodeword('\u00e6');
                        encoderContext.signalEncoderChange(1);
                        return;
                    }
                    case 3: {
                        encoderContext.writeCodeword('\u00ee');
                        encoderContext.signalEncoderChange(3);
                        break block12;
                    }
                    case 2: {
                        encoderContext.writeCodeword('\u00ef');
                        encoderContext.signalEncoderChange(2);
                        break block12;
                    }
                    case 4: {
                        encoderContext.writeCodeword('\u00f0');
                        encoderContext.signalEncoderChange(4);
                        break block12;
                    }
                    default: {
                        throw new IllegalStateException("Illegal mode: " + n);
                    }
                }
            }
            if (HighLevelEncoder.isExtendedASCII(c2)) {
                encoderContext.writeCodeword('\u00eb');
                encoderContext.writeCodeword((char)(c2 - 128 + 1));
                ++encoderContext.pos;
            } else if (encoderContext.m_bGS1 && c2 == '\u007f') {
                encoderContext.writeCodeword('\u00e8');
                ++encoderContext.pos;
            } else {
                encoderContext.writeCodeword((char)(c2 + '\u0001'));
                ++encoderContext.pos;
            }
        }
    }

    private static char encodeASCIIDigits(char c2, char c3) {
        if (HighLevelEncoder.isDigit(c2) && HighLevelEncoder.isDigit(c3)) {
            int n = (c2 - 48) * 10 + (c3 - 48);
            return (char)(n + 130);
        }
        throw new IllegalArgumentException("not digits: " + c2 + c3);
    }
}

