/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.datamatrix.encoder;

import oz.util.barcode.datamatrix.encoder.Encoder;
import oz.util.barcode.datamatrix.encoder.EncoderContext;
import oz.util.barcode.datamatrix.encoder.HighLevelEncoder;

final class EdifactEncoder
implements Encoder {
    EdifactEncoder() {
    }

    @Override
    public int getEncodingMode() {
        return 4;
    }

    @Override
    public void encode(EncoderContext encoderContext) {
        StringBuilder stringBuilder = new StringBuilder();
        while (encoderContext.hasMoreCharacters()) {
            char c2 = encoderContext.getCurrentChar();
            EdifactEncoder.encodeChar(c2, stringBuilder);
            ++encoderContext.pos;
            int n = stringBuilder.length();
            if (n < 4) continue;
            encoderContext.writeCodewords(EdifactEncoder.encodeToCodewords(stringBuilder, 0));
            stringBuilder.delete(0, 4);
            int n2 = HighLevelEncoder.lookAheadTest(encoderContext.getMessage(), encoderContext.pos, this.getEncodingMode());
            if (n2 == this.getEncodingMode()) continue;
            encoderContext.signalEncoderChange(0);
            break;
        }
        stringBuilder.append('\u001f');
        EdifactEncoder.handleEOD(encoderContext, stringBuilder);
    }

    private static void handleEOD(EncoderContext encoderContext, CharSequence charSequence) {
        try {
            boolean bl;
            int n;
            int n2 = charSequence.length();
            if (n2 == 0) {
                return;
            }
            if (n2 == 1) {
                encoderContext.updateSymbolInfo();
                n = encoderContext.getSymbolInfo().getDataCapacity() - encoderContext.getCodewordCount();
                int n3 = encoderContext.getRemainingCharacters();
                if (n3 > n) {
                    encoderContext.updateSymbolInfo(encoderContext.getCodewordCount() + 1);
                    n = encoderContext.getSymbolInfo().getDataCapacity() - encoderContext.getCodewordCount();
                }
                if (n3 <= n && n <= 2) {
                    return;
                }
            }
            if (n2 > 4) {
                throw new IllegalStateException("Count must not exceed 4");
            }
            n = n2 - 1;
            String string = EdifactEncoder.encodeToCodewords(charSequence, 0);
            boolean bl2 = !encoderContext.hasMoreCharacters();
            boolean bl3 = bl = bl2 && n <= 2;
            if (n <= 2) {
                encoderContext.updateSymbolInfo(encoderContext.getCodewordCount() + n);
                int n4 = encoderContext.getSymbolInfo().getDataCapacity() - encoderContext.getCodewordCount();
                if (n4 >= 3) {
                    bl = false;
                    encoderContext.updateSymbolInfo(encoderContext.getCodewordCount() + string.length());
                }
            }
            if (bl) {
                encoderContext.resetSymbolInfo();
                encoderContext.pos -= n;
            } else {
                encoderContext.writeCodewords(string);
            }
        }
        finally {
            encoderContext.signalEncoderChange(0);
        }
    }

    private static void encodeChar(char c2, StringBuilder stringBuilder) {
        if (c2 >= ' ' && c2 <= '?') {
            stringBuilder.append(c2);
        } else if (c2 >= '@' && c2 <= '^') {
            stringBuilder.append((char)(c2 - 64));
        } else {
            HighLevelEncoder.illegalCharacter(c2);
        }
    }

    private static String encodeToCodewords(CharSequence charSequence, int n) {
        int n2 = charSequence.length() - n;
        if (n2 == 0) {
            throw new IllegalStateException("StringBuilder must not be empty");
        }
        char c2 = charSequence.charAt(n);
        char c3 = n2 >= 2 ? charSequence.charAt(n + 1) : (char)'\u0000';
        char c4 = n2 >= 3 ? charSequence.charAt(n + 2) : (char)'\u0000';
        char c5 = n2 >= 4 ? charSequence.charAt(n + 3) : (char)'\u0000';
        int n3 = (c2 << 18) + (c3 << 12) + (c4 << 6) + c5;
        char c6 = (char)(n3 >> 16 & 0xFF);
        char c7 = (char)(n3 >> 8 & 0xFF);
        char c8 = (char)(n3 & 0xFF);
        StringBuilder stringBuilder = new StringBuilder(3);
        stringBuilder.append(c6);
        if (n2 >= 2) {
            stringBuilder.append(c7);
        }
        if (n2 >= 3) {
            stringBuilder.append(c8);
        }
        return stringBuilder.toString();
    }
}

