/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.multi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oz.util.barcode.BinaryBitmap;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.Reader;
import oz.util.barcode.ReaderException;
import oz.util.barcode.Result;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.multi.MultipleBarcodeReader;

public final class GenericMultipleBarcodeReader
implements MultipleBarcodeReader {
    private static final int MIN_DIMENSION_TO_RECUR = 100;
    private static final int MAX_DEPTH = 4;
    private final Reader delegate;

    public GenericMultipleBarcodeReader(Reader reader) {
        this.delegate = reader;
    }

    @Override
    public Result[] decodeMultiple(BinaryBitmap binaryBitmap) {
        return this.decodeMultiple(binaryBitmap, null);
    }

    @Override
    public Result[] decodeMultiple(BinaryBitmap binaryBitmap, Map map) {
        ArrayList arrayList = new ArrayList();
        this.doDecodeMultiple(binaryBitmap, map, arrayList, 0, 0, 0);
        if (arrayList.isEmpty()) {
            throw NotFoundException.getNotFoundInstance();
        }
        return arrayList.toArray(new Result[arrayList.size()]);
    }

    private void doDecodeMultiple(BinaryBitmap binaryBitmap, Map map, List list, int n, int n2, int n3) {
        ResultPoint[] resultPointArray2;
        Result result;
        if (n3 > 4) {
            return;
        }
        try {
            result = this.delegate.decode(binaryBitmap, map);
        }
        catch (ReaderException readerException) {
            return;
        }
        boolean bl = false;
        for (ResultPoint[] resultPointArray2 : list) {
            if (!resultPointArray2.getText().equals(result.getText())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            list.add(GenericMultipleBarcodeReader.translateResultPoints(result, n, n2));
        }
        if ((resultPointArray2 = result.getResultPoints()) == null || resultPointArray2.length == 0) {
            return;
        }
        int n4 = binaryBitmap.getWidth();
        int n5 = binaryBitmap.getHeight();
        float f2 = n4;
        float f3 = n5;
        float f4 = 0.0f;
        float f5 = 0.0f;
        ResultPoint[] resultPointArray3 = resultPointArray2;
        int n6 = resultPointArray2.length;
        int n7 = 0;
        while (n7 < n6) {
            ResultPoint resultPoint = resultPointArray3[n7];
            if (resultPoint != null) {
                float f6 = resultPoint.getX();
                float f7 = resultPoint.getY();
                if (f6 < f2) {
                    f2 = f6;
                }
                if (f7 < f3) {
                    f3 = f7;
                }
                if (f6 > f4) {
                    f4 = f6;
                }
                if (f7 > f5) {
                    f5 = f7;
                }
            }
            ++n7;
        }
        if (f2 > 100.0f) {
            this.doDecodeMultiple(binaryBitmap.crop(0, 0, (int)f2, n5), map, list, n, n2, n3 + 1);
        }
        if (f3 > 100.0f) {
            this.doDecodeMultiple(binaryBitmap.crop(0, 0, n4, (int)f3), map, list, n, n2, n3 + 1);
        }
        if (f4 < (float)(n4 - 100)) {
            this.doDecodeMultiple(binaryBitmap.crop((int)f4, 0, n4 - (int)f4, n5), map, list, n + (int)f4, n2, n3 + 1);
        }
        if (f5 < (float)(n5 - 100)) {
            this.doDecodeMultiple(binaryBitmap.crop(0, (int)f5, n4, n5 - (int)f5), map, list, n, n2 + (int)f5, n3 + 1);
        }
    }

    private static Result translateResultPoints(Result result, int n, int n2) {
        ResultPoint[] resultPointArray = result.getResultPoints();
        if (resultPointArray == null) {
            return result;
        }
        ResultPoint[] resultPointArray2 = new ResultPoint[resultPointArray.length];
        int n3 = 0;
        while (n3 < resultPointArray.length) {
            ResultPoint resultPoint = resultPointArray[n3];
            if (resultPoint != null) {
                resultPointArray2[n3] = new ResultPoint(resultPoint.getX() + (float)n, resultPoint.getY() + (float)n2);
            }
            ++n3;
        }
        Result result2 = new Result(result.getText(), result.getRawBytes(), result.getNumBits(), resultPointArray2, result.getBarcodeFormat(), result.getTimestamp());
        result2.putAllMetadata(result.getResultMetadata());
        return result2;
    }
}

