/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.oned.Code128Reader;
import oz.util.barcode.oned.Code128Writer$CType;
import oz.util.barcode.oned.OneDimensionalCodeWriter;

public final class Code128Writer
extends OneDimensionalCodeWriter {
    private static final int CODE_START_A = 103;
    private static final int CODE_START_B = 104;
    private static final int CODE_START_C = 105;
    private static final int CODE_CODE_A = 101;
    private static final int CODE_CODE_B = 100;
    private static final int CODE_CODE_C = 99;
    private static final int CODE_STOP = 106;
    private static final char ESCAPE_FNC_1 = '\u00f1';
    private static final char ESCAPE_FNC_2 = '\u00f2';
    private static final char ESCAPE_FNC_3 = '\u00f3';
    private static final char ESCAPE_FNC_4 = '\u00f4';
    private static final int CODE_FNC_1 = 102;
    private static final int CODE_FNC_2 = 97;
    private static final int CODE_FNC_3 = 96;
    private static final int CODE_FNC_4_A = 101;
    private static final int CODE_FNC_4_B = 100;

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        if (barcodeFormat != BarcodeFormat.CODE_128) {
            throw new IllegalArgumentException("Can only encode CODE_128, but got " + (Object)((Object)barcodeFormat));
        }
        return super.encode(string, barcodeFormat, n, n2, map);
    }

    @Override
    public boolean[] encode(String string) {
        int n;
        int n2;
        int n3 = string.length();
        if (n3 < 1 || n3 > 80) {
            throw new IllegalArgumentException("Contents length should be between 1 and 80 characters, but got " + n3);
        }
        int n4 = 0;
        while (n4 < n3) {
            n2 = string.charAt(n4);
            switch (n2) {
                case 241: 
                case 242: 
                case 243: 
                case 244: {
                    break;
                }
                default: {
                    if (n2 <= 127) break;
                    throw new IllegalArgumentException("Bad character in input: " + (char)n2);
                }
            }
            ++n4;
        }
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        n2 = 0;
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            int n8;
            n = Code128Writer.chooseCode(string, n7, n6);
            if (n == n6) {
                block3 : switch (string.charAt(n7)) {
                    case '\u00f1': {
                        n8 = 102;
                        break;
                    }
                    case '\u00f2': {
                        n8 = 97;
                        break;
                    }
                    case '\u00f3': {
                        n8 = 96;
                        break;
                    }
                    case '\u00f4': {
                        if (n6 == 101) {
                            n8 = 101;
                            break;
                        }
                        n8 = 100;
                        break;
                    }
                    default: {
                        switch (n6) {
                            case 101: {
                                n8 = string.charAt(n7) - 32;
                                if (n8 >= 0) break block3;
                                n8 += 96;
                                break block3;
                            }
                            case 100: {
                                n8 = string.charAt(n7) - 32;
                                break block3;
                            }
                            default: {
                                n8 = Integer.parseInt(string.substring(n7, n7 + 2));
                                ++n7;
                            }
                        }
                    }
                }
                ++n7;
            } else {
                if (n6 == 0) {
                    switch (n) {
                        case 101: {
                            n8 = 103;
                            break;
                        }
                        case 100: {
                            n8 = 104;
                            break;
                        }
                        default: {
                            n8 = 105;
                            break;
                        }
                    }
                } else {
                    n8 = n;
                }
                n6 = n;
            }
            arrayList.add(Code128Reader.CODE_PATTERNS[n8]);
            n2 += n8 * n5;
            if (n7 == 0) continue;
            ++n5;
        }
        arrayList.add(Code128Reader.CODE_PATTERNS[n2 %= 103]);
        arrayList.add(Code128Reader.CODE_PATTERNS[106]);
        n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int[] nArray;
            int[] nArray2 = nArray = (int[])iterator.next();
            int n9 = nArray.length;
            int n10 = 0;
            while (n10 < n9) {
                int n11 = nArray2[n10];
                n += n11;
                ++n10;
            }
        }
        boolean[] blArray = new boolean[n];
        int n12 = 0;
        for (int[] nArray : arrayList) {
            n12 += Code128Writer.appendPattern(blArray, n12, nArray, true);
        }
        return blArray;
    }

    private static Code128Writer$CType findCType(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        if (n >= n2) {
            return Code128Writer$CType.UNCODABLE;
        }
        char c2 = charSequence.charAt(n);
        if (c2 == '\u00f1') {
            return Code128Writer$CType.FNC_1;
        }
        if (c2 < '0' || c2 > '9') {
            return Code128Writer$CType.UNCODABLE;
        }
        if (n + 1 >= n2) {
            return Code128Writer$CType.ONE_DIGIT;
        }
        c2 = charSequence.charAt(n + 1);
        if (c2 < '0' || c2 > '9') {
            return Code128Writer$CType.ONE_DIGIT;
        }
        return Code128Writer$CType.TWO_DIGITS;
    }

    private static int chooseCode(CharSequence charSequence, int n, int n2) {
        Code128Writer$CType code128Writer$CType = Code128Writer.findCType(charSequence, n);
        if (code128Writer$CType == Code128Writer$CType.ONE_DIGIT) {
            return 100;
        }
        if (code128Writer$CType == Code128Writer$CType.UNCODABLE) {
            char c2;
            if (n < charSequence.length() && ((c2 = charSequence.charAt(n)) < ' ' || n2 == 101 && c2 < '`')) {
                return 101;
            }
            return 100;
        }
        if (n2 == 99) {
            return 99;
        }
        if (n2 == 100) {
            if (code128Writer$CType == Code128Writer$CType.FNC_1) {
                return 100;
            }
            code128Writer$CType = Code128Writer.findCType(charSequence, n + 2);
            if (code128Writer$CType == Code128Writer$CType.UNCODABLE || code128Writer$CType == Code128Writer$CType.ONE_DIGIT) {
                return 100;
            }
            if (code128Writer$CType == Code128Writer$CType.FNC_1) {
                code128Writer$CType = Code128Writer.findCType(charSequence, n + 3);
                if (code128Writer$CType == Code128Writer$CType.TWO_DIGITS) {
                    return 99;
                }
                return 100;
            }
            int n3 = n + 4;
            while ((code128Writer$CType = Code128Writer.findCType(charSequence, n3)) == Code128Writer$CType.TWO_DIGITS) {
                n3 += 2;
            }
            if (code128Writer$CType == Code128Writer$CType.ONE_DIGIT) {
                return 100;
            }
            return 99;
        }
        if (code128Writer$CType == Code128Writer$CType.FNC_1) {
            code128Writer$CType = Code128Writer.findCType(charSequence, n + 1);
        }
        if (code128Writer$CType == Code128Writer$CType.TWO_DIGITS) {
            return 99;
        }
        return 100;
    }
}

