/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.FormatException;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.oned.UPCEANReader;
import oz.util.barcode.oned.UPCEANWriter;

public final class EAN8Writer
extends UPCEANWriter {
    private static final int CODE_WIDTH = 67;

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        if (barcodeFormat != BarcodeFormat.EAN_8) {
            throw new IllegalArgumentException("Can only encode EAN_8, but got " + (Object)((Object)barcodeFormat));
        }
        return super.encode(string, barcodeFormat, n, n2, map);
    }

    @Override
    public boolean[] encode(String string) {
        int n;
        int n2 = string.length();
        switch (n2) {
            case 7: {
                int n3;
                try {
                    n3 = UPCEANReader.getStandardUPCEANChecksum(string);
                }
                catch (FormatException formatException) {
                    throw new IllegalArgumentException(formatException);
                }
                string = String.valueOf(string) + n3;
                break;
            }
            case 8: {
                try {
                    if (UPCEANReader.checkStandardUPCEANChecksum(string)) break;
                    throw new IllegalArgumentException("Contents do not pass checksum");
                }
                catch (FormatException formatException) {
                    throw new IllegalArgumentException("Illegal contents");
                }
            }
            default: {
                throw new IllegalArgumentException("Requested contents should be 8 digits long, but got " + n2);
            }
        }
        boolean[] blArray = new boolean[67];
        int n4 = 0;
        n4 += EAN8Writer.appendPattern(blArray, n4, UPCEANReader.START_END_PATTERN, true);
        int n5 = 0;
        while (n5 <= 3) {
            n = Character.digit(string.charAt(n5), 10);
            n4 += EAN8Writer.appendPattern(blArray, n4, UPCEANReader.L_PATTERNS[n], false);
            ++n5;
        }
        n4 += EAN8Writer.appendPattern(blArray, n4, UPCEANReader.MIDDLE_PATTERN, false);
        n5 = 4;
        while (n5 <= 7) {
            n = Character.digit(string.charAt(n5), 10);
            n4 += EAN8Writer.appendPattern(blArray, n4, UPCEANReader.L_PATTERNS[n], true);
            ++n5;
        }
        EAN8Writer.appendPattern(blArray, n4, UPCEANReader.START_END_PATTERN, true);
        return blArray;
    }
}

