/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.oned.OneDimensionalCodeWriter;

public final class ITFWriter
extends OneDimensionalCodeWriter {
    private static final int[] START_PATTERN = new int[]{1, 1, 1, 1};
    private static final int[] END_PATTERN = new int[]{3, 1, 1};
    private static final int W = 3;
    private static final int N = 1;
    private static final int[][] PATTERNS = new int[][]{{1, 1, 3, 3, 1}, {3, 1, 1, 1, 3}, {1, 3, 1, 1, 3}, {3, 3, 1, 1, 1}, {1, 1, 3, 1, 3}, {3, 1, 3, 1, 1}, {1, 3, 3, 1, 1}, {1, 1, 1, 3, 3}, {3, 1, 1, 3, 1}, {1, 3, 1, 3, 1}};

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        if (barcodeFormat != BarcodeFormat.ITF) {
            throw new IllegalArgumentException("Can only encode ITF, but got " + (Object)((Object)barcodeFormat));
        }
        return super.encode(string, barcodeFormat, n, n2, map);
    }

    @Override
    public boolean[] encode(String string) {
        int n = string.length();
        if (n % 2 != 0) {
            throw new IllegalArgumentException("The length of the input should be even");
        }
        if (n > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + n);
        }
        boolean[] blArray = new boolean[9 + 9 * n];
        int n2 = ITFWriter.appendPattern(blArray, 0, START_PATTERN, true);
        int n3 = 0;
        while (n3 < n) {
            int n4 = Character.digit(string.charAt(n3), 10);
            int n5 = Character.digit(string.charAt(n3 + 1), 10);
            int[] nArray = new int[10];
            int n6 = 0;
            while (n6 < 5) {
                nArray[2 * n6] = PATTERNS[n4][n6];
                nArray[2 * n6 + 1] = PATTERNS[n5][n6];
                ++n6;
            }
            n2 += ITFWriter.appendPattern(blArray, n2, nArray, true);
            n3 += 2;
        }
        ITFWriter.appendPattern(blArray, n2, END_PATTERN, true);
        return blArray;
    }
}

