/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.DecodeHintType;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.ReaderException;
import oz.util.barcode.Result;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.oned.EAN13Reader;
import oz.util.barcode.oned.EAN8Reader;
import oz.util.barcode.oned.OneDReader;
import oz.util.barcode.oned.UPCAReader;
import oz.util.barcode.oned.UPCEANReader;
import oz.util.barcode.oned.UPCEReader;

public final class MultiFormatUPCEANReader
extends OneDReader {
    private final UPCEANReader[] readers;

    public MultiFormatUPCEANReader(Map map) {
        Collection collection = map == null ? null : (Collection)map.get((Object)DecodeHintType.POSSIBLE_FORMATS);
        ArrayList<UPCEANReader> arrayList = new ArrayList<UPCEANReader>();
        if (collection != null) {
            if (collection.contains((Object)BarcodeFormat.EAN_13)) {
                arrayList.add(new EAN13Reader());
            } else if (collection.contains((Object)BarcodeFormat.UPC_A)) {
                arrayList.add(new UPCAReader());
            }
            if (collection.contains((Object)BarcodeFormat.EAN_8)) {
                arrayList.add(new EAN8Reader());
            }
            if (collection.contains((Object)BarcodeFormat.UPC_E)) {
                arrayList.add(new UPCEReader());
            }
        }
        if (arrayList.isEmpty()) {
            arrayList.add(new EAN13Reader());
            arrayList.add(new EAN8Reader());
            arrayList.add(new UPCEReader());
        }
        this.readers = arrayList.toArray(new UPCEANReader[arrayList.size()]);
    }

    @Override
    public Result decodeRow(int n, BitArray bitArray, Map map) {
        int[] nArray = UPCEANReader.findStartGuardPattern(bitArray);
        UPCEANReader[] uPCEANReaderArray = this.readers;
        int n2 = this.readers.length;
        int n3 = 0;
        while (n3 < n2) {
            UPCEANReader uPCEANReader = uPCEANReaderArray[n3];
            try {
                boolean bl;
                Result result = uPCEANReader.decodeRow(n, bitArray, nArray, map);
                boolean bl2 = result.getBarcodeFormat() == BarcodeFormat.EAN_13 && result.getText().charAt(0) == '0';
                Collection collection = map == null ? null : (Collection)map.get((Object)DecodeHintType.POSSIBLE_FORMATS);
                boolean bl3 = bl = collection == null || collection.contains((Object)BarcodeFormat.UPC_A);
                if (bl2 && bl) {
                    Result result2 = new Result(result.getText().substring(1), result.getRawBytes(), result.getResultPoints(), BarcodeFormat.UPC_A);
                    result2.putAllMetadata(result.getResultMetadata());
                    return result2;
                }
                return result;
            }
            catch (ReaderException readerException) {
                ++n3;
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public void reset() {
        UPCEANReader[] uPCEANReaderArray = this.readers;
        int n = this.readers.length;
        int n2 = 0;
        while (n2 < n) {
            UPCEANReader uPCEANReader = uPCEANReaderArray[n2];
            uPCEANReader.reset();
            ++n2;
        }
    }
}

