/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.EnumMap;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.Result;
import oz.util.barcode.ResultMetadataType;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.oned.UPCEANReader;

final class UPCEANExtension2Support {
    private final int[] decodeMiddleCounters = new int[4];
    private final StringBuilder decodeRowStringBuffer = new StringBuilder();

    UPCEANExtension2Support() {
    }

    Result decodeRow(int n, BitArray bitArray, int[] nArray) {
        StringBuilder stringBuilder = this.decodeRowStringBuffer;
        stringBuilder.setLength(0);
        int n2 = this.decodeMiddle(bitArray, nArray, stringBuilder);
        String string = stringBuilder.toString();
        Map map = UPCEANExtension2Support.parseExtensionString(string);
        Result result = new Result(string, null, new ResultPoint[]{new ResultPoint((float)(nArray[0] + nArray[1]) / 2.0f, n), new ResultPoint(n2, n)}, BarcodeFormat.UPC_EAN_EXTENSION);
        if (map != null) {
            result.putAllMetadata(map);
        }
        return result;
    }

    private int decodeMiddle(BitArray bitArray, int[] nArray, StringBuilder stringBuilder) {
        int[] nArray2 = this.decodeMiddleCounters;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        nArray2[3] = 0;
        int n = bitArray.getSize();
        int n2 = nArray[1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < 2 && n2 < n) {
            int n5 = UPCEANReader.decodeDigit(bitArray, nArray2, n2, UPCEANReader.L_AND_G_PATTERNS);
            stringBuilder.append((char)(48 + n5 % 10));
            int[] nArray3 = nArray2;
            int n6 = nArray2.length;
            int n7 = 0;
            while (n7 < n6) {
                int n8 = nArray3[n7];
                n2 += n8;
                ++n7;
            }
            if (n5 >= 10) {
                n3 |= 1 << 1 - n4;
            }
            if (n4 != 1) {
                n2 = bitArray.getNextSet(n2);
                n2 = bitArray.getNextUnset(n2);
            }
            ++n4;
        }
        if (stringBuilder.length() != 2) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (Integer.parseInt(stringBuilder.toString()) % 4 != n3) {
            throw NotFoundException.getNotFoundInstance();
        }
        return n2;
    }

    private static Map parseExtensionString(String string) {
        if (string.length() != 2) {
            return null;
        }
        EnumMap<ResultMetadataType, Integer> enumMap = new EnumMap<ResultMetadataType, Integer>(ResultMetadataType.class);
        enumMap.put(ResultMetadataType.ISSUE_NUMBER, Integer.valueOf(string));
        return enumMap;
    }
}

