/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.FormatException;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.oned.UPCEANReader;
import oz.util.barcode.oned.UPCEANWriter;
import oz.util.barcode.oned.UPCEReader;

public final class UPCEWriter
extends UPCEANWriter {
    private static final int CODE_WIDTH = 51;

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        if (barcodeFormat != BarcodeFormat.UPC_E) {
            throw new IllegalArgumentException("Can only encode UPC_E, but got " + (Object)((Object)barcodeFormat));
        }
        return super.encode(string, barcodeFormat, n, n2, map);
    }

    @Override
    public boolean[] encode(String string) {
        int n;
        int n2 = string.length();
        switch (n2) {
            case 7: {
                try {
                    n = UPCEANReader.getStandardUPCEANChecksum(UPCEReader.convertUPCEtoUPCA(string));
                }
                catch (FormatException formatException) {
                    throw new IllegalArgumentException(formatException);
                }
                string = String.valueOf(string) + n;
                break;
            }
            case 8: {
                try {
                    if (UPCEANReader.checkStandardUPCEANChecksum(string)) break;
                    throw new IllegalArgumentException("Contents do not pass checksum");
                }
                catch (FormatException formatException) {
                    throw new IllegalArgumentException("Illegal contents");
                }
            }
            default: {
                throw new IllegalArgumentException("Requested contents should be 8 digits long, but got " + n2);
            }
        }
        n = Character.digit(string.charAt(0), 10);
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Number system must be 0 or 1");
        }
        int n3 = Character.digit(string.charAt(7), 10);
        int n4 = UPCEReader.NUMSYS_AND_CHECK_DIGIT_PATTERNS[n][n3];
        boolean[] blArray = new boolean[51];
        int n5 = 0;
        n5 += UPCEWriter.appendPattern(blArray, n5, UPCEANReader.START_END_PATTERN, true);
        int n6 = 1;
        while (n6 <= 6) {
            int n7 = Character.digit(string.charAt(n6), 10);
            if ((n4 >> 6 - n6 & 1) == 1) {
                n7 += 10;
            }
            n5 += UPCEWriter.appendPattern(blArray, n5, UPCEANReader.L_AND_G_PATTERNS[n7], false);
            ++n6;
        }
        UPCEWriter.appendPattern(blArray, n5, UPCEANReader.END_PATTERN, false);
        return blArray;
    }
}

