/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned.rss;

import oz.util.barcode.NotFoundException;
import oz.util.barcode.common.detector.MathUtils;
import oz.util.barcode.oned.OneDReader;

public abstract class AbstractRSSReader
extends OneDReader {
    private static final float MAX_AVG_VARIANCE = 0.2f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.45f;
    private static final float MIN_FINDER_PATTERN_RATIO = 0.7916667f;
    private static final float MAX_FINDER_PATTERN_RATIO = 0.89285713f;
    private final int[] decodeFinderCounters = new int[4];
    private final int[] dataCharacterCounters = new int[8];
    private final float[] oddRoundingErrors = new float[4];
    private final float[] evenRoundingErrors = new float[4];
    private final int[] oddCounts = new int[this.dataCharacterCounters.length / 2];
    private final int[] evenCounts = new int[this.dataCharacterCounters.length / 2];

    protected AbstractRSSReader() {
    }

    protected final int[] getDecodeFinderCounters() {
        return this.decodeFinderCounters;
    }

    protected final int[] getDataCharacterCounters() {
        return this.dataCharacterCounters;
    }

    protected final float[] getOddRoundingErrors() {
        return this.oddRoundingErrors;
    }

    protected final float[] getEvenRoundingErrors() {
        return this.evenRoundingErrors;
    }

    protected final int[] getOddCounts() {
        return this.oddCounts;
    }

    protected final int[] getEvenCounts() {
        return this.evenCounts;
    }

    protected static int parseFinderValue(int[] nArray, int[][] nArray2) {
        int n = 0;
        while (n < nArray2.length) {
            if (AbstractRSSReader.patternMatchVariance(nArray, nArray2[n], 0.45f) < 0.2f) {
                return n;
            }
            ++n;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    protected static int count(int[] nArray) {
        return MathUtils.sum(nArray);
    }

    protected static void increment(int[] nArray, float[] fArray) {
        int n = 0;
        float f2 = fArray[0];
        int n2 = 1;
        while (n2 < nArray.length) {
            if (fArray[n2] > f2) {
                f2 = fArray[n2];
                n = n2;
            }
            ++n2;
        }
        int n3 = n;
        nArray[n3] = nArray[n3] + 1;
    }

    protected static void decrement(int[] nArray, float[] fArray) {
        int n = 0;
        float f2 = fArray[0];
        int n2 = 1;
        while (n2 < nArray.length) {
            if (fArray[n2] < f2) {
                f2 = fArray[n2];
                n = n2;
            }
            ++n2;
        }
        int n3 = n;
        nArray[n3] = nArray[n3] - 1;
    }

    protected static boolean isFinderPattern(int[] nArray) {
        int n = nArray[0] + nArray[1];
        int n2 = n + nArray[2] + nArray[3];
        float f2 = (float)n / (float)n2;
        if (f2 >= 0.7916667f && f2 <= 0.89285713f) {
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MIN_VALUE;
            int[] nArray2 = nArray;
            int n5 = nArray.length;
            int n6 = 0;
            while (n6 < n5) {
                int n7 = nArray2[n6];
                if (n7 > n4) {
                    n4 = n7;
                }
                if (n7 < n3) {
                    n3 = n7;
                }
                ++n6;
            }
            return n4 < 10 * n3;
        }
        return false;
    }
}

