/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.pdf417.decoder;

import oz.util.barcode.NotFoundException;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.BitMatrix;

final class BoundingBox {
    private final BitMatrix image;
    private final ResultPoint topLeft;
    private final ResultPoint bottomLeft;
    private final ResultPoint topRight;
    private final ResultPoint bottomRight;
    private final int minX;
    private final int maxX;
    private final int minY;
    private final int maxY;

    BoundingBox(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4) {
        boolean bl;
        boolean bl2 = resultPoint == null || resultPoint2 == null;
        boolean bl3 = bl = resultPoint3 == null || resultPoint4 == null;
        if (bl2 && bl) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (bl2) {
            resultPoint = new ResultPoint(0.0f, resultPoint3.getY());
            resultPoint2 = new ResultPoint(0.0f, resultPoint4.getY());
        } else if (bl) {
            resultPoint3 = new ResultPoint(bitMatrix.getWidth() - 1, resultPoint.getY());
            resultPoint4 = new ResultPoint(bitMatrix.getWidth() - 1, resultPoint2.getY());
        }
        this.image = bitMatrix;
        this.topLeft = resultPoint;
        this.bottomLeft = resultPoint2;
        this.topRight = resultPoint3;
        this.bottomRight = resultPoint4;
        this.minX = (int)Math.min(resultPoint.getX(), resultPoint2.getX());
        this.maxX = (int)Math.max(resultPoint3.getX(), resultPoint4.getX());
        this.minY = (int)Math.min(resultPoint.getY(), resultPoint3.getY());
        this.maxY = (int)Math.max(resultPoint2.getY(), resultPoint4.getY());
    }

    BoundingBox(BoundingBox boundingBox) {
        this.image = boundingBox.image;
        this.topLeft = boundingBox.getTopLeft();
        this.bottomLeft = boundingBox.getBottomLeft();
        this.topRight = boundingBox.getTopRight();
        this.bottomRight = boundingBox.getBottomRight();
        this.minX = boundingBox.getMinX();
        this.maxX = boundingBox.getMaxX();
        this.minY = boundingBox.getMinY();
        this.maxY = boundingBox.getMaxY();
    }

    static BoundingBox merge(BoundingBox boundingBox, BoundingBox boundingBox2) {
        if (boundingBox == null) {
            return boundingBox2;
        }
        if (boundingBox2 == null) {
            return boundingBox;
        }
        return new BoundingBox(boundingBox.image, boundingBox.topLeft, boundingBox.bottomLeft, boundingBox2.topRight, boundingBox2.bottomRight);
    }

    BoundingBox addMissingRows(int n, int n2, boolean bl) {
        ResultPoint resultPoint;
        int n3;
        ResultPoint resultPoint2;
        ResultPoint resultPoint3 = this.topLeft;
        ResultPoint resultPoint4 = this.bottomLeft;
        ResultPoint resultPoint5 = this.topRight;
        ResultPoint resultPoint6 = this.bottomRight;
        if (n > 0) {
            resultPoint2 = bl ? this.topLeft : this.topRight;
            n3 = (int)resultPoint2.getY() - n;
            if (n3 < 0) {
                n3 = 0;
            }
            resultPoint = new ResultPoint(resultPoint2.getX(), n3);
            if (bl) {
                resultPoint3 = resultPoint;
            } else {
                resultPoint5 = resultPoint;
            }
        }
        if (n2 > 0) {
            resultPoint2 = bl ? this.bottomLeft : this.bottomRight;
            n3 = (int)resultPoint2.getY() + n2;
            if (n3 >= this.image.getHeight()) {
                n3 = this.image.getHeight() - 1;
            }
            resultPoint = new ResultPoint(resultPoint2.getX(), n3);
            if (bl) {
                resultPoint4 = resultPoint;
            } else {
                resultPoint6 = resultPoint;
            }
        }
        return new BoundingBox(this.image, resultPoint3, resultPoint4, resultPoint5, resultPoint6);
    }

    int getMinX() {
        return this.minX;
    }

    int getMaxX() {
        return this.maxX;
    }

    int getMinY() {
        return this.minY;
    }

    int getMaxY() {
        return this.maxY;
    }

    ResultPoint getTopLeft() {
        return this.topLeft;
    }

    ResultPoint getTopRight() {
        return this.topRight;
    }

    ResultPoint getBottomLeft() {
        return this.bottomLeft;
    }

    ResultPoint getBottomRight() {
        return this.bottomRight;
    }
}

