/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.pdf417.decoder;

import java.util.Formatter;
import oz.util.barcode.pdf417.decoder.BoundingBox;
import oz.util.barcode.pdf417.decoder.Codeword;

class DetectionResultColumn {
    private static final int MAX_NEARBY_DISTANCE = 5;
    private final BoundingBox boundingBox;
    private final Codeword[] codewords;

    DetectionResultColumn(BoundingBox boundingBox) {
        this.boundingBox = new BoundingBox(boundingBox);
        this.codewords = new Codeword[boundingBox.getMaxY() - boundingBox.getMinY() + 1];
    }

    final Codeword getCodewordNearby(int n) {
        Codeword codeword = this.getCodeword(n);
        if (codeword != null) {
            return codeword;
        }
        int n2 = 1;
        while (n2 < 5) {
            int n3 = this.imageRowToCodewordIndex(n) - n2;
            if (n3 >= 0 && (codeword = this.codewords[n3]) != null) {
                return codeword;
            }
            n3 = this.imageRowToCodewordIndex(n) + n2;
            if (n3 < this.codewords.length && (codeword = this.codewords[n3]) != null) {
                return codeword;
            }
            ++n2;
        }
        return null;
    }

    final int imageRowToCodewordIndex(int n) {
        return n - this.boundingBox.getMinY();
    }

    final void setCodeword(int n, Codeword codeword) {
        this.codewords[this.imageRowToCodewordIndex((int)n)] = codeword;
    }

    final Codeword getCodeword(int n) {
        return this.codewords[this.imageRowToCodewordIndex(n)];
    }

    final BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    final Codeword[] getCodewords() {
        return this.codewords;
    }

    public String toString() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Formatter formatter = new Formatter();){
            int n = 0;
            Codeword[] codewordArray = this.codewords;
            int n2 = this.codewords.length;
            int n3 = 0;
            while (n3 < n2) {
                Codeword codeword = codewordArray[n3];
                if (codeword == null) {
                    formatter.format("%3d:    |   %n", n++);
                } else {
                    formatter.format("%3d: %3d|%3d%n", n++, codeword.getRowNumber(), codeword.getValue());
                }
                ++n3;
            }
            return formatter.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

