/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.qrcode;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.EncodeHintType;
import oz.util.barcode.Writer;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.qrcode.decoder.ErrorCorrectionLevel;
import oz.util.barcode.qrcode.encoder.ByteMatrix;
import oz.util.barcode.qrcode.encoder.Encoder;
import oz.util.barcode.qrcode.encoder.QRCode;

public final class QRCodeWriter
implements Writer {
    private static final int QUIET_ZONE_SIZE = 4;

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2) {
        return this.encode(string, barcodeFormat, n, n2, null);
    }

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (barcodeFormat != BarcodeFormat.QR_CODE) {
            throw new IllegalArgumentException("Can only encode QR_CODE, but got " + (Object)((Object)barcodeFormat));
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Requested dimensions are too small: " + n + 'x' + n2);
        }
        ErrorCorrectionLevel errorCorrectionLevel = ErrorCorrectionLevel.L;
        int n3 = 4;
        if (map != null) {
            if (map.containsKey((Object)EncodeHintType.ERROR_CORRECTION)) {
                errorCorrectionLevel = ErrorCorrectionLevel.valueOf(map.get((Object)EncodeHintType.ERROR_CORRECTION).toString());
            }
            if (map.containsKey((Object)EncodeHintType.MARGIN)) {
                n3 = Integer.parseInt(map.get((Object)EncodeHintType.MARGIN).toString());
            }
        }
        QRCode qRCode = Encoder.encode(string, errorCorrectionLevel, map);
        return QRCodeWriter.renderResult(qRCode.getMatrix(), n, n2, n3);
    }

    public static BitMatrix renderResult(ByteMatrix byteMatrix, int n, int n2, int n3) {
        int n4 = byteMatrix.getWidth();
        int n5 = byteMatrix.getHeight();
        int n6 = n4;
        int n7 = n5;
        int n8 = Math.max(n, n6);
        int n9 = Math.max(n2, n7);
        int n10 = Math.min(n8 / n6, n9 / n7);
        n8 = n4 * n10;
        n9 = n5 * n10;
        if (n < 29 + n3 * 2) {
            n3 = (n - 29) / 2;
            n10 = 1;
            n8 = n4;
            n9 = n5;
        }
        if (n2 < 29 + n3 * 2) {
            n3 = (n2 - 29) / 2;
            n10 = 1;
            n8 = n4;
            n9 = n5;
        }
        int n11 = n8 * n3 / (Math.min(n, n2) - 2 * n3);
        int n12 = n11;
        int n13 = n11;
        BitMatrix bitMatrix = new BitMatrix(n8 += n11 * 2, n9 += n11 * 2);
        int n14 = 0;
        int n15 = n13;
        while (n14 < n5) {
            int n16 = 0;
            int n17 = n12;
            while (n16 < n4) {
                if (byteMatrix.get(n16, n14) == 1) {
                    bitMatrix.setRegion(n17, n15, n10, n10);
                }
                ++n16;
                n17 += n10;
            }
            ++n14;
            n15 += n10;
        }
        return bitMatrix;
    }
}

