/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.qrcode.decoder;

import java.util.Map;
import oz.util.barcode.ChecksumException;
import oz.util.barcode.FormatException;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.common.DecoderResult;
import oz.util.barcode.common.reedsolomon.GenericGF;
import oz.util.barcode.common.reedsolomon.ReedSolomonDecoder;
import oz.util.barcode.common.reedsolomon.ReedSolomonException;
import oz.util.barcode.qrcode.decoder.BitMatrixParser;
import oz.util.barcode.qrcode.decoder.DataBlock;
import oz.util.barcode.qrcode.decoder.DecodedBitStreamParser;
import oz.util.barcode.qrcode.decoder.ErrorCorrectionLevel;
import oz.util.barcode.qrcode.decoder.QRCodeDecoderMetaData;
import oz.util.barcode.qrcode.decoder.Version;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.QR_CODE_FIELD_256);

    public DecoderResult decode(boolean[][] blArray) {
        return this.decode(blArray, null);
    }

    public DecoderResult decode(boolean[][] blArray, Map map) {
        return this.decode(BitMatrix.parse(blArray), map);
    }

    public DecoderResult decode(BitMatrix bitMatrix) {
        return this.decode(bitMatrix, null);
    }

    public DecoderResult decode(BitMatrix bitMatrix, Map map) {
        BitMatrixParser bitMatrixParser = new BitMatrixParser(bitMatrix);
        FormatException formatException = null;
        ChecksumException checksumException = null;
        try {
            return this.decode(bitMatrixParser, map);
        }
        catch (FormatException formatException2) {
            formatException = formatException2;
        }
        catch (ChecksumException checksumException2) {
            checksumException = checksumException2;
        }
        try {
            bitMatrixParser.remask();
            bitMatrixParser.setMirror(true);
            bitMatrixParser.readVersion();
            bitMatrixParser.readFormatInformation();
            bitMatrixParser.mirror();
            DecoderResult decoderResult = this.decode(bitMatrixParser, map);
            decoderResult.setOther(new QRCodeDecoderMetaData(true));
            return decoderResult;
        }
        catch (ChecksumException | FormatException readerException) {
            if (formatException != null) {
                throw formatException;
            }
            throw checksumException;
        }
    }

    private DecoderResult decode(BitMatrixParser bitMatrixParser, Map map) {
        Object object;
        Version version = bitMatrixParser.readVersion();
        ErrorCorrectionLevel errorCorrectionLevel = bitMatrixParser.readFormatInformation().getErrorCorrectionLevel();
        byte[] byArray = bitMatrixParser.readCodewords();
        DataBlock[] dataBlockArray = DataBlock.getDataBlocks(byArray, version, errorCorrectionLevel);
        int n = 0;
        DataBlock[] dataBlockArray2 = dataBlockArray;
        int n2 = dataBlockArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = dataBlockArray2[n3];
            n += ((DataBlock)object).getNumDataCodewords();
            ++n3;
        }
        object = new byte[n];
        n3 = 0;
        DataBlock[] dataBlockArray3 = dataBlockArray;
        int n4 = dataBlockArray.length;
        int n5 = 0;
        while (n5 < n4) {
            DataBlock dataBlock = dataBlockArray3[n5];
            byte[] byArray2 = dataBlock.getCodewords();
            int n6 = dataBlock.getNumDataCodewords();
            this.correctErrors(byArray2, n6);
            int n7 = 0;
            while (n7 < n6) {
                object[n3++] = byArray2[n7];
                ++n7;
            }
            ++n5;
        }
        return DecodedBitStreamParser.decode((byte[])object, version, errorCorrectionLevel, map);
    }

    private void correctErrors(byte[] byArray, int n) {
        int n2 = byArray.length;
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = byArray[n3] & 0xFF;
            ++n3;
        }
        try {
            this.rsDecoder.decode(nArray, byArray.length - n);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        n3 = 0;
        while (n3 < n) {
            byArray[n3] = (byte)nArray[n3];
            ++n3;
        }
    }
}

