/*
 * Decompiled with CFR 0.152.
 */
package oz.util.handwrite;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Picture;
import android.os.Handler;
import android.view.MotionEvent;
import android.widget.FrameLayout;
import java.util.Timer;
import java.util.TimerTask;
import oz.main.OZPageView;
import oz.util.handwrite.OZRVHWView$1;
import oz.util.handwrite.OZRVHWView$2;
import oz.util.handwrite.OZRVHWView$3;
import oz.viewer.ui.df.ctrl.DFEFormBotCtrl;

public class OZRVHWView
extends FrameLayout {
    private Handler handler = new OZRVHWView$1(this);
    private OZPageView pageView = null;
    private Timer timer;
    private Picture mBitmap = new Picture();
    int m_imageWidth = 0;
    int m_imageHeight = 0;
    boolean m_needsDisplay = false;
    boolean m_enable = false;
    DFEFormBotCtrl mEFormBotCtrl;

    public native void nativeOnDrawCurrentStroke(Canvas var1);

    public native boolean nativeTouchStart(long var1, float var3, float var4, float var5);

    public native boolean nativeTouchMove(long var1, float var3, float var4, float var5);

    public native boolean nativeTouchEnd(long var1, float var3, float var4, float var5);

    public native boolean nativeIsHandWriteMode();

    public native void nativeNotifyClearTimer();

    public native void nativeEFormbotResult(int var1, String var2, String var3, String var4);

    public OZRVHWView(Context context) {
        super(context);
        this.setWillNotDraw(false);
    }

    public void eFormbotInit(String string, String string2, String string3) {
        this.mEFormBotCtrl = new DFEFormBotCtrl(string, string3);
        this.mEFormBotCtrl.setUseOnlyValue(true);
        OZRVHWView$2 oZRVHWView$2 = new OZRVHWView$2(this);
        this.mEFormBotCtrl.setOnResultListener(oZRVHWView$2);
    }

    public Canvas startBitmapCanvas() {
        if (this.mBitmap != null) {
            Canvas canvas = this.mBitmap.beginRecording(this.m_imageWidth, this.m_imageHeight);
            return canvas;
        }
        return null;
    }

    public void endBitmapCanvas() {
        if (this.mBitmap != null) {
            this.mBitmap.endRecording();
        }
    }

    public void dispose() {
        this.mBitmap = null;
        this.pageView = null;
        if (this.mEFormBotCtrl != null) {
            this.mEFormBotCtrl.setOnResultListener(null);
            this.mEFormBotCtrl.cancelAll();
            this.mEFormBotCtrl = null;
        }
    }

    public void setNeedsDisplay() {
        if (!this.m_needsDisplay) {
            this.postInvalidate();
            this.m_needsDisplay = true;
        }
    }

    public void viewEnable() {
        this.m_enable = true;
    }

    public void viewDisable() {
        this.m_enable = false;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.m_imageWidth = n;
        this.m_imageHeight = n2;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.pageView != null) {
            if (this.mBitmap != null) {
                canvas.drawPicture(this.mBitmap);
            }
            this.nativeOnDrawCurrentStroke(canvas);
        }
        this.m_needsDisplay = false;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return this.touchEvent(motionEvent);
    }

    public void setPageView(OZPageView oZPageView) {
        this.pageView = oZPageView;
    }

    public int getViewWidth() {
        return this.getWidth();
    }

    public int getViewHeight() {
        return this.getHeight();
    }

    public boolean touchEvent(MotionEvent motionEvent) {
        boolean bl = motionEvent.getToolType(0) == 2;
        boolean bl2 = this.nativeIsHandWriteMode();
        if (this.m_enable && bl2) {
            if (bl) {
                float f2 = motionEvent.getX();
                float f3 = motionEvent.getY();
                float f4 = motionEvent.getPressure();
                long l = System.currentTimeMillis();
                boolean bl3 = false;
                switch (motionEvent.getAction()) {
                    case 0: {
                        bl3 = this.nativeTouchStart(l, f2, f3, f4);
                        break;
                    }
                    case 2: {
                        bl3 = this.nativeTouchMove(l, f2, f3, f4);
                        break;
                    }
                    case 1: 
                    case 3: {
                        bl3 = this.nativeTouchEnd(l, f2, f3, f4);
                    }
                }
                this.invalidate();
                return bl3;
            }
            this.nativeNotifyClearTimer();
            this.invalidate();
        }
        return false;
    }

    private void invalidateClearTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private void setClearTimer(int n) {
        this.handler.removeMessages(0);
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        OZRVHWView$3 oZRVHWView$3 = new OZRVHWView$3(this);
        this.timer.schedule((TimerTask)oZRVHWView$3, n);
    }

    private void drawRect(int n, int n2, int n3, int n4) {
        this.m_imageWidth = n3 - n;
        this.m_imageHeight = n4 - n2;
    }

    private void drawClear() {
        this.startBitmapCanvas();
        this.endBitmapCanvas();
        this.invalidate();
    }

    private void eFormbotCancelAll() {
        if (this.mEFormBotCtrl != null) {
            this.mEFormBotCtrl.cancelAll();
        }
    }

    private boolean eFormbotAvailable() {
        return this.mEFormBotCtrl != null && this.mEFormBotCtrl.getToken().length() > 0;
    }

    private void eFormbotQuery(int n, String string) {
        if (this.mEFormBotCtrl != null) {
            this.mEFormBotCtrl.eformRequestRecognition(string, n);
        }
    }

    static /* synthetic */ Handler access$000(OZRVHWView oZRVHWView) {
        return oZRVHWView.handler;
    }
}

