/*
 * Decompiled with CFR 0.152.
 */
package oz.util.signpath;

import android.graphics.Path;
import oz.util.signpath.OZSignPathMeta;

public class OZSignPath {
    private long pPath;
    private OZSignPathMeta mMeta;

    private native long nativeAllocPath(String var1, String var2);

    private native void nativeDeallocPath(long var1);

    private native String nativeGetPathMeta(long var1);

    private native void nativeMoveTo(long var1, float var3, float var4, float var5, long var6);

    private native void nativeLineTo(long var1, float var3, float var4, float var5, long var6);

    private native void nativeRenderPath(long var1, Path var3, float var4, float var5, float var6, float var7, float var8);

    private native int nativeEraseTo(long var1, float var3, float var4, float var5, float var6);

    private native boolean nativeRestoreFitToFrame(long var1);

    private native boolean nativeMakeFrameInfoFitToFrame(long var1, float var3, float var4, float var5, float var6);

    private native boolean nativeMakeFitToFrame(long var1);

    private native boolean nativeMakeKeepRatio(long var1, float var3, float var4);

    private native String nativeGetPathString(long var1, String var3);

    private native boolean nativeEmptyPath(long var1);

    public OZSignPath(OZSignPathMeta oZSignPathMeta) {
        this(null, oZSignPathMeta);
    }

    public OZSignPath(String string) {
        this(string, null);
    }

    public OZSignPath(String string, OZSignPathMeta oZSignPathMeta) {
        String string2 = null;
        if (oZSignPathMeta != null) {
            string2 = oZSignPathMeta.getChangedAttrJSON();
        }
        this.allocPath(string, string2);
    }

    private void allocPath(String string, String string2) {
        this.pPath = this.nativeAllocPath(string, string2);
        this.updateMeta();
    }

    private void deallocPath() {
        if (this.hasPath()) {
            this.nativeDeallocPath(this.pPath);
        }
        this.pPath = 0L;
        this.mMeta = null;
    }

    public boolean hasPath() {
        return this.pPath != 0L;
    }

    public OZSignPathMeta getMeta() {
        return this.mMeta;
    }

    private void updateMeta() {
        this.mMeta = OZSignPathMeta.parse(this.nativeGetPathMeta(this.pPath)).setImmutable();
    }

    public void moveTo(float f2, float f3, float f4, long l) {
        if (this.pPath != 0L) {
            this.nativeMoveTo(this.pPath, f2, f3, f4, l);
        }
    }

    public void lineTo(float f2, float f3, float f4, long l) {
        if (this.pPath != 0L) {
            this.nativeLineTo(this.pPath, f2, f3, f4, l);
        }
    }

    public void renderPath(Path path, float f2, float f3, float f4, float f5, float f6) {
        if (this.pPath != 0L) {
            this.nativeRenderPath(this.pPath, path, f2, f3, f4, f5, f6);
        }
    }

    public int eraseTo(float f2, float f3, float f4, float f5) {
        int n = 0;
        if (this.pPath != 0L) {
            n = this.nativeEraseTo(this.pPath, f2, f3, f4, f5);
        }
        return n;
    }

    public boolean toRestoreFitToFrame() {
        if (this.pPath != 0L && this.nativeRestoreFitToFrame(this.pPath)) {
            this.updateMeta();
            return true;
        }
        return false;
    }

    public boolean toFrameInfoFitToFrame(float f2, float f3, float f4, float f5) {
        if (this.pPath != 0L && this.nativeMakeFrameInfoFitToFrame(this.pPath, f2, f3, f4, f5)) {
            this.updateMeta();
            return true;
        }
        return false;
    }

    public boolean toFitToFrame() {
        if (this.pPath != 0L && this.nativeMakeFitToFrame(this.pPath)) {
            this.updateMeta();
            return true;
        }
        return false;
    }

    public boolean toKeepRatio(float f2, float f3) {
        if (this.pPath != 0L && this.nativeMakeKeepRatio(this.pPath, f2, f3)) {
            this.updateMeta();
            return true;
        }
        return false;
    }

    public String getPathString() {
        return this.getPathString(null);
    }

    public String getPathString(String string) {
        if (this.pPath != 0L) {
            return this.nativeGetPathString(this.pPath, string);
        }
        return null;
    }

    public boolean isRecycled() {
        return this.pPath == 0L;
    }

    public boolean isEmptyPath() {
        if (this.pPath != 0L) {
            return this.nativeEmptyPath(this.pPath);
        }
        return true;
    }

    public void recycle() {
        this.deallocPath();
    }

    public OZSignPath copy() {
        if (this.pPath != 0L) {
            return new OZSignPath(this.getPathString(null));
        }
        return null;
    }

    public OZSignPath copyWithMeta(OZSignPathMeta oZSignPathMeta) {
        if (this.pPath != 0L) {
            return new OZSignPath(this.getPathString(null), oZSignPathMeta);
        }
        return null;
    }

    protected void finalize() {
        this.recycle();
        super.finalize();
    }
}

