/*
 * Decompiled with CFR 0.152.
 */
package oz.util.signpath.view.model;

import android.graphics.Bitmap;
import oz.util.signpath.OZSignPath;
import oz.util.signpath.OZSignPathMeta;
import oz.util.signpath.view.model.ISignPathEditableValue;
import oz.util.signpath.view.model.ISignPathValue;
import oz.util.signpath.view.util.OZBase64Loader;

public class SignPathValue
implements ISignPathEditableValue {
    public static final int TYPE_EMPTY = 0;
    public static final int TYPE_SIGN_PATH = 16;
    public static final int TYPE_BITMAP = 32;
    private int mType = 0;
    private Object mObj;
    private Bitmap mBitmap;
    private OZSignPath mPath;
    private OZSignPath mEditablePath;
    private float mEditableRatio;

    public static SignPathValue parse(String string) {
        SignPathValue signPathValue = null;
        if (string != null && !string.isEmpty()) {
            OZBase64Loader oZBase64Loader = new OZBase64Loader();
            oZBase64Loader.parse(string);
            if (oZBase64Loader.hasPath()) {
                signPathValue = new SignPathValue(oZBase64Loader.getAsPath());
            } else if (oZBase64Loader.hasImage()) {
                signPathValue = new SignPathValue(oZBase64Loader.getAsImage());
            }
        }
        return signPathValue;
    }

    public static SignPathValue saveAsKeepRatio(ISignPathValue iSignPathValue, float f2) {
        OZSignPath oZSignPath;
        if (iSignPathValue != null && f2 > 0.0f && (oZSignPath = iSignPathValue.getValueAsSignPath()) != null && !oZSignPath.isRecycled() && !oZSignPath.isEmptyPath()) {
            String string = oZSignPath.getPathString("");
            OZSignPath oZSignPath2 = new OZSignPath(string);
            oZSignPath2.toKeepRatio(f2, 1.0f);
            return new SignPathValue(oZSignPath2);
        }
        return null;
    }

    public static SignPathValue saveAsFitToFrame(ISignPathValue iSignPathValue) {
        OZSignPath oZSignPath;
        if (iSignPathValue != null && (oZSignPath = iSignPathValue.getValueAsSignPath()) != null && !oZSignPath.isRecycled() && !oZSignPath.isEmptyPath()) {
            String string = oZSignPath.getPathString("");
            OZSignPath oZSignPath2 = new OZSignPath(string);
            if (oZSignPath2.toFitToFrame()) {
                return new SignPathValue(oZSignPath2);
            }
            oZSignPath2.recycle();
        }
        return null;
    }

    public static SignPathValue saveAsFrameInfoKeepRatio(ISignPathValue iSignPathValue, float f2, float f3, float f4) {
        OZSignPath oZSignPath;
        if (iSignPathValue != null && f2 > 0.0f && f3 > 0.0f && f4 > 0.0f && (oZSignPath = iSignPathValue.getValueAsSignPath()) != null && !oZSignPath.isRecycled() && !oZSignPath.isEmptyPath()) {
            String string = oZSignPath.getPathString();
            OZSignPath oZSignPath2 = new OZSignPath(string);
            if (oZSignPath2.toFrameInfoFitToFrame(f2, f3, f4, 1.0f)) {
                return new SignPathValue(oZSignPath2);
            }
            oZSignPath2.recycle();
        }
        return null;
    }

    public SignPathValue() {
    }

    public SignPathValue(Bitmap bitmap) {
        this();
        if (bitmap != null && !bitmap.isRecycled()) {
            this.mType = 32;
            this.mObj = bitmap;
            this.mBitmap = bitmap;
        }
    }

    public SignPathValue(OZSignPath oZSignPath) {
        this();
        if (oZSignPath != null && !oZSignPath.isRecycled()) {
            this.mType = 16;
            this.mObj = oZSignPath;
            this.mPath = oZSignPath;
        }
    }

    public int getType() {
        return this.mType;
    }

    public Object getValue() {
        return this.mObj;
    }

    public OZSignPath getValueAsSignPath() {
        return this.mPath;
    }

    public Bitmap getValueAsBitmap() {
        return this.mBitmap;
    }

    public ISignPathEditableValue toEditable() {
        if (this.mPath != null) {
            return this;
        }
        return null;
    }

    public void recycle() {
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
        if (this.mPath != null) {
            this.mPath.recycle();
            this.mPath = null;
        }
        if (this.mEditablePath != null) {
            this.mEditablePath.recycle();
            this.mEditablePath = null;
        }
    }

    public OZSignPath createEditableSignPath(float f2) {
        int n = (int)(f2 * 10000.0f);
        int n2 = (int)(this.mEditableRatio * 10000.0f);
        if (this.mEditablePath != null && !this.mEditablePath.isRecycled() && n == n2) {
            return this.mEditablePath;
        }
        if (this.mPath != null && !this.mPath.isRecycled() && f2 > 0.0f) {
            float f3 = this.mPath.getMeta().getRatio();
            int n3 = (int)(f3 * 10000.0f);
            if (n == n3) {
                this.mEditablePath = new OZSignPath(this.mPath.getPathString(null));
                this.mEditableRatio = f3;
            } else if (f3 == 0.0f) {
                OZSignPathMeta oZSignPathMeta = new OZSignPathMeta();
                oZSignPathMeta.setRatio(f2);
                this.mEditablePath = new OZSignPath(this.mPath.getPathString(null), oZSignPathMeta);
                this.mEditableRatio = f2;
            } else {
                this.mEditablePath = new OZSignPath(this.mPath.getPathString(null));
                this.mEditablePath.toKeepRatio(f2, 1.0f);
                this.mEditableRatio = f2;
            }
        }
        return this.mEditablePath;
    }

    public OZSignPath getEditableSignPath() {
        return this.mEditablePath;
    }

    public void commit() {
        if (this.mEditablePath != null) {
            if (this.mPath != null) {
                this.mPath.recycle();
            }
            this.mPath = this.mEditablePath;
            this.mEditablePath = null;
            this.mEditableRatio = 0.0f;
        }
    }

    protected void finalize() {
        super.finalize();
        this.recycle();
    }
}

