/*
 * Decompiled with CFR 0.152.
 */
package oz.util.signpath.view.render;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.RectF;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import oz.client.shape.ui.data.OZSignPadGuideLineData;
import oz.util.signpath.view.model.ISignPathValue;
import oz.util.signpath.view.render.RenderData;
import oz.util.signpath.view.render.RenderItem;

public class RenderGuideLineItem
implements RenderItem {
    private OZSignPadGuideLineData mGuideLineData;
    private Paint mGuideLinePaint;
    private RectF mGuideLineRect;
    private float DpPerPx;

    private void initGuideLineOptions(OZSignPadGuideLineData oZSignPadGuideLineData) {
        this.mGuideLineData = oZSignPadGuideLineData;
        if (this.mGuideLineData != null) {
            if (this.mGuideLineData.getShapeType() > 1 && this.mGuideLineData.isValid()) {
                this.mGuideLinePaint = new Paint(1);
                this.mGuideLinePaint.setColor(this.mGuideLineData.getColor());
                this.mGuideLinePaint.setStyle(Paint.Style.STROKE);
                this.mGuideLinePaint.setStrokeWidth(this.mGuideLineData.getThickness() * this.DpPerPx);
                if (this.mGuideLineData.getLineType() == 1) {
                    this.mGuideLinePaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{this.getGuideLineDashWidth(), this.getGuideLineBlankWidth()}, 0.0f));
                }
            } else {
                this.mGuideLineData = null;
            }
        }
    }

    private float getGuideLineDashWidth() {
        return Math.max(12.0f * this.DpPerPx, this.mGuideLinePaint.getStrokeWidth());
    }

    private float getGuideLineBlankWidth() {
        return this.getGuideLineDashWidth() * 0.5f;
    }

    private void updateGuideLineRect(int n, int n2) {
        if (this.mGuideLineData != null) {
            int n3 = (int)((float)n * 0.05f);
            int n4 = n2 / 4;
            int n5 = n4 * 3;
            switch (this.mGuideLineData.getShapeType()) {
                default: 
            }
            if (this.mGuideLineData.getLineType() == 1) {
                float f2 = this.getGuideLineDashWidth();
                float f3 = this.getGuideLineBlankWidth();
                float f4 = (float)(n - 2 * n3) - f2;
                float f5 = (float)(n5 - n4) - f2;
                float f6 = f4 % (f2 + f3);
                float f7 = (f5 + this.mGuideLinePaint.getStrokeWidth()) % (f2 + f3);
                float f8 = f2 + f3;
                if ((float)n3 < f8 * 2.0f) {
                    f8 = -f8;
                }
                if (f6 > (f2 + f3) / 2.0f) {
                    f6 -= f8;
                }
                if (f7 > (f2 + f3) / 2.0f) {
                    f7 -= f8;
                }
                this.mGuideLineRect.set((float)n3 + f6 / 2.0f, (float)n4 + f7 / 2.0f, (float)(n - n3) - f6 / 2.0f, (float)n5 - f7 / 2.0f);
            } else {
                this.mGuideLineRect.set((float)n3, (float)n4, (float)(n - n3), (float)n5);
            }
        }
    }

    public void drawNewLine(RenderData renderData, ISignPathValue iSignPathValue) {
    }

    public void invalidate(RenderData renderData) {
        if (this.mGuideLineRect == null) {
            this.mGuideLineRect = new RectF();
            this.DpPerPx = TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)renderData.view.getContext().getResources().getDisplayMetrics());
        }
        this.initGuideLineOptions(renderData.setting.getGuideLineData());
        this.updateGuideLineRect(renderData.rect.width(), renderData.rect.height());
        this.mGuideLineRect.offset((float)renderData.rect.left, (float)renderData.rect.top);
    }

    public void draw(RenderData renderData, Canvas canvas) {
        if (this.mGuideLineData != null && !this.mGuideLineRect.isEmpty()) {
            switch (this.mGuideLineData.getShapeType()) {
                case 3: {
                    if (this.mGuideLineData.getLineType() == 1) {
                        canvas.drawLine(this.mGuideLineRect.left, this.mGuideLineRect.bottom, this.mGuideLineRect.right, this.mGuideLineRect.bottom, this.mGuideLinePaint);
                        canvas.drawLine(this.mGuideLineRect.left, this.mGuideLineRect.top, this.mGuideLineRect.right, this.mGuideLineRect.top, this.mGuideLinePaint);
                        float f2 = this.getGuideLineDashWidth();
                        float f3 = this.getGuideLineBlankWidth();
                        if (!(this.mGuideLineRect.height() > f2 + f3)) break;
                        float f4 = this.mGuideLinePaint.getStrokeWidth() / 2.0f;
                        float f5 = f2 - this.mGuideLinePaint.getStrokeWidth() % (f2 + f3);
                        canvas.drawLine(this.mGuideLineRect.left + f4, this.mGuideLineRect.top + f4 + f5 + f3, this.mGuideLineRect.left + f4, this.mGuideLineRect.bottom - f4 - f5 - f3, this.mGuideLinePaint);
                        canvas.drawLine(this.mGuideLineRect.right - f4, this.mGuideLineRect.top + f4 + f5 + f3, this.mGuideLineRect.right - f4, this.mGuideLineRect.bottom - f4 - f5 - f3, this.mGuideLinePaint);
                        if (f5 == 0.0f) break;
                        canvas.drawLine(this.mGuideLineRect.left + f4, this.mGuideLineRect.top + f4, this.mGuideLineRect.left + f4, this.mGuideLineRect.top + f4 + f5, this.mGuideLinePaint);
                        canvas.drawLine(this.mGuideLineRect.left + f4, this.mGuideLineRect.bottom - f4 - f5, this.mGuideLineRect.left + f4, this.mGuideLineRect.bottom - f4, this.mGuideLinePaint);
                        canvas.drawLine(this.mGuideLineRect.right - f4, this.mGuideLineRect.top + f4, this.mGuideLineRect.right - f4, this.mGuideLineRect.top + f4 + f5, this.mGuideLinePaint);
                        canvas.drawLine(this.mGuideLineRect.right - f4, this.mGuideLineRect.bottom - f4 - f5, this.mGuideLineRect.right - f4, this.mGuideLineRect.bottom - f4, this.mGuideLinePaint);
                        break;
                    }
                    canvas.drawRect(this.mGuideLineRect, this.mGuideLinePaint);
                    break;
                }
                case 2: {
                    canvas.drawLine(this.mGuideLineRect.left, this.mGuideLineRect.bottom, this.mGuideLineRect.right, this.mGuideLineRect.bottom, this.mGuideLinePaint);
                    break;
                }
            }
        }
    }
}

