/*
 * Decompiled with CFR 0.152.
 */
package oz.util.signpath.view.render;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.os.Build;
import oz.util.signpath.OZSignPath;
import oz.util.signpath.view.model.ISignPathSetting;
import oz.util.signpath.view.model.ISignPathValue;
import oz.util.signpath.view.render.RenderData;
import oz.util.signpath.view.render.RenderItem;

public class RenderSignPathItem
implements RenderItem {
    private OZSignPath mPath;
    private Path mRenderPath;
    private Paint mRenderPaint;
    private Rect mRenderRect;
    private float mRenderThick;

    public void setPath(OZSignPath oZSignPath) {
        if (this.mPath != oZSignPath) {
            this.mPath = oZSignPath;
        }
    }

    public void setRenderThick(float f2) {
        this.mRenderThick = f2;
    }

    public void setRenderPaintBlendMode(PorterDuff.Mode mode) {
        if (this.mRenderPaint != null) {
            this.mRenderPaint.setXfermode((Xfermode)new PorterDuffXfermode(mode));
        }
    }

    private void initRender() {
        if (this.mRenderPath == null) {
            this.mRenderPath = new Path();
            this.mRenderPaint = new Paint();
            this.mRenderPaint.setAntiAlias(true);
            this.mRenderPaint.setStrokeJoin(Paint.Join.ROUND);
            this.mRenderPaint.setStrokeCap(Paint.Cap.ROUND);
            if (Build.VERSION.SDK_INT >= 26) {
                this.setRenderPaintBlendMode(PorterDuff.Mode.SRC);
            }
            this.mRenderRect = new Rect();
        }
    }

    private void initPaint(int n, float f2, int n2) {
        this.mRenderPaint.setColor(n);
        if (n2 == 1) {
            this.mRenderPaint.setStyle(Paint.Style.FILL);
        } else {
            this.mRenderPaint.setStyle(Paint.Style.STROKE);
        }
        this.mRenderPaint.setStrokeWidth(f2);
    }

    public void drawPath(ISignPathSetting iSignPathSetting, Canvas canvas, OZSignPath oZSignPath, Rect rect) {
        this.setPath(oZSignPath);
        this.drawPath(iSignPathSetting, canvas, rect);
    }

    public void drawPath(ISignPathSetting iSignPathSetting, Canvas canvas, Rect rect) {
        OZSignPath oZSignPath = this.mPath;
        if (iSignPathSetting != null && oZSignPath != null && !oZSignPath.isRecycled()) {
            int n = canvas.getWidth();
            int n2 = canvas.getHeight();
            int n3 = iSignPathSetting.getThicknessColor();
            float f2 = this.mRenderThick > 0.0f ? this.mRenderThick * iSignPathSetting.getMetaThicknessScale() : iSignPathSetting.getThickness() * iSignPathSetting.getThicknessScale();
            canvas.save();
            if (rect != null && !rect.isEmpty()) {
                this.mRenderRect.set(rect);
            } else {
                this.mRenderRect.set(0, 0, n, n2);
            }
            canvas.clipRect(this.mRenderRect);
            canvas.translate((float)this.mRenderRect.left, (float)this.mRenderRect.top);
            this.initPaint(n3, f2, oZSignPath.getMeta().getRenderType());
            this.mRenderPath.reset();
            oZSignPath.renderPath(this.mRenderPath, 0.0f, 0.0f, this.mRenderRect.width(), this.mRenderRect.height(), f2);
            canvas.drawPath(this.mRenderPath, this.mRenderPaint);
            canvas.restore();
        }
    }

    public void drawNewLine(RenderData renderData, ISignPathValue iSignPathValue) {
    }

    public void invalidate(RenderData renderData) {
        this.initRender();
    }

    public void draw(RenderData renderData, Canvas canvas) {
        this.drawPath(renderData.setting, canvas, renderData.rect);
    }
}

