/*
 * Decompiled with CFR 0.152.
 */
package oz.util.signpath.view.render;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import oz.util.signpath.OZSignPath;
import oz.util.signpath.view.model.ISignPathSetting;
import oz.util.signpath.view.model.ISignPathValue;
import oz.util.signpath.view.render.RenderData;
import oz.util.signpath.view.render.RenderSignPathItem;

public class RenderSignValueBitmapCacheItem
extends RenderSignPathItem {
    private static final long BITMAP_MAX_SIZE = 0x1400000L;
    private static final int BITMAP_MAX_WIDTH = 15000;
    private static final int BITMAP_MAX_HEIGHT = 15000;
    private Rect mCacheRect = new Rect();
    private int mCacheWidth;
    private int mCacheHeight;
    private float mCacheScale;
    private Bitmap mCacheBitmap;
    private boolean mRedrawCacheBitmap;

    private static float getBitmapScale(int n, int n2) {
        float f2 = 1.0f;
        long l = n * n2 * 4;
        if (l > 0x1400000L) {
            f2 = (float)((double)l / 2.097152E7);
        }
        if (f2 > 0.0f) {
            int n3 = (int)((float)n / f2);
            int n4 = (int)((float)n2 / f2);
            while (n3 > 15000 || n4 > 15000) {
                n3 = (int)((float)n / (f2 *= 1.05f));
                n4 = (int)((float)n2 / f2);
            }
        }
        return f2;
    }

    private void updateBitmapCache(int n, int n2, ISignPathValue iSignPathValue) {
        if (iSignPathValue == null || n == 0 || n2 == 0) {
            this.mCacheBitmap = null;
            this.mCacheWidth = 0;
            this.mCacheHeight = 0;
            this.mRedrawCacheBitmap = false;
        } else if (this.mCacheBitmap == null || this.mCacheWidth != n || this.mCacheHeight != n2) {
            Bitmap bitmap = this.mCacheBitmap;
            if (bitmap != null) {
                bitmap.recycle();
            }
            this.mCacheScale = RenderSignValueBitmapCacheItem.getBitmapScale(this.mCacheWidth, this.mCacheHeight);
            int n3 = Math.max(1, (int)((float)n / this.mCacheScale));
            int n4 = Math.max(1, (int)((float)n2 / this.mCacheScale));
            this.mCacheBitmap = Bitmap.createBitmap((int)n3, (int)n4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mCacheWidth = n;
            this.mCacheHeight = n2;
            this.mRedrawCacheBitmap = true;
        }
    }

    public void drawBitmap(Canvas canvas, Bitmap bitmap, Rect rect) {
        if (canvas != null && bitmap != null && !bitmap.isRecycled()) {
            float f2;
            boolean bl;
            RectF rectF = new RectF(rect);
            Rect rect2 = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
            float f3 = rectF.width() / (float)bitmap.getWidth();
            boolean bl2 = bl = !(f3 > (f2 = rectF.height() / (float)bitmap.getHeight()));
            if (bl) {
                float f4 = (rectF.bottom - f3 * (float)rect2.bottom) / 2.0f;
                rectF.top += f4;
                rectF.bottom -= f4;
            } else {
                float f5 = (rectF.right - f2 * (float)rect2.right) / 2.0f;
                rectF.left += f5;
                rectF.right -= f5;
            }
            canvas.drawBitmap(bitmap, rect2, rectF, null);
        }
    }

    public void drawCacheBitmap(ISignPathSetting iSignPathSetting, ISignPathValue iSignPathValue, Rect rect, Bitmap bitmap, boolean bl) {
        if (iSignPathValue != null && bitmap != null) {
            Canvas canvas = new Canvas(bitmap);
            Rect rect2 = new Rect(rect);
            rect2.offset(-rect2.left, -rect2.top);
            if (bl) {
                canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            }
            if (this.mCacheScale != 1.0f) {
                canvas.scale(this.mCacheScale, this.mCacheScale);
            }
            if (iSignPathValue.getType() == 32) {
                this.drawBitmap(canvas, iSignPathValue.getValueAsBitmap(), rect2);
            } else {
                this.drawPath(iSignPathSetting, canvas, iSignPathValue.getValueAsSignPath(), rect2);
            }
        }
    }

    public void drawNewLine(RenderData renderData, ISignPathValue iSignPathValue) {
        this.drawCacheBitmap(renderData.setting, iSignPathValue, renderData.rect, this.mCacheBitmap, false);
    }

    public void invalidate(RenderData renderData) {
        super.invalidate(renderData);
        this.mRedrawCacheBitmap = true;
        if (renderData.value != null && renderData.value.getValueAsSignPath() != null) {
            OZSignPath oZSignPath = renderData.value.getValueAsSignPath();
            if (!oZSignPath.isRecycled()) {
                this.setRenderThick(oZSignPath.getMeta().getPenThick());
            }
        } else {
            this.setRenderThick(renderData.setting.getMetaThickness());
        }
    }

    public void draw(RenderData renderData, Canvas canvas) {
        boolean bl;
        this.updateBitmapCache(renderData.rect.width(), renderData.rect.height(), renderData.value);
        Bitmap bitmap = this.mCacheBitmap;
        boolean bl2 = bl = Color.alpha((int)renderData.setting.getThicknessColor()) < 255 && renderData.currentLineValue != null;
        if (bl) {
            canvas.saveLayer((float)renderData.rect.left, (float)renderData.rect.top, (float)renderData.rect.right, (float)renderData.rect.bottom, null);
        }
        if (bitmap != null) {
            if (this.mRedrawCacheBitmap) {
                this.mRedrawCacheBitmap = false;
                this.drawCacheBitmap(renderData.setting, renderData.value, renderData.rect, this.mCacheBitmap, true);
            }
            this.mCacheRect.set(0, 0, bitmap.getWidth(), bitmap.getHeight());
            canvas.drawBitmap(bitmap, this.mCacheRect, renderData.rect, null);
        }
        if (renderData.currentLineValue != null) {
            for (ISignPathValue iSignPathValue : renderData.currentLineValue) {
                if (iSignPathValue == null) continue;
                this.drawPath(renderData.setting, canvas, iSignPathValue.getValueAsSignPath(), renderData.rect);
            }
        }
        if (bl) {
            canvas.restore();
        }
    }
}

