/*
 * Decompiled with CFR 0.152.
 */
package oz.util.view.animatable;

import android.content.Context;
import android.os.Looper;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import oz.util.view.animatable.AnimatableFrameLayout$DoJob;
import oz.util.view.animatable.AnimatableFrameLayout$MoveJob;
import oz.util.view.animatable.AnimatableFrameLayout$OnMoveListener;

public class AnimatableFrameLayout
extends FrameLayout {
    private boolean mTouchDisable;
    private boolean mIsReverseMove;
    private int mMoveDuration;
    private AnimatableFrameLayout$OnMoveListener mListener;
    private View mOldView;
    private View mNextView;
    private AnimatableFrameLayout$MoveJob mCurrentJob;
    private Object mMoveJobLock;
    private Runnable mDoJob;
    private int mContextVerticalAlign;

    public AnimatableFrameLayout(Context context) {
        super(context);
        this.init();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mTouchDisable) {
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    private void init() {
        this.setWillNotDraw(false);
        this.mDoJob = new AnimatableFrameLayout$DoJob(this, null);
        this.mIsReverseMove = false;
        this.mMoveDuration = 0;
        this.mTouchDisable = false;
        this.mMoveJobLock = new Object();
        this.mContextVerticalAlign = 0;
    }

    public void setContextVerticalAlign(int n) {
        this.mContextVerticalAlign = n;
    }

    public int getContextVerticalAlign() {
        return this.mContextVerticalAlign;
    }

    private Object getMoveJobLock() {
        return this.mMoveJobLock;
    }

    public void setTouchDisable(boolean bl) {
        this.mTouchDisable = bl;
    }

    public boolean isTouchDisable() {
        return this.mTouchDisable;
    }

    private void createNewJob() {
        this.mCurrentJob = new AnimatableFrameLayout$MoveJob(this);
        this.mCurrentJob.oldView = this.mOldView;
        this.mCurrentJob.nextView = this.mNextView;
        this.mCurrentJob.duration = this.mMoveDuration;
        this.mCurrentJob.reverse = this.mIsReverseMove;
    }

    public void setMoveListener(AnimatableFrameLayout$OnMoveListener animatableFrameLayout$OnMoveListener) {
        this.mListener = animatableFrameLayout$OnMoveListener;
    }

    public AnimatableFrameLayout$OnMoveListener getMoveListener() {
        return this.mListener;
    }

    public void setOldView(View view) {
        this.mOldView = view;
    }

    public void setNextView(View view) {
        this.mNextView = view;
    }

    public void setIsNextViewReverse(boolean bl) {
        this.mIsReverseMove = bl;
    }

    public void setMoveDuration(int n) {
        this.mMoveDuration = n;
    }

    public void doMoveNextView() {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            this.mDoJob.run();
        } else {
            this.post(this.mDoJob);
        }
    }

    static /* synthetic */ Object access$000(AnimatableFrameLayout animatableFrameLayout) {
        return animatableFrameLayout.mMoveJobLock;
    }

    static /* synthetic */ void access$100(AnimatableFrameLayout animatableFrameLayout) {
        animatableFrameLayout.createNewJob();
    }

    static /* synthetic */ AnimatableFrameLayout$MoveJob access$200(AnimatableFrameLayout animatableFrameLayout) {
        return animatableFrameLayout.mCurrentJob;
    }

    static /* synthetic */ Object access$300(AnimatableFrameLayout animatableFrameLayout) {
        return animatableFrameLayout.getMoveJobLock();
    }
}

